/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.typechecker;

import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;

public class TypeParameters {
    private final String[] identifiers;
    private final boolean preserveOrder;
    private final int[] placeHolders;
    private int[] order;
    private int numUsed;

    public TypeParameters(String[] stringArray) {
        this(stringArray, false);
    }

    public TypeParameters(String[] stringArray, boolean bl) {
        this.identifiers = stringArray;
        this.preserveOrder = bl;
        this.numUsed = 0;
        this.placeHolders = new int[this.identifiers.length];
        int n = 0;
        while (n < this.placeHolders.length) {
            this.placeHolders[n] = -1;
            ++n;
        }
        if (bl) {
            this.order = new int[this.identifiers.length];
        }
    }

    public BoogieType findType(String string, int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.identifiers.length) {
            if (this.identifiers[n2].equals(string)) {
                if (this.placeHolders[n2] < 0) {
                    if (!bl) {
                        return BoogieType.TYPE_ERROR;
                    }
                    int n3 = this.placeHolders[n2] = this.preserveOrder ? n2 : this.numUsed;
                    if (this.preserveOrder) {
                        this.order[this.numUsed] = n2;
                    }
                    ++this.numUsed;
                }
                return BoogieType.createPlaceholderType(this.placeHolders[n2] + n);
            }
            ++n2;
        }
        return null;
    }

    public boolean fullyUsed() {
        return this.numUsed == this.identifiers.length;
    }

    public int[] getOrder() {
        return this.order;
    }

    public int getNumUsed() {
        return this.numUsed;
    }

    public int getCount() {
        return this.placeHolders.length;
    }
}

