/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.LassoConstructor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.Summary;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.StateBasedTransitionFilterPredicateProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.FilteredIterable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IteratorConcatenation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputationNonRecursive;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AcceptingComponentsAnalysis<LETTER, STATE> {
    private static final String LOOP = " loop";
    private static final boolean USE_ALTERNATIVE_LASSO_CONSTRUCTION = false;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mNwars;
    private final StateBasedTransitionFilterPredicateProvider<LETTER, STATE> mTransitionFilter;
    private final HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> mAcceptingSummaries;
    private final Set<StateContainer<LETTER, STATE>> mAllStatesOfSccsWithoutCallAndReturn = new HashSet<StateContainer<LETTER, STATE>>();
    private List<NestedLassoRun<LETTER, STATE>> mNestedLassoRuns;
    private NestedLassoRun<LETTER, STATE> mNestedLassoRun;
    private final SccComputation<StateContainer<LETTER, STATE>, StronglyConnectedComponentWithAcceptanceInformation<LETTER, STATE>> mSccComputation;
    private int mAcceptingBalls;
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final StronglyConnectedComponentWithAcceptanceInformation_Factory mScComponentFactory;
    private final InSumCaSuccessorProvider mNwarsSuccessorProvider;

    public AcceptingComponentsAnalysis(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, NestedWordAutomatonReachableStates.AcceptingSummariesComputation acceptingSummariesComputation, Set<STATE> set, Set<STATE> set2) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mNwars = nestedWordAutomatonReachableStates;
        this.mScComponentFactory = new StronglyConnectedComponentWithAcceptanceInformation_Factory(nestedWordAutomatonReachableStates);
        this.mNwarsSuccessorProvider = new InSumCaSuccessorProvider(nestedWordAutomatonReachableStates, set);
        HashSet<StateContainer<LETTER, STATE>> hashSet = new HashSet<StateContainer<LETTER, STATE>>();
        for (Object object : set2) {
            StateContainer<LETTER, STATE> stateContainer = nestedWordAutomatonReachableStates.getStateContainer(object);
            hashSet.add(stateContainer);
        }
        this.mSccComputation = new SccComputationNonRecursive(this.mLogger, (SccComputation.ISuccessorProvider)this.mNwarsSuccessorProvider, (SccComputation.IStronglyConnectedComponentFactory)this.mScComponentFactory, set.size(), hashSet);
        this.mTransitionFilter = new StateBasedTransitionFilterPredicateProvider(set);
        this.mAcceptingSummaries = acceptingSummariesComputation.getAcceptingSummaries();
        for (Object object : this.mSccComputation.getBalls()) {
            if (!((StronglyConnectedComponentWithAcceptanceInformation)((Object)object)).isAccepting()) continue;
            this.mAllStatesOfSccsWithoutCallAndReturn.addAll(object.getNodes());
            ++this.mAcceptingBalls;
        }
        this.mLogger.info((Object)("Automaton has " + this.mAcceptingBalls + " accepting balls. " + this.mAllStatesOfSccsWithoutCallAndReturn.size()));
    }

    Set<StateContainer<LETTER, STATE>> getStatesOfAllSccs() {
        return this.mAllStatesOfSccsWithoutCallAndReturn;
    }

    int getNumberOfAllSccs() {
        return this.mSccComputation.getSCCs().size();
    }

    public boolean buchiIsEmpty() {
        return this.mAcceptingBalls == 0;
    }

    public SccComputation<StateContainer<LETTER, STATE>, StronglyConnectedComponentWithAcceptanceInformation<LETTER, STATE>> getSccComputation() {
        return this.mSccComputation;
    }

    public List<NestedLassoRun<LETTER, STATE>> computeOneNestedLassoRunPerScc() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<NestedLassoRun<LETTER, STATE>> computeNestedLassoRuns() throws AutomataOperationCanceledException {
        ArrayList<NestedLassoRun<LETTER, STATE>> arrayList = new ArrayList<NestedLassoRun<LETTER, STATE>>();
        for (StronglyConnectedComponentWithAcceptanceInformation stronglyConnectedComponentWithAcceptanceInformation : this.getSccComputation().getBalls()) {
            Object object;
            if (!stronglyConnectedComponentWithAcceptanceInformation.isAccepting()) continue;
            for (StateContainer stateContainer : stronglyConnectedComponentWithAcceptanceInformation.getAcceptingStatesContainers()) {
                object = new LassoConstructor<LETTER, STATE>(this.mServices, this.mNwars, stateContainer, stronglyConnectedComponentWithAcceptanceInformation).getNestedLassoRun();
                arrayList.add((NestedLassoRun<LETTER, STATE>)object);
            }
            for (StateContainer stateContainer : stronglyConnectedComponentWithAcceptanceInformation.getAcceptingSummariesOfScc().getDomain()) {
                object = stronglyConnectedComponentWithAcceptanceInformation.getAcceptingSummariesOfScc().getImage(stateContainer);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Summary summary = (Summary)iterator.next();
                    NestedLassoRun<LETTER, STATE> nestedLassoRun = new LassoConstructor<LETTER, STATE>(this.mServices, this.mNwars, summary, stronglyConnectedComponentWithAcceptanceInformation).getNestedLassoRun();
                    this.computeNestedLassoRunsHelper(stateContainer, nestedLassoRun);
                    arrayList.add(nestedLassoRun);
                }
            }
        }
        return arrayList;
    }

    private void computeNestedLassoRunsHelper(StateContainer<LETTER, STATE> stateContainer, NestedLassoRun<LETTER, STATE> nestedLassoRun) {
    }

    public void computeShortNestedLassoRun() throws AutomataOperationCanceledException {
        Object object3;
        StateContainer stateContainer = null;
        Object object2 = null;
        for (Object object3 : this.getSccComputation().getBalls()) {
            StateContainer stateContainer2;
            StateContainer stateContainer3;
            if (!object3.isAccepting() || (stateContainer3 = StateContainer.returnLower(stateContainer, stateContainer2 = object3.getAcceptingWithLowestSerialNumber())) == stateContainer) continue;
            stateContainer = stateContainer3;
            object2 = object3;
        }
        object3 = new LassoConstructor<LETTER, STATE>(this.mServices, this.mNwars, stateContainer, object2).getNestedLassoRun();
        this.mLogger.debug((Object)("Method4: stem" + ((NestedLassoRun)object3).getStem().getLength() + LOOP + ((NestedLassoRun)object3).getLoop().getLength()));
        this.mNestedLassoRun = object3;
    }

    public List<NestedLassoRun<LETTER, STATE>> getAllNestedLassoRuns() throws AutomataOperationCanceledException {
        if (this.buchiIsEmpty()) {
            return Collections.emptyList();
        }
        if (this.mNestedLassoRuns == null) {
            this.mNestedLassoRuns = this.computeNestedLassoRuns();
        }
        return this.mNestedLassoRuns;
    }

    public NestedLassoRun<LETTER, STATE> getNestedLassoRun() throws AutomataOperationCanceledException {
        if (this.buchiIsEmpty()) {
            return null;
        }
        if (this.mNestedLassoRun == null) {
            this.computeShortNestedLassoRun();
        }
        return this.mNestedLassoRun;
    }

    private class InSumCaSuccessorProvider
    implements SccComputation.ISuccessorProvider<StateContainer<LETTER, STATE>> {
        protected final NestedWordAutomatonReachableStates<LETTER, STATE> mNwarsInner;
        private final StateBasedTransitionFilterPredicateProvider<LETTER, STATE> mTransitionFilterInner;

        public InSumCaSuccessorProvider(NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, Set<STATE> set) {
            this.mNwarsInner = nestedWordAutomatonReachableStates;
            this.mTransitionFilterInner = new StateBasedTransitionFilterPredicateProvider(set);
        }

        private <E extends IOutgoingTransitionlet<LETTER, STATE>> Iterator<StateContainer<LETTER, STATE>> getStateContainerIterator(final Iterator<E> iterator) {
            return new Iterator<StateContainer<LETTER, STATE>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public StateContainer<LETTER, STATE> next() {
                    return InSumCaSuccessorProvider.this.mNwarsInner.getStateContainer(((IOutgoingTransitionlet)iterator.next()).getSucc());
                }
            };
        }

        public Iterator<StateContainer<LETTER, STATE>> getSuccessors(StateContainer<LETTER, STATE> stateContainer) {
            Iterator iterator = this.getStateContainerIterator(new FilteredIterable(stateContainer.internalSuccessors(), this.mTransitionFilterInner.getInternalSuccessorPredicate()).iterator());
            Iterator iterator2 = this.getStateContainerIterator(new FilteredIterable(this.mNwarsInner.summarySuccessors(stateContainer.getState()), this.mTransitionFilterInner.getReturnSummaryPredicate()).iterator());
            Iterator iterator3 = this.getStateContainerIterator(new FilteredIterable(stateContainer.callSuccessors(), this.mTransitionFilterInner.getCallSuccessorPredicate()).iterator());
            Iterator[] iteratorArray = new Iterator[]{iterator, iterator2, iterator3};
            return new IteratorConcatenation(Arrays.asList(iteratorArray));
        }
    }

    public static class StronglyConnectedComponentWithAcceptanceInformation<LETTER, STATE>
    extends StronglyConnectedComponent<StateContainer<LETTER, STATE>> {
        private final Set<StateContainer<LETTER, STATE>> mAcceptingStates = new HashSet<StateContainer<LETTER, STATE>>();
        private final NestedWordAutomatonReachableStates<LETTER, STATE> mNestedWordAutomatonReachableStates;
        private Set<StateContainer<LETTER, STATE>> mHasOutgoingAcceptingSum = new HashSet<StateContainer<LETTER, STATE>>();
        private final HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> mAcceptingSummariesOfScc = new HashRelation();
        private StateContainer<LETTER, STATE> mStateWithLowestSerialNumber;
        private StateContainer<LETTER, STATE> mAcceptingWithLowestSerialNumber;

        public StronglyConnectedComponentWithAcceptanceInformation(NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates) {
            this.mNestedWordAutomatonReachableStates = nestedWordAutomatonReachableStates;
        }

        public void addNode(StateContainer<LETTER, STATE> stateContainer) {
            super.addNode(stateContainer);
            this.mStateWithLowestSerialNumber = StateContainer.returnLower(this.mStateWithLowestSerialNumber, stateContainer);
            if (this.mNestedWordAutomatonReachableStates.isFinal(stateContainer.getState())) {
                this.mAcceptingStates.add(stateContainer);
                this.mAcceptingWithLowestSerialNumber = StateContainer.returnLower(this.mAcceptingWithLowestSerialNumber, stateContainer);
            }
            if (this.mNestedWordAutomatonReachableStates.getAcceptingSummariesComputation().getAcceptingSummaries().getDomain().contains(stateContainer)) {
                this.mHasOutgoingAcceptingSum.add(stateContainer);
            }
        }

        public void setRootNode(StateContainer<LETTER, STATE> stateContainer) {
            if (this.mRootNode != null) {
                throw new UnsupportedOperationException("If root node is set SCC may not be modified");
            }
            this.mRootNode = stateContainer;
            for (StateContainer<LETTER, STATE> stateContainer2 : this.mHasOutgoingAcceptingSum) {
                for (Summary summary : this.mNestedWordAutomatonReachableStates.getAcceptingSummariesComputation().getAcceptingSummaries().getImage(stateContainer2)) {
                    if (!this.mNodes.contains(summary.getSucc())) continue;
                    this.mAcceptingWithLowestSerialNumber = StateContainer.returnLower(this.mAcceptingWithLowestSerialNumber, stateContainer2);
                    this.mAcceptingSummariesOfScc.addPair(stateContainer2, (Object)summary);
                }
            }
            this.mHasOutgoingAcceptingSum = null;
        }

        public Set<StateContainer<LETTER, STATE>> getAcceptingStatesContainers() {
            return this.mAcceptingStates;
        }

        public HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> getAcceptingSummariesOfScc() {
            return this.mAcceptingSummariesOfScc;
        }

        public StateContainer<LETTER, STATE> getStateWithLowestSerialNumber() {
            return this.mStateWithLowestSerialNumber;
        }

        public boolean isAccepting() {
            return this.mAcceptingWithLowestSerialNumber != null;
        }

        public StateContainer<LETTER, STATE> getAcceptingWithLowestSerialNumber() {
            return this.mAcceptingWithLowestSerialNumber;
        }

        public Set<STATE> getAllStates() {
            HashSet hashSet = new HashSet();
            for (StateContainer stateContainer : this.mNodes) {
                hashSet.add(stateContainer.getState());
            }
            return hashSet;
        }
    }

    private class StronglyConnectedComponentWithAcceptanceInformation_Factory
    implements SccComputation.IStronglyConnectedComponentFactory<StateContainer<LETTER, STATE>, StronglyConnectedComponentWithAcceptanceInformation<LETTER, STATE>> {
        private final NestedWordAutomatonReachableStates<LETTER, STATE> mNwarsInner;

        public StronglyConnectedComponentWithAcceptanceInformation_Factory(NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates) {
            this.mNwarsInner = nestedWordAutomatonReachableStates;
        }

        public StronglyConnectedComponentWithAcceptanceInformation<LETTER, STATE> constructNewSCComponent() {
            return new StronglyConnectedComponentWithAcceptanceInformation(this.mNwarsInner);
        }
    }
}

