/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Configuration<LETTER, PLACE>
implements Iterable<Event<LETTER, PLACE>> {
    private static final boolean USE_DEPTH_TO_COMPUTE_FNF = true;
    private final List<Event<LETTER, PLACE>> mEvents;
    private final List<List<Event<LETTER, PLACE>>> mFoataNormalForm;
    private boolean mSorted;
    private boolean mFoataComputed;
    private int mLastSortedMinimum;
    private final int mConfigurationDepth;

    public Configuration(Set<Event<LETTER, PLACE>> set, int n) {
        this.mEvents = new ArrayList<Event<LETTER, PLACE>>(set);
        this.mFoataNormalForm = new ArrayList<List<Event<LETTER, PLACE>>>(n + 1);
        this.mConfigurationDepth = n;
    }

    private List<Event<LETTER, PLACE>> getMinPhi(int n, Comparator<Event<LETTER, PLACE>> comparator) {
        if (this.mLastSortedMinimum < n) {
            this.mFoataNormalForm.get(n).sort(comparator);
            this.mLastSortedMinimum = n;
        }
        return this.mFoataNormalForm.get(n);
    }

    @Override
    public Iterator<Event<LETTER, PLACE>> iterator() {
        return this.mEvents.iterator();
    }

    public int size() {
        return this.mEvents.size();
    }

    public int compareTo(Configuration<LETTER, PLACE> configuration, Comparator<Event<LETTER, PLACE>> comparator) {
        if (this.size() != configuration.size()) {
            return this.size() - configuration.size();
        }
        this.computePhi(comparator);
        configuration.computePhi(comparator);
        return this.comparePhi(this.mEvents, configuration.mEvents, comparator);
    }

    public int compareMin(Configuration<LETTER, PLACE> configuration, int n, Comparator<Event<LETTER, PLACE>> comparator) {
        int n2 = this.mFoataNormalForm.get(n).size() - configuration.mFoataNormalForm.get(n).size();
        if (n2 != 0) {
            return n2;
        }
        List<Event<LETTER, PLACE>> list = this.getMinPhi(n, comparator);
        List<Event<LETTER, PLACE>> list2 = configuration.getMinPhi(n, comparator);
        return this.comparePhi(list, list2, comparator);
    }

    private int comparePhi(List<Event<LETTER, PLACE>> list, List<Event<LETTER, PLACE>> list2, Comparator<Event<LETTER, PLACE>> comparator) {
        int n = 0;
        while (n < list.size()) {
            int n2 = comparator.compare(list.get(n), list2.get(n));
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    private void computePhi(Comparator<Event<LETTER, PLACE>> comparator) {
        if (!this.mSorted) {
            Collections.sort(this.mEvents, comparator);
            this.mSorted = true;
        }
    }

    public List<Event<LETTER, PLACE>> getSortedConfiguration(Comparator<Event<LETTER, PLACE>> comparator) {
        ArrayList<Event<LETTER, PLACE>> arrayList = new ArrayList<Event<LETTER, PLACE>>(this.mEvents);
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public void computeFoataNormalFormUsingDepth() {
        int n = 0;
        while (n < this.mConfigurationDepth + 1) {
            this.mFoataNormalForm.add(new ArrayList());
            ++n;
        }
        for (Event<LETTER, PLACE> event : this.mEvents) {
            this.mFoataNormalForm.get(event.getDepth()).add(event);
        }
    }

    public void computeFoataNormalFormIntuitively() {
        HashSet hashSet = new HashSet(this.mEvents);
        Set set = this.mEvents.stream().filter(event -> event.getAncestors() == 1).collect(Collectors.toCollection(HashSet::new));
        this.mFoataNormalForm.add(new ArrayList(set));
        while (!set.isEmpty()) {
            hashSet.removeAll(set);
            set = set.stream().flatMap(event -> event.getSuccessorEvents().stream()).filter(event2 -> hashSet.contains(event2) && !event2.getPredecessorEvents().stream().anyMatch(event -> hashSet.contains(event))).collect(Collectors.toSet());
            this.mFoataNormalForm.add(new ArrayList(set));
        }
        this.mFoataNormalForm.add(new ArrayList<Event<LETTER, PLACE>>(hashSet));
    }

    public void computeFoataNormalForm() {
        if (!this.mFoataComputed) {
            this.computeFoataNormalFormUsingDepth();
            this.mFoataComputed = true;
        }
    }

    public int getDepth() {
        return this.mConfigurationDepth;
    }

    public List<Event<LETTER, PLACE>> getEvents() {
        return this.mEvents;
    }

    public boolean contains(Event<LETTER, PLACE> event) {
        return this.mEvents.contains(event);
    }
}

