/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.Tree;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeRun;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Accepts<LETTER extends IRankedLetter, STATE>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mTreeAutomaton;
    private final Tree<LETTER> mExample;
    private final Boolean mResult;

    public Accepts(AutomataLibraryServices automataLibraryServices, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, TreeRun<LETTER, STATE> treeRun) {
        this(automataLibraryServices, iTreeAutomatonBU, treeRun.getTree());
    }

    public Accepts(AutomataLibraryServices automataLibraryServices, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, Tree<LETTER> tree) {
        this.mExample = tree;
        this.mTreeAutomaton = iTreeAutomatonBU;
        this.mResult = this.computeResult();
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName();
    }

    @Override
    public String exitMessage() {
        return "Exit " + this.getOperationName();
    }

    private Set<STATE> checkTree(Tree<LETTER> tree) {
        ArrayList<Set<STATE>> arrayList = new ArrayList<Set<STATE>>();
        for (Tree<LETTER> object2 : tree.getChildren()) {
            Set<STATE> set = this.checkTree(object2);
            if (set.isEmpty()) {
                return Collections.emptySet();
            }
            arrayList.add(set);
        }
        Iterable<TreeAutomatonRule<LETTER, STATE>> iterable = this.mTreeAutomaton.getSuccessors(tree.getSymbol());
        if (iterable == null) {
            return Collections.emptySet();
        }
        HashSet hashSet = new HashSet();
        for (Set<STATE> set : iterable) {
            assert (((TreeAutomatonRule)((Object)set)).getArity() == arrayList.size());
            boolean bl = true;
            int n = 0;
            while (n < ((TreeAutomatonRule)((Object)set)).getArity()) {
                Object STATE = ((TreeAutomatonRule)((Object)set)).getSource().get(n);
                if (!((Set)arrayList.get(n)).contains(STATE)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            hashSet.add(((TreeAutomatonRule)((Object)set)).getDest());
        }
        return hashSet;
    }

    private Boolean computeResult() {
        Set<STATE> set = this.checkTree(this.mExample);
        for (STATE STATE : set) {
            if (!this.mTreeAutomaton.isFinalState(STATE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

