/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.InitialTransition;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class TimedAutomata {
    public static final int OP_LT = -2;
    public static final int OP_LTEQ = -1;
    public static final int OP_EQ = 0;
    public static final int OP_GTEQ = 1;
    public static final int OP_GT = 2;
    public static final int OP_NEQ = 4;
    private final Collection<String> mClocks;
    private final State[] mStates;
    private final Map<Phase, Integer> mPhaseNumber = new HashMap<Phase, Integer>();

    public TimedAutomata(PhaseEventAutomata phaseEventAutomata, CDD[] cDDArray, String[] stringArray) {
        this.mStates = new State[phaseEventAutomata.mPhases.size()];
        this.mClocks = new TreeSet<String>();
        int n = 0;
        while (n < phaseEventAutomata.mPhases.size()) {
            this.mPhaseNumber.put(phaseEventAutomata.mPhases.get(n), n);
            this.mStates[n] = new State();
            this.mStates[n].nr = n;
            this.mStates[n].props = "dummy";
            this.mStates[n].clockInv = this.filterCDD(phaseEventAutomata.mPhases.get(n).getClockInv())[0];
            this.addClocks(this.mStates[n].clockInv);
            int n2 = 0;
            while (n2 < cDDArray.length) {
                if (phaseEventAutomata.mPhases.get(n).getStateInvariant().and(cDDArray[n2]) != CDD.FALSE) {
                    this.mStates[n].props = String.valueOf(this.mStates[n].props) + " " + stringArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        for (InitialTransition initialTransition : phaseEventAutomata.mInit) {
            this.mStates[this.mPhaseNumber.get((Object)initialTransition.getDest()).intValue()].props = String.valueOf(this.mStates[this.mPhaseNumber.get((Object)initialTransition.getDest()).intValue()].props) + " init";
        }
        int n3 = 0;
        while (n3 < phaseEventAutomata.mPhases.size()) {
            Iterator<Object> iterator = phaseEventAutomata.mPhases.get(n3).getTransitions().iterator();
            ArrayList<Edge> arrayList = new ArrayList<Edge>();
            while (iterator.hasNext()) {
                Guard[][] guardArray;
                Transition transition = (Transition)iterator.next();
                Guard[][] guardArray2 = guardArray = this.filterCDD(transition.getGuard());
                int n4 = guardArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Guard[] guardArray3 = guardArray2[n5];
                    Edge edge = new Edge();
                    edge.guard = guardArray3;
                    edge.resets = transition.getResets();
                    this.addClocks(edge.guard);
                    this.addClocks(edge.resets);
                    edge.dest = this.mStates[this.mPhaseNumber.get(transition.getDest())];
                    arrayList.add(edge);
                    ++n5;
                }
            }
            this.mStates[n3].edges = arrayList.toArray(new Edge[arrayList.size()]);
            ++n3;
        }
    }

    private Guard[][] filterCDD(Guard[] guardArray, CDD cDD) {
        if (cDD.getDecision() instanceof RangeDecision && ((RangeDecision)cDD.getDecision()).getVar().indexOf("_X") >= 0) {
            ArrayList arrayList = new ArrayList();
            String string = ((RangeDecision)cDD.getDecision()).getVar();
            int[] nArray = ((RangeDecision)cDD.getDecision()).getLimits();
            int n = 0;
            while (n < cDD.getChilds().length) {
                if (cDD.getChilds()[n] != CDD.FALSE) {
                    boolean bl = n > 0 && n < cDD.getChilds().length - 1 && nArray[n - 1] / 2 == nArray[n] / 2;
                    Guard[] guardArray2 = new Guard[guardArray.length + (n == 0 || n == cDD.getChilds().length - 1 || bl ? 1 : 2)];
                    System.arraycopy(guardArray, 0, guardArray2, 0, guardArray.length);
                    int n2 = guardArray.length;
                    if (n > 0) {
                        guardArray2[n2] = new Guard();
                        guardArray2[n2].clock = string;
                        guardArray2[n2].cmp = bl ? 0 : ((nArray[n - 1] & 1) == 1 ? 2 : 1);
                        guardArray2[n2].value = nArray[n - 1] / 2;
                        ++n2;
                    }
                    if (n < cDD.getChilds().length - 1 && !bl) {
                        guardArray2[n2] = new Guard();
                        guardArray2[n2].clock = string;
                        guardArray2[n2].cmp = (nArray[n] & 1) == 0 ? -2 : -1;
                        guardArray2[n2].value = nArray[n] / 2;
                    }
                    Guard[][] guardArray3 = this.filterCDD(guardArray2, cDD.getChilds()[n]);
                    Collections.addAll(arrayList, guardArray3);
                }
                ++n;
            }
            return (Guard[][])arrayList.toArray((T[])new Guard[arrayList.size()][]);
        }
        if (cDD == CDD.FALSE) {
            return new Guard[0][0];
        }
        if (cDD == CDD.TRUE) {
            Guard[][] guardArray4 = new Guard[][]{guardArray};
            return guardArray4;
        }
        CDD cDD2 = CDD.FALSE;
        int n = 0;
        while (n < cDD.getChilds().length) {
            cDD2 = cDD2.or(cDD.getChilds()[n]);
            ++n;
        }
        return this.filterCDD(guardArray, cDD2);
    }

    private Guard[][] filterCDD(CDD cDD) {
        return this.filterCDD(new Guard[0], cDD);
    }

    private void addClocks(String[] stringArray) {
        Collections.addAll(this.mClocks, stringArray);
    }

    private void addClocks(Guard[] guardArray) {
        Guard[] guardArray2 = guardArray;
        int n = guardArray.length;
        int n2 = 0;
        while (n2 < n) {
            Guard guard = guardArray2[n2];
            this.mClocks.add(guard.clock);
            ++n2;
        }
    }

    private static String dumpGuard(Guard[] guardArray) {
        if (guardArray.length == 0) {
            return "TRUE";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        Guard[] guardArray2 = guardArray;
        int n = guardArray.length;
        int n2 = 0;
        while (n2 < n) {
            Guard guard = guardArray2[n2];
            stringBuilder.append(string).append(guard);
            string = " and ";
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static String dumpResets(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("RESET{");
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            stringBuilder.append(" ").append(string);
            ++n2;
        }
        return stringBuilder.append(" }").toString();
    }

    public void dumpKronos() {
        Object object;
        System.out.println("/* Complete System */");
        System.out.println("#locs " + this.mStates.length);
        int n = 0;
        State[] stateArray = this.mStates;
        int n2 = this.mStates.length;
        int n3 = 0;
        while (n3 < n2) {
            object = stateArray[n3];
            n += ((State)object).edges.length;
            ++n3;
        }
        System.out.println("#trans " + n);
        System.out.print("#clocks " + this.mClocks.size());
        object = this.mClocks.iterator();
        while (object.hasNext()) {
            System.out.print(" " + (String)object.next());
        }
        System.out.println();
        System.out.println("#sync");
        n3 = 0;
        while (n3 < this.mStates.length) {
            System.out.println();
            System.out.println("loc: " + n3);
            System.out.println("prop: " + this.mStates[n3].props);
            System.out.println("invar: " + TimedAutomata.dumpGuard(this.mStates[n3].clockInv));
            System.out.println("trans: ");
            Edge[] edgeArray = this.mStates[n3].edges;
            int n4 = this.mStates[n3].edges.length;
            int n5 = 0;
            while (n5 < n4) {
                Edge edge = edgeArray[n5];
                System.out.println(TimedAutomata.dumpGuard(edge.guard) + " => ; " + TimedAutomata.dumpResets(edge.resets) + "; goto " + edge.dest.nr);
                ++n5;
            }
            ++n3;
        }
    }

    private static class Edge {
        Guard[] guard;
        String[] resets;
        State dest;

        private Edge() {
        }
    }

    private static class Guard {
        String clock;
        int cmp;
        int value;

        private Guard() {
        }

        public String toString() {
            return this.clock + (switch (this.cmp) {
                case -2 -> "<";
                case -1 -> "<=";
                case 0 -> "==";
                case 2 -> ">";
                case 1 -> ">=";
                case 4 -> "!=";
                default -> "??";
            }) + this.value;
        }
    }

    private static class State {
        int nr;
        String props;
        Guard[] clockInv;
        Edge[] edges;

        private State() {
        }
    }
}

