/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class UnionPredicateCoverageChecker
implements IPredicateCoverageChecker {
    private final ImmutableList<Pair<IPredicateCoverageChecker, Predicate<IPredicate>>> mComponents;

    private UnionPredicateCoverageChecker(ImmutableList<Pair<IPredicateCoverageChecker, Predicate<IPredicate>>> immutableList) {
        this.mComponents = immutableList;
    }

    public static UnionPredicateCoverageChecker empty() {
        return new UnionPredicateCoverageChecker((ImmutableList<Pair<IPredicateCoverageChecker, Predicate<IPredicate>>>)ImmutableList.empty());
    }

    public UnionPredicateCoverageChecker with(IPredicateCoverageChecker iPredicateCoverageChecker, Predicate<IPredicate> predicate) {
        return new UnionPredicateCoverageChecker((ImmutableList<Pair<IPredicateCoverageChecker, Predicate<IPredicate>>>)new ImmutableList((Object)new Pair((Object)iPredicateCoverageChecker, predicate), this.mComponents));
    }

    @Override
    public IncrementalPlicationChecker.Validity isCovered(IPredicate iPredicate, IPredicate iPredicate2) {
        for (Pair pair : this.mComponents) {
            IncrementalPlicationChecker.Validity validity;
            Predicate predicate = (Predicate)pair.getSecond();
            if (predicate != null && (predicate.test(iPredicate) || predicate.test(iPredicate2)) || (validity = ((IPredicateCoverageChecker)pair.getFirst()).isCovered(iPredicate, iPredicate2)) != IncrementalPlicationChecker.Validity.VALID && validity != IncrementalPlicationChecker.Validity.INVALID) continue;
            return validity;
        }
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public Set<IPredicate> getCoveredPredicates(IPredicate iPredicate) {
        return this.mComponents.stream().flatMap(pair -> pair.getSecond() == null || ((Predicate)pair.getSecond()).test(iPredicate) ? ((IPredicateCoverageChecker)pair.getFirst()).getCoveredPredicates(iPredicate).stream() : Stream.empty()).collect(Collectors.toSet());
    }

    @Override
    public Set<IPredicate> getCoveringPredicates(IPredicate iPredicate) {
        return this.mComponents.stream().flatMap(pair -> pair.getSecond() == null || ((Predicate)pair.getSecond()).test(iPredicate) ? ((IPredicateCoverageChecker)pair.getFirst()).getCoveringPredicates(iPredicate).stream() : Stream.empty()).collect(Collectors.toSet());
    }

    @Override
    public IPartialComparator<IPredicate> getPartialComparator() {
        return (iPredicate, iPredicate2) -> {
            if (Objects.equals(iPredicate, iPredicate2)) {
                return IPartialComparator.ComparisonResult.EQUAL;
            }
            if (this.getCoveredPredicates((IPredicate)iPredicate).contains(iPredicate2)) {
                return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
            }
            if (this.getCoveringPredicates((IPredicate)iPredicate).contains(iPredicate)) {
                return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
            }
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        };
    }

    @Override
    public HashRelation<IPredicate, IPredicate> getCopyOfImplicationRelation() {
        HashRelation hashRelation = new HashRelation();
        for (Pair pair : this.mComponents) {
            hashRelation.addAll(((IPredicateCoverageChecker)pair.getFirst()).getCopyOfImplicationRelation());
        }
        return hashRelation;
    }
}

