/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.trace;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.util.ArrayList;
import java.util.List;

public class ReachDefTracePredecessorGenerator
extends RCFGEdgeVisitor {
    private final IAnnotationProvider<ReachDefStatementAnnotation> mProvider;
    private final String mKey;
    private List<ReachDefStatementAnnotation> rtr;

    public ReachDefTracePredecessorGenerator(IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider) {
        this(iAnnotationProvider, null);
    }

    public ReachDefTracePredecessorGenerator(IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider, String string) {
        this.mProvider = iAnnotationProvider;
        this.mKey = string;
    }

    public List<ReachDefStatementAnnotation> process(CodeBlock codeBlock) {
        this.rtr = new ArrayList<ReachDefStatementAnnotation>();
        this.visit(codeBlock);
        return this.rtr;
    }

    protected void visit(SequentialComposition sequentialComposition) {
        List list = sequentialComposition.getCodeBlocks();
        if (list == null || list.isEmpty()) {
            return;
        }
        super.visit((CodeBlock)list.get(list.size() - 1));
    }

    protected void visit(ParallelComposition parallelComposition) {
        throw new UnsupportedOperationException("Parallel composition is not supported");
    }

    protected void visit(StatementSequence statementSequence) {
        ReachDefStatementAnnotation reachDefStatementAnnotation = this.getAnnotation(statementSequence);
        if (reachDefStatementAnnotation != null) {
            this.rtr.add(reachDefStatementAnnotation);
        }
        super.visit(statementSequence);
    }

    private ReachDefStatementAnnotation getAnnotation(StatementSequence statementSequence) {
        if (this.mKey == null) {
            return this.mProvider.getAnnotation((IElement)statementSequence.getStatements().get(statementSequence.getStatements().size() - 1));
        }
        return this.mProvider.getAnnotation((IElement)statementSequence.getStatements().get(statementSequence.getStatements().size() - 1), this.mKey);
    }
}

