/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryPointerBase;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.List;

public final class MemoryPointer1D
extends MemoryPointerBase {
    final BoogieType mComponentType;

    private MemoryPointer1D(BoogieType boogieType, TypeSizes typeSizes) {
        super(typeSizes);
        this.mComponentType = boogieType;
        this.mBoogieType = BoogieType.createStructType((String[])new String[]{"base"}, (BoogieType[])new BoogieType[]{this.mComponentType});
    }

    public static MemoryPointer1D create(TranslationSettings translationSettings, BoogieType boogieType, TypeSizes typeSizes) {
        List<AbstractMap.SimpleEntry<String, Boolean>> list = List.of(new AbstractMap.SimpleEntry<String, Boolean>("Pointer dereference validity", translationSettings.checkPointerDerefValidity() != CACSLPreferenceInitializer.CheckMode.IGNORE), new AbstractMap.SimpleEntry<String, Boolean>("Check if freed pointer was valid", translationSettings.checkIfFreedPointerIsValid()), new AbstractMap.SimpleEntry<String, Boolean>("Check memory neutrality", !translationSettings.getFunctionsCheckedForMemoryNeutrality().isEmpty()), new AbstractMap.SimpleEntry<String, Boolean>("If two pointers are subtracted or compared they have the same base address", translationSettings.getPointerSubtractionAndComparisonValidityCheckMode() != CACSLPreferenceInitializer.CheckMode.IGNORE), new AbstractMap.SimpleEntry<String, Boolean>("Use constant arrays", translationSettings.useConstantArrays()));
        List<String> list2 = list.stream().filter(AbstractMap.SimpleEntry::getValue).map(AbstractMap.SimpleEntry::getKey).toList();
        if (!list2.isEmpty()) {
            throw new UnsupportedOperationException(" The 1D memory addressing is not compatible with the following active settings: " + String.join((CharSequence)", ", list2));
        }
        return new MemoryPointer1D(boogieType, typeSizes);
    }

    @Override
    public BoogieType getPointerType() {
        return this.mBoogieType;
    }

    @Override
    public Expression constructNullPointer(ILocation iLocation, CPrimitive cPrimitive) {
        return this.constructInitialPointer(iLocation, BigInteger.ZERO, cPrimitive);
    }

    @Override
    public TypeDeclaration getTypeDeclaration(ILocation iLocation) {
        VarList varList = new VarList(iLocation, new String[]{"base"}, this.mComponentType.toASTType(iLocation));
        VarList[] varListArray = new VarList[]{varList};
        BoogieStructType boogieStructType = BoogieType.createStructType((String[])new String[]{"base"}, (BoogieType[])new BoogieType[]{(BoogieType)varList.getType().getBoogieType()});
        StructType structType = new StructType(iLocation, (IBoogieType)boogieStructType, varListArray);
        return new TypeDeclaration(iLocation, new Attribute[0], false, "$Pointer$", new String[0], (ASTType)structType);
    }

    @Override
    public Expression constructInitialPointer(ILocation iLocation, BigInteger bigInteger, CPrimitive cPrimitive) {
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, bigInteger);
        return this.createPointerFromBase(expression, iLocation);
    }

    public Expression createPointerFromBase(Expression expression, ILocation iLocation) {
        return ExpressionFactory.constructStructConstructor((ILocation)iLocation, (String[])new String[]{"base"}, (Expression[])new Expression[]{expression});
    }

    @Override
    public Expression constructPointerRelationExpression(ILocation iLocation, Expression expression, CACSLPreferenceInitializer.CheckMode checkMode, ExpressionTranslation expressionTranslation, int n, ExpressionResult expressionResult, ExpressionResult expressionResult2) {
        Expression expression2 = this.constructPointerComponentRelation(iLocation, n, expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue(), "base", expressionTranslation);
        switch (checkMode) {
            case ASSUME: 
            case CHECK: {
                return ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)true);
            }
            case IGNORE: {
                return expression2;
            }
        }
        throw new AssertionError((Object)"unknown value");
    }

    @Override
    public Expression constructPointerComponentRelation(ILocation iLocation, int n, Expression expression, Expression expression2, String string, ExpressionTranslation expressionTranslation) {
        assert (string.equals("base")) : "Illegal use of pointer component: " + string + " in 1D pointer";
        return this.pointerComponentRelation(iLocation, n, expression, expression2, string, expressionTranslation);
    }

    @Override
    public boolean isNullPointer(Expression expression) {
        StructConstructor structConstructor = (StructConstructor)expression;
        return structConstructor.getFieldValues().length == 1 && structConstructor.getFieldIdentifiers()[0].equals("base") && BigInteger.ZERO.equals(CTranslationUtil.extractIntegerValue(structConstructor.getFieldValues()[0]));
    }
}

