/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.IMemoryStructure;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryStructureMultiBitprecise;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryStructureSingleBitprecise;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryStructureUnbounded;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;

public class MemoryStructureFactory {
    public static IMemoryStructure createMemoryStructure(TranslationSettings translationSettings, TypeSizes typeSizes, ITypeHandler iTypeHandler) {
        CACSLPreferenceInitializer.MemoryStructure memoryStructure = translationSettings.getMemoryStructurePreference();
        if (memoryStructure.isBitVectorRepresentation() && !translationSettings.isBitvectorTranslation()) {
            throw new UnsupportedOperationException("Memory Structure: " + String.valueOf((Object)memoryStructure) + " is only available in using the bitprecise translation");
        }
        switch (memoryStructure) {
            case HoenickeLindenmann_1ByteResolution: 
            case HoenickeLindenmann_2ByteResolution: 
            case HoenickeLindenmann_4ByteResolution: 
            case HoenickeLindenmann_8ByteResolution: {
                return new MemoryStructureSingleBitprecise(memoryStructure.getByteSize(), typeSizes, iTypeHandler);
            }
            case HoenickeLindenmann_Original: {
                if (translationSettings.isBitvectorTranslation()) {
                    return new MemoryStructureMultiBitprecise(typeSizes, iTypeHandler);
                }
                return new MemoryStructureUnbounded(typeSizes, iTypeHandler);
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)memoryStructure) + " is an invalid memory structure.");
    }
}

