/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseLabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.lib.models.ModifiableLabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVar;

public class DataflowDAG<T>
extends ModifiableLabeledEdgesMultigraph<DataflowDAG<T>, ScopedBoogieVar> {
    private static final long serialVersionUID = 1L;
    private final T mNodeLabel;

    public DataflowDAG(T t) {
        this.mNodeLabel = t;
    }

    public T getNodeLabel() {
        return this.mNodeLabel;
    }

    public String toString() {
        if (this.mNodeLabel == null) {
            return "NULL";
        }
        if (this.mNodeLabel instanceof Statement) {
            return "[" + this.mNodeLabel.hashCode() + "]: " + BoogiePrettyPrinter.print((Statement)((Statement)this.mNodeLabel));
        }
        return "[" + this.mNodeLabel.hashCode() + "]: " + this.mNodeLabel.toString();
    }

    public void printGraphDebug(ILogger iLogger) {
        String[] stringArray = this.getDebugString().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            iLogger.debug((Object)string);
            ++n2;
        }
    }

    public String getDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.getDebugString(stringBuilder, this, "", "");
        return stringBuilder.toString();
    }

    private void getDebugString(StringBuilder stringBuilder, DataflowDAG<T> dataflowDAG, String string, String string2) {
        if (string.isEmpty()) {
            stringBuilder.append(String.valueOf(dataflowDAG) + "\n");
        } else {
            stringBuilder.append(string2 + "--" + string + "--> " + String.valueOf(dataflowDAG) + "\n");
        }
        for (DataflowDAG dataflowDAG2 : dataflowDAG.getOutgoingNodes()) {
            this.getDebugString(stringBuilder, dataflowDAG2, ((ScopedBoogieVar)dataflowDAG.getOutgoingEdgeLabel((BaseLabeledEdgesMultigraph)dataflowDAG2)).toString(), string2 + "  ");
        }
    }
}

