/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.nontermination;

import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.INonTerminationAnalysisSettings;
import java.io.Serializable;

public class NonTerminationAnalysisSettings
implements Serializable,
INonTerminationAnalysisSettings {
    private static final long serialVersionUID = 4249624228131593458L;
    private final AnalysisType mAnalysis;
    private final boolean mAllowBounded;
    private final int mNumberOfGevs;
    private final boolean mNilpotentComponents;

    public NonTerminationAnalysisSettings(INonTerminationAnalysisSettings iNonTerminationAnalysisSettings) {
        this.mAnalysis = iNonTerminationAnalysisSettings.getAnalysis();
        this.mAllowBounded = iNonTerminationAnalysisSettings.isAllowBounded();
        this.mNumberOfGevs = iNonTerminationAnalysisSettings.getNumberOfGevs();
        this.mNilpotentComponents = iNonTerminationAnalysisSettings.isNilpotentComponents();
    }

    public void checkSanity() {
        assert (this.mNumberOfGevs >= 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Nontermination analysis: ");
        stringBuilder.append((Object)this.mAnalysis);
        stringBuilder.append(" Allow bounded executions: ");
        stringBuilder.append(this.mAllowBounded);
        stringBuilder.append(" Number of generalized eigenvectors: ");
        stringBuilder.append(this.mNumberOfGevs);
        stringBuilder.append(" Nilpotent components: ");
        stringBuilder.append(this.mNilpotentComponents);
        return stringBuilder.toString();
    }

    @Override
    public AnalysisType getAnalysis() {
        return this.mAnalysis;
    }

    @Override
    public boolean isAllowBounded() {
        return this.mAllowBounded;
    }

    @Override
    public int getNumberOfGevs() {
        return this.mNumberOfGevs;
    }

    @Override
    public boolean isNilpotentComponents() {
        return this.mNilpotentComponents;
    }
}

