/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseExplicitEdgesMultigraph<V extends IExplicitEdgesMultigraph<V, E, VL, EL, VisualizationNode>, E extends IMultigraphEdge<V, E, VL, EL, VisualizationNode>, VL, EL>
extends BasePayloadContainer
implements IExplicitEdgesMultigraph<V, E, VL, EL, VisualizationNode> {
    private static final long serialVersionUID = 1L;
    protected List<E> mOutgoingEdges = new ArrayList();
    protected List<E> mIncomingEdges = new ArrayList();

    protected BaseExplicitEdgesMultigraph() {
        this(null, null, null);
    }

    protected BaseExplicitEdgesMultigraph(IPayload iPayload) {
        this(null, null, iPayload);
    }

    protected BaseExplicitEdgesMultigraph(V v) {
        this(v, null, null);
    }

    protected BaseExplicitEdgesMultigraph(V v, IPayload iPayload) {
        this(v, iPayload, null);
    }

    protected BaseExplicitEdgesMultigraph(V v, IPayload iPayload, IPayload iPayload2) {
        super(iPayload2);
        if (v != null) {
            BaseMultigraphEdge baseMultigraphEdge = new BaseMultigraphEdge<V, E, VL, EL>((IExplicitEdgesMultigraph)v, this, iPayload2){
                private static final long serialVersionUID = 1L;

                public EL getLabel() {
                    return null;
                }
            };
            v.getOutgoingEdges().add(baseMultigraphEdge);
            this.mIncomingEdges.add(baseMultigraphEdge);
        }
    }

    public List<E> getIncomingEdges() {
        return this.mIncomingEdges;
    }

    public List<E> getOutgoingEdges() {
        return this.mOutgoingEdges;
    }

    public List<V> getOutgoingNodes() {
        ArrayList<IExplicitEdgesMultigraph> arrayList = new ArrayList<IExplicitEdgesMultigraph>();
        for (IMultigraphEdge iMultigraphEdge : this.getOutgoingEdges()) {
            IExplicitEdgesMultigraph iExplicitEdgesMultigraph = iMultigraphEdge.getTarget();
            if (iExplicitEdgesMultigraph == null) continue;
            arrayList.add(iExplicitEdgesMultigraph);
        }
        return arrayList;
    }

    public List<V> getIncomingNodes() {
        ArrayList<IExplicitEdgesMultigraph> arrayList = new ArrayList<IExplicitEdgesMultigraph>();
        for (IMultigraphEdge iMultigraphEdge : this.getIncomingEdges()) {
            IExplicitEdgesMultigraph iExplicitEdgesMultigraph = iMultigraphEdge.getSource();
            if (iExplicitEdgesMultigraph == null) continue;
            arrayList.add(iExplicitEdgesMultigraph);
        }
        return arrayList;
    }

    public VisualizationNode getVisualizationGraph() {
        return new VisualizationNode(this);
    }

    public List<IWalkable> getSuccessors() {
        return this.getOutgoingEdges();
    }
}

