/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.scc;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.CombinatoricsUtils;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class SccComputation<NODE, COMP extends StronglyConnectedComponent<NODE>> {
    private final ILogger mLogger;
    private final IStronglyConnectedComponentFactory<NODE, COMP> mSccFactory;
    protected final ISuccessorProvider<NODE> mSuccessorProvider;
    private final int mNumberOfAllStates;
    protected int mIndex = 0;
    protected final StackHashSet<NODE> mNoScc = new StackHashSet();
    protected final Map<NODE, Integer> mIndices = new HashMap<NODE, Integer>();
    protected final Map<NODE, Integer> mLowLinks = new HashMap<NODE, Integer>();
    protected final ArrayList<COMP> mBalls = new ArrayList();
    protected final ArrayList<COMP> mSCCs = new ArrayList();
    private int mNumberOfNonBallSCCs = 0;
    private Map<COMP, Set<COMP>> mAdjacenceMatrix;

    public SccComputation(ILogger iLogger, ISuccessorProvider<NODE> iSuccessorProvider, IStronglyConnectedComponentFactory<NODE, COMP> iStronglyConnectedComponentFactory, int n, Set<NODE> set) {
        this.mLogger = iLogger;
        this.mSccFactory = iStronglyConnectedComponentFactory;
        this.mSuccessorProvider = iSuccessorProvider;
        this.mNumberOfAllStates = n;
        for (NODE NODE : set) {
            if (this.mIndices.containsKey(NODE)) continue;
            this.strongconnect(NODE);
        }
        assert (this.automatonPartitionedBySCCs());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Graph consists of " + this.getBalls().size() + " InCaSumBalls and " + this.mNumberOfNonBallSCCs + " non ball SCCs. Number of states in SCCs " + this.mNumberOfAllStates + "."));
        }
    }

    public Map<NODE, COMP> getNodeToComponents() {
        HashMap hashMap = new HashMap();
        for (StronglyConnectedComponent stronglyConnectedComponent : this.getSCCs()) {
            for (Object NODE : stronglyConnectedComponent.getNodes()) {
                hashMap.put(NODE, stronglyConnectedComponent);
            }
        }
        return hashMap;
    }

    public ISuccessorProvider<COMP> getComponentsSuccessorsProvider() {
        if (this.mAdjacenceMatrix == null) {
            this.mAdjacenceMatrix = this.computeAdjacenceMatrix();
        }
        return stronglyConnectedComponent -> this.mAdjacenceMatrix.get(stronglyConnectedComponent).iterator();
    }

    private Map<COMP, Set<COMP>> computeAdjacenceMatrix() {
        Map<NODE, COMP> map = this.getNodeToComponents();
        HashMap hashMap = new HashMap();
        List<COMP> list = this.getSCCs();
        int n = list.size() - 1;
        block0: for (StronglyConnectedComponent stronglyConnectedComponent : list) {
            assert (!hashMap.containsKey(stronglyConnectedComponent));
            HashSet<StronglyConnectedComponent> hashSet = new HashSet<StronglyConnectedComponent>();
            hashMap.put(stronglyConnectedComponent, hashSet);
            for (Object NODE : stronglyConnectedComponent.getNodes()) {
                for (NODE NODE2 : CombinatoricsUtils.iterateAll(this.mSuccessorProvider.getSuccessors(NODE))) {
                    StronglyConnectedComponent stronglyConnectedComponent2 = (StronglyConnectedComponent)map.get(NODE2);
                    if (stronglyConnectedComponent.equals(stronglyConnectedComponent2)) continue;
                    hashSet.add(stronglyConnectedComponent2);
                }
                if (hashSet.size() >= n) continue block0;
            }
        }
        return hashMap;
    }

    public Collection<COMP> getRootComponents() {
        HashSet<COMP> hashSet = new HashSet<COMP>(this.getSCCs());
        ISuccessorProvider<COMP> iSuccessorProvider = this.getComponentsSuccessorsProvider();
        for (StronglyConnectedComponent stronglyConnectedComponent : this.getSCCs()) {
            for (StronglyConnectedComponent stronglyConnectedComponent2 : CombinatoricsUtils.iterateAll(iSuccessorProvider.getSuccessors(stronglyConnectedComponent))) {
                hashSet.remove(stronglyConnectedComponent2);
            }
        }
        return hashSet;
    }

    public Collection<COMP> getLeafComponents() {
        ISuccessorProvider<COMP> iSuccessorProvider = this.getComponentsSuccessorsProvider();
        HashSet<StronglyConnectedComponent> hashSet = new HashSet<StronglyConnectedComponent>();
        for (StronglyConnectedComponent stronglyConnectedComponent : this.getSCCs()) {
            if (iSuccessorProvider.getSuccessors(stronglyConnectedComponent).hasNext()) continue;
            hashSet.add(stronglyConnectedComponent);
        }
        return hashSet;
    }

    public Collection<COMP> getLeafComponents(Iterable<NODE> iterable) {
        HashSet<Object> hashSet3;
        ISuccessorProvider<COMP> iSuccessorProvider = this.getComponentsSuccessorsProvider();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        Stack<StronglyConnectedComponent> stack = new Stack<StronglyConnectedComponent>();
        for (HashSet<Object> hashSet3 : iterable) {
            stack.add((StronglyConnectedComponent)this.getNodeToComponents().get(hashSet3));
        }
        hashSet3 = new HashSet();
        while (!stack.isEmpty()) {
            StronglyConnectedComponent stronglyConnectedComponent = (StronglyConnectedComponent)stack.pop();
            boolean bl = false;
            Iterator<Object> iterator = iSuccessorProvider.getSuccessors(stronglyConnectedComponent);
            while (iterator.hasNext()) {
                StronglyConnectedComponent stronglyConnectedComponent2 = (StronglyConnectedComponent)iterator.next();
                if (!hashSet3.contains(stronglyConnectedComponent2)) {
                    hashSet3.add(stronglyConnectedComponent2);
                    stack.add(stronglyConnectedComponent2);
                }
                bl = true;
            }
            if (bl) continue;
            hashSet2.add(stronglyConnectedComponent);
        }
        return hashSet2;
    }

    public Collection<NODE> getLeafNodes() {
        HashSet hashSet = new HashSet();
        for (StronglyConnectedComponent stronglyConnectedComponent : this.getLeafComponents()) {
            hashSet.add(stronglyConnectedComponent.getRootNode());
        }
        return hashSet;
    }

    public Collection<NODE> getLeafNodes(NODE NODE) {
        HashSet<NODE> hashSet = new HashSet<NODE>();
        hashSet.add(NODE);
        return this.getLeafNodes((Iterable<NODE>)hashSet);
    }

    public Collection<NODE> getLeafNodes(Iterable<NODE> iterable) {
        Collection<COMP> collection = this.getLeafComponents(iterable);
        HashSet hashSet = new HashSet();
        for (StronglyConnectedComponent stronglyConnectedComponent : collection) {
            hashSet.add(stronglyConnectedComponent.getRootNode());
        }
        return hashSet;
    }

    public Collection<COMP> getBalls() {
        return Collections.unmodifiableList(this.mBalls);
    }

    public List<COMP> getSCCs() {
        return Collections.unmodifiableList(this.mSCCs);
    }

    protected void strongconnect(NODE NODE) {
        assert (!this.mIndices.containsKey(NODE));
        assert (!this.mLowLinks.containsKey(NODE));
        this.mIndices.put(NODE, this.mIndex);
        this.mLowLinks.put(NODE, this.mIndex);
        ++this.mIndex;
        this.mNoScc.push(NODE);
        Iterator<NODE> iterator = this.mSuccessorProvider.getSuccessors(NODE);
        while (iterator.hasNext()) {
            NODE NODE2 = iterator.next();
            this.processSuccessor(NODE, NODE2);
        }
        if (this.mLowLinks.get(NODE).equals(this.mIndices.get(NODE))) {
            this.establishNewComponent(NODE);
        }
    }

    protected void establishNewComponent(NODE NODE) {
        NODE NODE2;
        COMP COMP = this.mSccFactory.constructNewSCComponent();
        do {
            NODE2 = this.mNoScc.pop();
            ((StronglyConnectedComponent)COMP).addNode(NODE2);
        } while (NODE != NODE2);
        ((StronglyConnectedComponent)COMP).setRootNode(NODE2);
        this.mSCCs.add(COMP);
        if (this.isBall((StronglyConnectedComponent<NODE>)COMP)) {
            this.mBalls.add(COMP);
        } else {
            ++this.mNumberOfNonBallSCCs;
        }
    }

    private void processSuccessor(NODE NODE, NODE NODE2) {
        if (!this.mIndices.containsKey(NODE2)) {
            this.strongconnect(NODE2);
            this.updateLowlink(NODE, this.mLowLinks.get(NODE2));
        } else if (this.mNoScc.contains(NODE2)) {
            this.updateLowlink(NODE, this.mIndices.get(NODE2));
        }
    }

    protected void updateLowlink(NODE NODE, int n) {
        int n2 = Math.min(this.mLowLinks.get(NODE), n);
        this.mLowLinks.put(NODE, n2);
    }

    boolean isBall(StronglyConnectedComponent<NODE> stronglyConnectedComponent) {
        if (stronglyConnectedComponent.getNumberOfStates() == 1) {
            NODE NODE = stronglyConnectedComponent.getRootNode();
            Iterator<NODE> iterator = this.mSuccessorProvider.getSuccessors(NODE);
            while (iterator.hasNext()) {
                NODE NODE2 = iterator.next();
                if (!NODE.equals(NODE2)) continue;
                return true;
            }
            return false;
        }
        assert (stronglyConnectedComponent.getNumberOfStates() > 1);
        return true;
    }

    protected boolean automatonPartitionedBySCCs() {
        int n = 0;
        int n2 = 0;
        for (StronglyConnectedComponent stronglyConnectedComponent : this.mBalls) {
            n += stronglyConnectedComponent.getNumberOfStates();
            n2 = Math.max(n2, stronglyConnectedComponent.getNumberOfStates());
        }
        this.mLogger.debug((Object)("The biggest SCC has " + n2 + " vertices."));
        boolean bl = n + this.mNumberOfNonBallSCCs == this.mNumberOfAllStates;
        return bl;
    }

    @FunctionalInterface
    public static interface IStronglyConnectedComponentFactory<NODE, C extends StronglyConnectedComponent<NODE>> {
        public C constructNewSCComponent();
    }

    @FunctionalInterface
    public static interface ISuccessorProvider<NODE> {
        public Iterator<NODE> getSuccessors(NODE var1);
    }

    static class StackHashSet<NODE> {
        private final Deque<NODE> mStack = new ArrayDeque<NODE>();
        private final Set<NODE> mSet = new HashSet<NODE>();

        StackHashSet() {
        }

        public NODE pop() {
            NODE NODE = this.mStack.pop();
            this.mSet.remove(NODE);
            return NODE;
        }

        public void push(NODE NODE) {
            this.mStack.push(NODE);
            boolean bl = this.mSet.add(NODE);
            if (!bl) {
                throw new IllegalArgumentException("Illegal to add element twice " + String.valueOf(NODE));
            }
        }

        public boolean contains(NODE NODE) {
            return this.mSet.contains(NODE);
        }
    }
}

