/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeCheckException;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Expression2Term;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.pea.BoogieBooleanExpressionDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PeaResultUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;

public class CddToSmt {
    private final Script mScript;
    private final Term mTrue;
    private final Term mFalse;
    private final Expression2Term.IIdentifierTranslator[] mIdentifierTranslators;
    private final IReqSymbolTable mReqSymboltable;
    private final Boogie2SMT mBoogieToSmt;
    private final PeaResultUtil mResultUtil;

    public CddToSmt(IUltimateServiceProvider iUltimateServiceProvider, PeaResultUtil peaResultUtil, Script script, Boogie2SMT boogie2SMT, BoogieDeclarations boogieDeclarations, IReqSymbolTable iReqSymbolTable) {
        this.mScript = script;
        this.mTrue = this.mScript.term("true", new Term[0]);
        this.mFalse = this.mScript.term("false", new Term[0]);
        this.mBoogieToSmt = boogie2SMT;
        this.mIdentifierTranslators = new Expression2Term.IIdentifierTranslator[]{this::getSmtIdentifier};
        this.mReqSymboltable = iReqSymbolTable;
        this.mResultUtil = peaResultUtil;
    }

    public Term toSmt(Expression expression) {
        Expression2Term.SingleTermResult singleTermResult = this.mBoogieToSmt.getExpression2Term().translateToTerm(this.mIdentifierTranslators, expression);
        return singleTermResult.term();
    }

    public Term toSmt(CDD cDD) {
        if (cDD == CDD.TRUE) {
            return this.mTrue;
        }
        if (cDD == CDD.FALSE) {
            return this.mFalse;
        }
        CDD cDD2 = cDD.getDecision().simplify(cDD.getChilds());
        if (cDD2 == CDD.TRUE) {
            return this.mTrue;
        }
        if (cDD2 == CDD.FALSE) {
            return this.mFalse;
        }
        CDD[] cDDArray = cDD2.getChilds();
        Decision decision = cDD2.getDecision();
        Term term = null;
        int n = 0;
        while (n < cDDArray.length) {
            if (cDDArray[n] != CDD.FALSE) {
                Term term2 = this.toSmt(cDDArray[n]);
                if (!cDD2.childDominates(n)) {
                    Term term3;
                    if (decision instanceof RangeDecision) {
                        term3 = this.toSmtForRange(n, decision.getVar(), ((RangeDecision)decision).getLimits());
                    } else if (decision instanceof BoogieBooleanExpressionDecision) {
                        Expression expression = ((BoogieBooleanExpressionDecision)decision).getExpression();
                        AddDeclarationInformationToIdentifiers addDeclarationInformationToIdentifiers = new AddDeclarationInformationToIdentifiers();
                        TypeAdder typeAdder = new TypeAdder();
                        Expression expression2 = expression.accept((GeneratedBoogieAstTransformer)addDeclarationInformationToIdentifiers);
                        Expression expression3 = expression2.accept((GeneratedBoogieAstTransformer)typeAdder);
                        if (typeAdder.getTypeError() != null) {
                            Pair<String, Expression> pair = typeAdder.getTypeError();
                            this.mResultUtil.typeError((String)pair.getFirst(), (Expression)pair.getSecond());
                            return this.mFalse;
                        }
                        term3 = this.toSmt(expression3);
                    } else if (decision instanceof BooleanDecision) {
                        term3 = this.getTermVarTerm(((BooleanDecision)decision).getVar());
                    } else if (decision instanceof EventDecision) {
                        term3 = this.getTermVarTerm(((EventDecision)decision).getVar());
                    } else {
                        throw new UnsupportedOperationException("Unknown decision type: " + String.valueOf(decision.getClass()));
                    }
                    if (n == 1 && !(decision instanceof RangeDecision)) {
                        term3 = SmtUtils.not((Script)this.mScript, (Term)term3);
                    }
                    term2 = term2 == this.mTrue ? term3 : SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term3, term2});
                }
                term = term == null ? term2 : SmtUtils.or((Script)this.mScript, (Term[])new Term[]{term2, term});
            }
            ++n;
        }
        if (term == null) {
            return this.mFalse;
        }
        return term;
    }

    private Term toSmtForRange(int n, String string, int[] nArray) {
        Term term = this.getTermVarTerm(string);
        if (n == 0) {
            Term term2 = this.mScript.decimal(Double.toString(nArray[0] / 2));
            if ((nArray[0] & 1) == 0) {
                return SmtUtils.less((Script)this.mScript, (Term)term, (Term)term2);
            }
            return SmtUtils.leq((Script)this.mScript, (Term)term, (Term)term2);
        }
        if (n == nArray.length) {
            Term term3 = this.mScript.decimal(Double.toString(nArray[nArray.length - 1] / 2));
            if ((nArray[nArray.length - 1] & 1) == 1) {
                return SmtUtils.greater((Script)this.mScript, (Term)term, (Term)term3);
            }
            return SmtUtils.geq((Script)this.mScript, (Term)term, (Term)term3);
        }
        if (nArray[n - 1] / 2 == nArray[n] / 2) {
            Term term4 = this.mScript.decimal(Double.toString(nArray[n] / 2));
            return SmtUtils.binaryEquality((Script)this.mScript, (Term)term, (Term)term4);
        }
        Term term5 = this.mScript.decimal(Double.toString(nArray[n - 1] / 2));
        Term term6 = this.mScript.decimal(Double.toString(nArray[n] / 2));
        Term term7 = (nArray[n - 1] & 1) == 1 ? SmtUtils.less((Script)this.mScript, (Term)term5, (Term)term) : SmtUtils.leq((Script)this.mScript, (Term)term5, (Term)term);
        Term term8 = (nArray[n] & 1) == 0 ? SmtUtils.less((Script)this.mScript, (Term)term, (Term)term6) : SmtUtils.leq((Script)this.mScript, (Term)term, (Term)term6);
        return SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term8});
    }

    private Term getSmtIdentifier(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
        if (bl || declarationInformation != DeclarationInformation.DECLARATIONINFO_GLOBAL) {
            throw new UnsupportedOperationException();
        }
        return this.getTermVarTerm(string);
    }

    public Term getTermVarTerm(String string) {
        IProgramNonOldVar iProgramNonOldVar = (IProgramNonOldVar)this.mBoogieToSmt.getBoogie2SmtSymbolTable().getGlobalsMap().get(string);
        if (iProgramNonOldVar != null) {
            return iProgramNonOldVar.getTerm();
        }
        ProgramConst programConst = (ProgramConst)this.mBoogieToSmt.getBoogie2SmtSymbolTable().getConstsMap().get(string);
        if (programConst != null) {
            return programConst.getTerm();
        }
        throw new AssertionError((Object)("Unknown symbol " + string));
    }

    private final class AddDeclarationInformationToIdentifiers
    extends GeneratedBoogieAstTransformer {
        private AddDeclarationInformationToIdentifiers() {
        }

        public Expression transform(IdentifierExpression identifierExpression) {
            return CddToSmt.this.mReqSymboltable.getIdentifierExpression(identifierExpression.getIdentifier());
        }
    }

    private final class TypeAdder
    extends GeneratedBoogieAstTransformer {
        private Pair<String, Expression> mTypeError;

        private TypeAdder() {
        }

        public Pair<String, Expression> getTypeError() {
            return this.mTypeError;
        }

        public Expression transform(BinaryExpression binaryExpression) {
            Expression expression = binaryExpression.getLeft().accept((GeneratedBoogieAstTransformer)this);
            Expression expression2 = binaryExpression.getRight().accept((GeneratedBoogieAstTransformer)this);
            try {
                return ExpressionFactory.newBinaryExpression((ILocation)binaryExpression.getLocation(), (BinaryExpression.Operator)binaryExpression.getOperator(), (Expression)expression, (Expression)expression2);
            }
            catch (TypeCheckException typeCheckException) {
                this.setTypeError(typeCheckException.getMessage(), (Expression)binaryExpression);
                return new IdentifierExpression(binaryExpression.getLoc(), (IBoogieType)BoogieType.TYPE_ERROR, "Error", DeclarationInformation.DECLARATIONINFO_GLOBAL);
            }
        }

        public Expression transform(FunctionApplication functionApplication) {
            if (functionApplication.getType() != null) {
                return super.transform(functionApplication);
            }
            Expression[] expressionArray = new Expression[functionApplication.getArguments().length];
            int n = 0;
            while (n < functionApplication.getArguments().length) {
                expressionArray[n] = functionApplication.getArguments()[n].accept((GeneratedBoogieAstTransformer)this);
                ++n;
            }
            IBoogieType iBoogieType = CddToSmt.this.mReqSymboltable.getFunctionReturnType(functionApplication.getIdentifier());
            return new FunctionApplication(functionApplication.getLoc(), iBoogieType, functionApplication.getIdentifier(), expressionArray);
        }

        public Expression transform(UnaryExpression unaryExpression) {
            Expression expression = unaryExpression.getExpr().accept((GeneratedBoogieAstTransformer)this);
            try {
                return ExpressionFactory.constructUnaryExpression((ILocation)unaryExpression.getLocation(), (UnaryExpression.Operator)unaryExpression.getOperator(), (Expression)expression);
            }
            catch (TypeCheckException typeCheckException) {
                this.setTypeError(typeCheckException.getMessage(), (Expression)unaryExpression);
                return new IdentifierExpression(unaryExpression.getLoc(), (IBoogieType)BoogieType.TYPE_ERROR, "Error", DeclarationInformation.DECLARATIONINFO_GLOBAL);
            }
        }

        private void setTypeError(String string, Expression expression) {
            if (this.mTypeError != null) {
                return;
            }
            this.mTypeError = new Pair((Object)string, (Object)expression);
        }
    }
}

