/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.ISleepMapStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.SleepMap;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SleepMapReduction<L, S, R>
implements INwaOutgoingLetterAndTransitionProvider<L, R> {
    private final INwaOutgoingLetterAndTransitionProvider<L, S> mOperand;
    private final IDfsOrder<L, R> mOrder;
    private final List<IIndependenceRelation<S, L>> mRelations;
    private final ISleepMapStateFactory<L, S, R> mStateFactory;
    private final IBudgetFunction<L, R> mBudgetFunction;
    private final R mInitial;

    public SleepMapReduction(INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, List<IIndependenceRelation<S, L>> list, IDfsOrder<L, R> iDfsOrder, ISleepMapStateFactory<L, S, R> iSleepMapStateFactory, Function<SleepMapReduction<L, S, R>, IBudgetFunction<L, R>> function) {
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mOrder = iDfsOrder;
        this.mRelations = list;
        this.mStateFactory = iSleepMapStateFactory;
        Optional optional = DataStructureUtils.getOnly(iNwaOutgoingLetterAndTransitionProvider.getInitialStates(), (String)"There must only be one initial state");
        this.mInitial = optional.isPresent() ? this.mStateFactory.createSleepMapState(optional.get(), SleepMap.empty(this.mRelations), this.maximumBudget()) : null;
        this.mBudgetFunction = function.apply(this);
    }

    @Override
    @Deprecated
    public IStateFactory<R> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public VpAlphabet<L> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public R getEmptyStackState() {
        return (R)this.mStateFactory.createEmptyStackState();
    }

    @Override
    public Iterable<R> getInitialStates() {
        return this.mInitial == null ? Collections.emptySet() : Set.of(this.mInitial);
    }

    @Override
    public boolean isInitial(R r) {
        return Objects.equals(this.mInitial, r);
    }

    @Override
    public boolean isFinal(R r) {
        return this.mOperand.isFinal(this.mStateFactory.getOriginalState(r));
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public String sizeInformation() {
        return "[size unknown]";
    }

    @Override
    public Set<L> lettersInternal(R r) {
        return this.mOperand.lettersInternal(this.mStateFactory.getOriginalState(r)).stream().sorted(this.mOrder.getOrder(r)).filter(object2 -> !this.isPruned(r, object2)).collect(Collectors.toSet());
    }

    @Override
    public Iterable<OutgoingInternalTransition<L, R>> internalSuccessors(R r, L l) {
        if (this.isPruned(r, l)) {
            return Collections.emptySet();
        }
        R r2 = this.computeSuccessorWithBudget(r, l, this.mBudgetFunction.computeBudget(r, l));
        if (r2 == null) {
            return Collections.emptySet();
        }
        return Set.of(new OutgoingInternalTransition<L, R>(l, r2));
    }

    @Override
    public Iterable<OutgoingCallTransition<L, R>> callSuccessors(R r, L l) {
        return Collections.emptySet();
    }

    @Override
    public Iterable<OutgoingReturnTransition<L, R>> returnSuccessors(R r, R r2, L l) {
        return Collections.emptySet();
    }

    R computeSuccessorWithBudget(R r, L l, int n) {
        S s = this.mStateFactory.getOriginalState(r);
        Optional optional = DataStructureUtils.getOnly(this.mOperand.internalSuccessors(s, l), (String)"Automaton must be deterministic");
        if (optional.isEmpty()) {
            return null;
        }
        SleepMap<L, S> sleepMap = this.mStateFactory.getSleepMap(r);
        Comparator<L> comparator = this.mOrder.getOrder(r);
        Map map = this.mOperand.lettersInternal(s).stream().filter(object3 -> comparator.compare(object3, l) < 0 && !this.isPruned(r, object3)).collect(Collectors.toMap(Function.identity(), object2 -> this.mBudgetFunction.computeBudget(r, object2)));
        SleepMap<L, S> sleepMap2 = sleepMap.computeSuccessor(s, l, map, n);
        return this.mStateFactory.createSleepMapState(((OutgoingInternalTransition)optional.get()).getSucc(), sleepMap2, n);
    }

    private int maximumBudget() {
        return this.mRelations.size() - 1;
    }

    private boolean isPruned(R r, L l) {
        SleepMap<L, S> sleepMap = this.mStateFactory.getSleepMap(r);
        if (!sleepMap.contains(l)) {
            return false;
        }
        int n = sleepMap.getPrice(l);
        int n2 = this.mBudgetFunction.computeBudget(r, l);
        assert (n2 <= this.mStateFactory.getBudget(r)) : "Budget limit exceeded";
        return n <= n2;
    }

    public static interface IBudgetFunction<L, R> {
        public int computeBudget(R var1, L var2);
    }
}

