/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Expression2Term;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfDer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Statements2TransFormula {
    private static final boolean COMPUTE_ASSERTS = false;
    private static final String MSG_COMPUTE_ASSERTS_NOT_AVAILABLE = "computation of asserts not available";
    private final boolean mSimplePartialSkolemization;
    private final Script mScript;
    private final ManagedScript mMgdScript;
    private final BoogieDeclarations mBoogieDeclarations;
    private final Boogie2SMT mBoogie2SMT;
    private final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    private final Expression2Term mExpression2Term;
    private String mCurrentProcedure;
    private TransFormulaBuilder mTransFormulaBuilder;
    private Set<TermVariable> mAuxVars;
    private Term mAssumes;
    private Term mAsserts;
    private Boogie2SMT.ConstOnlyIdentifierTranslator mConstOnlyIdentifierTranslator;
    private final IUltimateServiceProvider mServices;
    private Map<String, ILocation> mOverapproximations = null;

    public Statements2TransFormula(Boogie2SMT boogie2SMT, IUltimateServiceProvider iUltimateServiceProvider, Expression2Term expression2Term, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        this.mSimplePartialSkolemization = bl;
        this.mBoogie2SMT = boogie2SMT;
        this.mScript = boogie2SMT.getScript();
        this.mMgdScript = boogie2SMT.getManagedScript();
        this.mExpression2Term = expression2Term;
        this.mBoogie2SmtSymbolTable = this.mBoogie2SMT.getBoogie2SmtSymbolTable();
        this.mBoogieDeclarations = this.mBoogie2SMT.getBoogieDeclarations();
    }

    private void initialize(String string) {
        assert (this.mCurrentProcedure == null);
        assert (this.mTransFormulaBuilder == null);
        assert (this.mAuxVars == null);
        assert (this.mAssumes == null);
        assert (this.mConstOnlyIdentifierTranslator == null);
        this.mOverapproximations = new HashMap<String, ILocation>();
        this.mCurrentProcedure = string;
        this.mTransFormulaBuilder = new TransFormulaBuilder(null, null, false, null, true, null, false);
        this.mAuxVars = new HashSet<TermVariable>();
        this.mAssumes = this.mScript.term("true", new Term[0]);
        this.mConstOnlyIdentifierTranslator = this.mBoogie2SMT.createConstOnlyIdentifierTranslator();
    }

    private TranslationResult getTransFormula(boolean bl, SmtUtils.SimplificationTechnique simplificationTechnique) {
        UnmodifiableTransFormula unmodifiableTransFormula = null;
        try {
            unmodifiableTransFormula = this.constructTransFormula(bl, simplificationTechnique);
            this.mCurrentProcedure = null;
            this.mTransFormulaBuilder = null;
            this.mAuxVars = null;
            this.mAssumes = null;
            this.mConstOnlyIdentifierTranslator = null;
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "constructing TransFormula"));
            throw toolchainCanceledException;
        }
        return new TranslationResult(unmodifiableTransFormula, this.mOverapproximations);
    }

    private UnmodifiableTransFormula constructTransFormula(boolean bl, SmtUtils.SimplificationTechnique simplificationTechnique) {
        XnfDer xnfDer = new XnfDer(this.mMgdScript, this.mServices);
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])xnfDer.tryToEliminate(0, SmtUtils.getConjuncts((Term)this.mAssumes), this.mAuxVars));
        xnfDer = this.mSimplePartialSkolemization ? this.skolemize(this.mAssumes, this.mAuxVars) : this.mAssumes;
        xnfDer = this.mBoogie2SMT.getSmtFunctionsAndAxioms().inline((Term)xnfDer);
        UnmodifiableTransFormula.Infeasibility infeasibility = null;
        if (simplificationTechnique != SmtUtils.SimplificationTechnique.NONE) {
            xnfDer = SmtUtils.simplify((ManagedScript)this.mMgdScript, (Term)xnfDer, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)simplificationTechnique);
        }
        if (bl) {
            infeasibility = UnmodifiableTransFormula.Infeasibility.UNPROVEABLE;
        }
        if (infeasibility == null) {
            if (SmtUtils.isFalseLiteral((Term)xnfDer)) {
                infeasibility = UnmodifiableTransFormula.Infeasibility.INFEASIBLE;
            } else if (simplificationTechnique.detectsUnsatisfiability()) {
                infeasibility = UnmodifiableTransFormula.Infeasibility.UNPROVEABLE;
            } else {
                Script.LBool lBool = Util.checkSat((Script)this.mScript, (Term)xnfDer);
                if (lBool == Script.LBool.UNSAT) {
                    xnfDer = this.mScript.term("false", new Term[0]);
                    infeasibility = UnmodifiableTransFormula.Infeasibility.INFEASIBLE;
                } else {
                    infeasibility = UnmodifiableTransFormula.Infeasibility.UNPROVEABLE;
                }
            }
        }
        TransFormulaUtils.addConstantsIfInFormula(this.mTransFormulaBuilder, (Term)xnfDer, this.mConstOnlyIdentifierTranslator.getNonTheoryConsts());
        this.mTransFormulaBuilder.setFormula((Term)xnfDer);
        this.mTransFormulaBuilder.setInfeasibility(infeasibility);
        this.mTransFormulaBuilder.addAuxVarsButRenameToFreshCopies(this.mAuxVars, this.mMgdScript);
        return this.mTransFormulaBuilder.finishConstruction(this.mMgdScript);
    }

    private IProgramVar getModifiableBoogieVar(String string, DeclarationInformation declarationInformation) {
        DeclarationInformation.StorageClass storageClass = declarationInformation.getStorageClass();
        switch (storageClass) {
            case GLOBAL: 
            case PROC_FUNC_OUTPARAM: 
            case IMPLEMENTATION_OUTPARAM: 
            case LOCAL: {
                break;
            }
            case PROC_FUNC_INPARAM: 
            case IMPLEMENTATION_INPARAM: {
                throw new AssertionError((Object)"not modifiable");
            }
            case QUANTIFIED: 
            case IMPLEMENTATION: 
            case PROC_FUNC: {
                throw new AssertionError((Object)"no appropriate variable ");
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        return this.mBoogie2SmtSymbolTable.getBoogieVar(string, declarationInformation, false);
    }

    private Expression2Term.IIdentifierTranslator[] getIdentifierTranslatorsIntraprocedural() {
        return new Expression2Term.IIdentifierTranslator[]{new LocalVarTranslatorWithInOutVarManagement(), new GlobalVarTranslatorWithInOutVarManagement(this.mCurrentProcedure, false), this.mConstOnlyIdentifierTranslator};
    }

    private void addAssignment(AssignmentStatement assignmentStatement) {
        Expression2Term.SingleTermResult singleTermResult;
        Object object;
        Object object2;
        LeftHandSide[] leftHandSideArray = assignmentStatement.getLhs();
        Expression[] expressionArray = assignmentStatement.getRhs();
        HashMap<Expression2Term.SingleTermResult, Expression> hashMap = new HashMap<Expression2Term.SingleTermResult, Expression>();
        int n = 0;
        while (n < leftHandSideArray.length) {
            DeclarationInformation declarationInformation;
            object2 = (VariableLHS)leftHandSideArray[n];
            assert (object2.getDeclarationInformation() != null) : " no declaration information";
            object = object2.getIdentifier();
            IProgramVar iProgramVar = this.getModifiableBoogieVar((String)object, declarationInformation = object2.getDeclarationInformation());
            if (iProgramVar == null) {
                throw new AssertionError((Object)("Undeclared variable: " + (String)object));
            }
            this.getOrConstuctCurrentRepresentative(iProgramVar);
            if (this.mTransFormulaBuilder.containsInVar(iProgramVar)) {
                singleTermResult = this.mTransFormulaBuilder.getInVar(iProgramVar);
                hashMap.put(singleTermResult, expressionArray[n]);
                this.removeInVar(iProgramVar);
            }
            ++n;
        }
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray = this.getIdentifierTranslatorsIntraprocedural();
        object2 = new ArrayList();
        object = new HashSet();
        for (DeclarationInformation declarationInformation : hashMap.keySet()) {
            singleTermResult = this.mExpression2Term.translateToTerm(iIdentifierTranslatorArray, (Expression)hashMap.get(declarationInformation));
            object.addAll(singleTermResult.auxiliaryVars());
            this.mOverapproximations.putAll(singleTermResult.overapproximations());
            Term term = singleTermResult.term();
            Term term2 = SmtUtils.binaryEquality((Script)this.mScript, (Term)declarationInformation, (Term)term);
            object2.add(term2);
        }
        this.eliminateAuxVarsAndAddNewAssumes(SmtUtils.and((Script)this.mScript, (Collection)object2), (Collection<TermVariable>)object);
    }

    private void addHavoc(HavocStatement havocStatement) {
        VariableLHS[] variableLHSArray = havocStatement.getIdentifiers();
        int n = variableLHSArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLHS variableLHS = variableLHSArray[n2];
            assert (variableLHS.getDeclarationInformation() != null) : " no declaration information";
            String string = variableLHS.getIdentifier();
            DeclarationInformation declarationInformation = variableLHS.getDeclarationInformation();
            IProgramVar iProgramVar = this.getModifiableBoogieVar(string, declarationInformation);
            assert (iProgramVar != null);
            this.getOrConstuctCurrentRepresentative(iProgramVar);
            if (this.mTransFormulaBuilder.containsInVar(iProgramVar)) {
                this.removeInVar(iProgramVar);
            }
            ++n2;
        }
    }

    private void addAssume(AssumeStatement assumeStatement) {
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.SingleTermResult singleTermResult = this.mExpression2Term.translateToTerm(iIdentifierTranslatorArray, assumeStatement.getFormula());
        this.mOverapproximations.putAll(singleTermResult.overapproximations());
        Term term = singleTermResult.term();
        this.eliminateAuxVarsAndAddNewAssumes(term, singleTermResult.auxiliaryVars());
    }

    private void addAssert(AssertStatement assertStatement) {
        throw new AssertionError((Object)MSG_COMPUTE_ASSERTS_NOT_AVAILABLE);
    }

    private static boolean assertTermContainsNoNull(Term term) {
        return term.toString() instanceof Object;
    }

    private void addSummary(CallStatement callStatement) {
        TermVariable termVariable;
        Object object;
        Object object2;
        Object specificationArray2;
        Object n16;
        Object object3;
        VarList[] specification;
        Procedure procedure = this.mBoogieDeclarations.getProcSpecification().get(callStatement.getMethodName());
        HashMap<String, Term> hashMap = new HashMap<String, Term>();
        Expression[] expressionArray = callStatement.getArguments();
        VariableLHS[] variableLHSArray = callStatement.getLhs();
        int n = 0;
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        VarList[] varListArray2 = procedure.getOutParams();
        int n2 = varListArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            VarList object62 = varListArray2[n3];
            String[] specification2 = object62.getIdentifiers();
            int n11 = specification2.length;
            int n4 = 0;
            while (n4 < n11) {
                String string = specification2[n4];
                specification = variableLHSArray[n].getIdentifier();
                object3 = variableLHSArray[n].getDeclarationInformation();
                n16 = this.getModifiableBoogieVar((String)specification, (DeclarationInformation)object3);
                assert (n16 != null);
                specificationArray2 = this.getOrConstuctCurrentRepresentative((IProgramVar)n16);
                hashMap.put(string, (Term)specificationArray2);
                arrayList.add((IProgramVar)n16);
                ++n;
                ++n4;
            }
            ++n3;
        }
        for (IProgramVar iProgramVar : arrayList) {
            this.removeInVar(iProgramVar);
        }
        HashMap<IProgramVar, Term> hashMap2 = new HashMap<IProgramVar, Term>();
        HashMap hashMap22 = new HashMap();
        VarList varList = procedure.getSpecification();
        int n5 = ((Specification[])varList).length;
        int n7 = 0;
        while (n7 < n5) {
            Specification specification3 = varList[n7];
            if (specification3 instanceof ModifiesSpecification) {
                object3 = ((ModifiesSpecification)specification3).getIdentifiers();
                int n6 = ((VariableLHS[])object3).length;
                int iIdentifierTranslatorArray2 = 0;
                while (iIdentifierTranslatorArray2 < n6) {
                    VariableLHS iIdentifierTranslatorArray = object3[iIdentifierTranslatorArray2];
                    n16 = iIdentifierTranslatorArray.getIdentifier();
                    specificationArray2 = this.mBoogie2SmtSymbolTable.getBoogieVar((String)n16, iIdentifierTranslatorArray.getDeclarationInformation(), false);
                    object2 = this.mBoogie2SmtSymbolTable.getBoogieVar((String)n16, iIdentifierTranslatorArray.getDeclarationInformation(), true);
                    assert (specificationArray2 != null);
                    assert (object2 != null);
                    object = this.getOrConstuctCurrentRepresentative((IProgramVar)specificationArray2);
                    this.removeInVar((IProgramVar)specificationArray2);
                    termVariable = this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(specificationArray2.getGloballyUniqueId(), specificationArray2.getTermVariable().getSort());
                    this.mTransFormulaBuilder.addInVar((IProgramVar)specificationArray2, termVariable);
                    hashMap22.put(specificationArray2, object);
                    hashMap22.put(object2, termVariable);
                    hashMap2.put((IProgramVar)specificationArray2, (Term)termVariable);
                    hashMap2.put((IProgramVar)object2, (Term)termVariable);
                    ++iIdentifierTranslatorArray2;
                }
            }
            ++n7;
        }
        ArrayList<TermVariable> arrayList2 = new ArrayList<TermVariable>();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        varList = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.MultiTermResult multiTermResult = this.mExpression2Term.translateToTerms((Expression2Term.IIdentifierTranslator[])varList, expressionArray);
        hashSet.addAll(multiTermResult.auxiliaryVars());
        this.mOverapproximations.putAll(multiTermResult.overapproximations());
        Term[] termArray = multiTermResult.terms();
        n = 0;
        specification = procedure.getInParams();
        int n8 = specification.length;
        int n9 = 0;
        while (n9 < n8) {
            varList = specification[n9];
            object2 = varList.getIdentifiers();
            int n10 = ((String[])object2).length;
            int n11 = 0;
            while (n11 < n10) {
                object3 = object2[n11];
                hashMap.put((String)object3, termArray[n]);
                ++n;
                ++n11;
            }
            ++n9;
        }
        varList = callStatement.getMethodName();
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray = new Expression2Term.IIdentifierTranslator[]{new SubstitutionTranslatorId(hashMap), new SubstitutionTranslatorBoogieVar(hashMap22), new GlobalVarTranslatorWithInOutVarManagement((String)varList, false), this.mConstOnlyIdentifierTranslator};
        Specification[] specificationArray = procedure.getSpecification();
        int n12 = specificationArray.length;
        int n13 = 0;
        while (n13 < n12) {
            Specification specification4 = specificationArray[n13];
            if (specification4 instanceof EnsuresSpecification) {
                Expression expression = ((EnsuresSpecification)specification4).getFormula();
                object2 = this.mExpression2Term.translateToTerm(iIdentifierTranslatorArray, expression);
                hashSet.addAll(((Expression2Term.SingleTermResult)object2).auxiliaryVars());
                this.mOverapproximations.putAll(((Expression2Term.SingleTermResult)object2).overapproximations());
                object = ((Expression2Term.SingleTermResult)object2).term();
                arrayList2.add((TermVariable)object);
            }
            ++n13;
        }
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray2 = new Expression2Term.IIdentifierTranslator[]{new SubstitutionTranslatorId(hashMap), new SubstitutionTranslatorBoogieVar(hashMap2), new GlobalVarTranslatorWithInOutVarManagement((String)varList, false), this.mConstOnlyIdentifierTranslator};
        Specification[] specificationArray3 = procedure.getSpecification();
        int n14 = specificationArray3.length;
        n12 = 0;
        while (n12 < n14) {
            Specification specification5 = specificationArray3[n12];
            if (specification5 instanceof RequiresSpecification) {
                object2 = ((RequiresSpecification)specification5).getFormula();
                object = this.mExpression2Term.translateToTerm(iIdentifierTranslatorArray2, (Expression)object2);
                hashSet.addAll(((Expression2Term.SingleTermResult)object).auxiliaryVars());
                this.mOverapproximations.putAll(((Expression2Term.SingleTermResult)object).overapproximations());
                termVariable = ((Expression2Term.SingleTermResult)object).term();
                arrayList2.add(termVariable);
            }
            ++n12;
        }
        this.eliminateAuxVarsAndAddNewAssumes(SmtUtils.and((Script)this.mScript, arrayList2), hashSet);
    }

    private void addForkCurrentThread(ForkStatement forkStatement) {
    }

    private void addJoinCurrentThread(JoinStatement joinStatement) {
    }

    private void removeInVar(IProgramVar iProgramVar) {
        TermVariable termVariable = this.mTransFormulaBuilder.removeInVar(iProgramVar);
        if (this.mTransFormulaBuilder.getOutVar(iProgramVar) != termVariable) {
            this.mAuxVars.add(termVariable);
        }
    }

    private TermVariable getOrConstuctCurrentRepresentative(IProgramVar iProgramVar) {
        TermVariable termVariable = this.mTransFormulaBuilder.getInVar(iProgramVar);
        if (termVariable == null) {
            termVariable = this.createInVar(iProgramVar);
            if (!this.mTransFormulaBuilder.containsOutVar(iProgramVar)) {
                this.mTransFormulaBuilder.addOutVar(iProgramVar, termVariable);
            }
        }
        return termVariable;
    }

    private TermVariable createInVar(IProgramVar iProgramVar) {
        TermVariable termVariable = iProgramVar.isOldvar() ? iProgramVar.getTermVariable() : this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(iProgramVar.getGloballyUniqueId(), iProgramVar.getTermVariable().getSort());
        this.mTransFormulaBuilder.addInVar(iProgramVar, termVariable);
        return termVariable;
    }

    private void eliminateAuxVarsAndAddNewAssumes(Term term, Collection<TermVariable> collection) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (TermVariable termVariable : Arrays.asList(term.getFreeVars())) {
            if (!this.mAuxVars.contains(termVariable)) continue;
            hashSet.add(termVariable);
        }
        hashSet.addAll(collection);
        if (hashSet.isEmpty()) {
            this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{this.mAssumes, term});
            this.mAuxVars.addAll(collection);
        } else {
            TermVariable termVariable;
            termVariable = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{this.mAssumes, term});
            XnfDer xnfDer = new XnfDer(this.mMgdScript, this.mServices);
            this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])xnfDer.tryToEliminate(0, SmtUtils.getConjuncts((Term)termVariable), hashSet));
            this.mAuxVars.addAll(collection);
            this.mAuxVars.retainAll(new HashSet<TermVariable>(Arrays.asList(this.mAssumes.getFreeVars())));
        }
    }

    private Term skolemize(Term term, Set<TermVariable> set) {
        Term term2;
        Term term3 = new NnfTransformer(this.mMgdScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(term);
        Term term4 = new PrenexNormalForm(this.mMgdScript).transform(term3);
        QuantifierSequence quantifierSequence = new QuantifierSequence(this.mMgdScript, term4);
        List list = quantifierSequence.getQuantifierBlocks();
        if (list.isEmpty() || ((QuantifierSequence.QuantifiedVariables)list.get(0)).getQuantifier() == 1) {
            term2 = term4;
        } else {
            if (list.size() > 1) {
                throw new UnsupportedOperationException("support for alternating quantifiers not yet implemented");
            }
            HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
            for (TermVariable termVariable : ((QuantifierSequence.QuantifiedVariables)list.get(0)).getVariables()) {
                TermVariable termVariable2 = this.mMgdScript.constructFreshTermVariable("skolemized_" + termVariable.getName(), termVariable.getSort());
                hashMap.put(termVariable, termVariable2);
                set.add(termVariable2);
            }
            term2 = Substitution.apply((ManagedScript)this.mMgdScript, hashMap, (Term)quantifierSequence.getInnerTerm());
        }
        return term2;
    }

    public TranslationResult statementSequence(SmtUtils.SimplificationTechnique simplificationTechnique, String string, List<Statement> list) {
        this.initialize(string);
        int n = list.size() - 1;
        while (n >= 0) {
            Statement statement = list.get(n);
            if (statement instanceof AssumeStatement) {
                AssumeStatement assumeStatement = (AssumeStatement)statement;
                this.addAssume(assumeStatement);
            } else if (statement instanceof AssignmentStatement) {
                AssignmentStatement assignmentStatement = (AssignmentStatement)statement;
                this.addAssignment(assignmentStatement);
            } else if (statement instanceof HavocStatement) {
                HavocStatement havocStatement = (HavocStatement)statement;
                this.addHavoc(havocStatement);
            } else if (statement instanceof CallStatement) {
                CallStatement callStatement = (CallStatement)statement;
                this.addSummary(callStatement);
            } else if (statement instanceof ForkStatement) {
                ForkStatement forkStatement = (ForkStatement)statement;
                this.addForkCurrentThread(forkStatement);
            } else if (statement instanceof JoinStatement) {
                JoinStatement joinStatement = (JoinStatement)statement;
                this.addJoinCurrentThread(joinStatement);
            } else {
                throw new IllegalArgumentException("Intenal Edge only contains Assume, Assignment or Havoc Statement");
            }
            --n;
        }
        return this.getTransFormula(false, simplificationTechnique);
    }

    public TranslationResult inParamAssignment(CallStatement callStatement, SmtUtils.SimplificationTechnique simplificationTechnique) {
        return this.inParamAssignment(callStatement.getMethodName(), callStatement.getArguments(), simplificationTechnique);
    }

    @Deprecated
    public TranslationResult inParamAssignment(ForkStatement forkStatement, SmtUtils.SimplificationTechnique simplificationTechnique) {
        return this.inParamAssignment(forkStatement.getProcedureName(), forkStatement.getArguments(), simplificationTechnique);
    }

    private TranslationResult inParamAssignment(String string, Expression[] expressionArray, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.initialize(string);
        Procedure procedure = this.mBoogieDeclarations.getProcImplementation().get(string);
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.MultiTermResult multiTermResult = this.mExpression2Term.translateToTerms(iIdentifierTranslatorArray, expressionArray);
        this.mAuxVars.addAll(multiTermResult.auxiliaryVars());
        this.mOverapproximations.putAll(multiTermResult.overapproximations());
        Term[] termArray = multiTermResult.terms();
        this.mTransFormulaBuilder.removeOutVarsOfLocalContext();
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string);
        Term[] termArray2 = new Term[expressionArray.length];
        int n = 0;
        VarList[] varListArray = procedure.getInParams();
        int n2 = varListArray.length;
        int n3 = 0;
        while (n3 < n2) {
            VarList varList = varListArray[n3];
            String[] stringArray = varList.getIdentifiers();
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string2 = stringArray[n5];
                IProgramVar iProgramVar = this.mBoogie2SMT.getBoogie2SmtSymbolTable().getBoogieVar(string2, declarationInformation, false);
                assert (iProgramVar != null);
                TermVariable termVariable = this.constructTermVariableWithSuffix(iProgramVar, "InParam");
                this.mTransFormulaBuilder.addOutVar(iProgramVar, termVariable);
                termArray2[n] = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)termArray[n]);
                ++n;
                ++n5;
            }
            ++n3;
        }
        assert (expressionArray.length == n);
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])termArray2);
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    @Deprecated
    public TranslationResult forkThreadIdAssignment(IProgramVar[] iProgramVarArray, String string, Expression[] expressionArray, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.initialize(string);
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.MultiTermResult multiTermResult = this.mExpression2Term.translateToTerms(iIdentifierTranslatorArray, expressionArray);
        this.mAuxVars.addAll(multiTermResult.auxiliaryVars());
        this.mOverapproximations.putAll(multiTermResult.overapproximations());
        Term[] termArray = multiTermResult.terms();
        this.mTransFormulaBuilder.clearOutVars();
        int n = 0;
        Term[] termArray2 = new Term[termArray.length];
        Term[] termArray3 = termArray;
        int n2 = termArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Term term = termArray3[n3];
            TermVariable termVariable = this.constructTermVariableWithSuffix(iProgramVarArray[n], "ThreadTemplateId");
            this.mTransFormulaBuilder.addOutVar(iProgramVarArray[n], termVariable);
            termArray2[n] = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)term);
            ++n;
            ++n3;
        }
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])termArray2);
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    @Deprecated
    public TranslationResult joinThreadIdAssumption(IProgramVar[] iProgramVarArray, String string, Expression[] expressionArray, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.initialize(string);
        Expression2Term.IIdentifierTranslator[] iIdentifierTranslatorArray = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.MultiTermResult multiTermResult = this.mExpression2Term.translateToTerms(iIdentifierTranslatorArray, expressionArray);
        this.mAuxVars.addAll(multiTermResult.auxiliaryVars());
        this.mOverapproximations.putAll(multiTermResult.overapproximations());
        Term[] termArray = multiTermResult.terms();
        int n = 0;
        Term[] termArray2 = new Term[termArray.length];
        Term[] termArray3 = termArray;
        int n2 = termArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Term term = termArray3[n3];
            TermVariable termVariable = this.createInVar(iProgramVarArray[n]);
            this.mTransFormulaBuilder.addOutVar(iProgramVarArray[n], termVariable);
            termArray2[n] = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable, (Term)term);
            ++n;
            ++n3;
        }
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])termArray2);
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    public TranslationResult resultAssignment(CallStatement callStatement, String string, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.initialize(string);
        String string2 = callStatement.getMethodName();
        Procedure procedure = this.mBoogieDeclarations.getProcImplementation().get(string2);
        int n = 0;
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, string2);
        Term[] termArray = new Term[callStatement.getLhs().length];
        VarList[] varListArray = procedure.getOutParams();
        int n2 = varListArray.length;
        int n3 = 0;
        while (n3 < n2) {
            VarList varList = varListArray[n3];
            String[] stringArray = varList.getIdentifiers();
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string3 = stringArray[n5];
                IProgramVar iProgramVar = this.mBoogie2SmtSymbolTable.getBoogieVar(string3, declarationInformation, false);
                TermVariable termVariable = this.constructTermVariableWithSuffix(iProgramVar, "OutParam");
                this.mTransFormulaBuilder.addInVar(iProgramVar, termVariable);
                String string4 = callStatement.getLhs()[n].getIdentifier();
                DeclarationInformation declarationInformation2 = callStatement.getLhs()[n].getDeclarationInformation();
                IProgramVar iProgramVar2 = this.mBoogie2SmtSymbolTable.getBoogieVar(string4, declarationInformation2, false);
                TermVariable termVariable2 = this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(iProgramVar2.getGloballyUniqueId(), iProgramVar2.getTermVariable().getSort());
                this.mTransFormulaBuilder.addOutVar(iProgramVar2, termVariable2);
                termArray[n] = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable2, (Term)termVariable);
                ++n;
                ++n5;
            }
            ++n3;
        }
        assert (callStatement.getLhs().length == n);
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])termArray);
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    @Deprecated
    public TranslationResult resultAssignment(JoinStatement joinStatement, String string, String string2, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.initialize(string);
        Procedure procedure = this.mBoogieDeclarations.getProcImplementation().get(string2);
        int n = 0;
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, string2);
        Term[] termArray = new Term[joinStatement.getLhs().length];
        VarList[] varListArray = procedure.getOutParams();
        int n2 = varListArray.length;
        int n3 = 0;
        while (n3 < n2) {
            VarList varList = varListArray[n3];
            String[] stringArray = varList.getIdentifiers();
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string3 = stringArray[n5];
                IProgramVar iProgramVar = this.mBoogie2SmtSymbolTable.getBoogieVar(string3, declarationInformation, false);
                TermVariable termVariable = this.constructTermVariableWithSuffix(iProgramVar, "OutParam");
                this.mTransFormulaBuilder.addInVar(iProgramVar, termVariable);
                String string4 = joinStatement.getLhs()[n].getIdentifier();
                DeclarationInformation declarationInformation2 = joinStatement.getLhs()[n].getDeclarationInformation();
                IProgramVar iProgramVar2 = this.mBoogie2SmtSymbolTable.getBoogieVar(string4, declarationInformation2, false);
                TermVariable termVariable2 = this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(iProgramVar2.getGloballyUniqueId(), iProgramVar2.getTermVariable().getSort());
                this.mTransFormulaBuilder.addOutVar(iProgramVar2, termVariable2);
                termArray[n] = SmtUtils.binaryEquality((Script)this.mScript, (Term)termVariable2, (Term)termVariable);
                ++n;
                ++n5;
            }
            ++n3;
        }
        assert (joinStatement.getLhs().length == n);
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])termArray);
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    public TermVariable constructTermVariableWithSuffix(IProgramVar iProgramVar, String string) {
        String string2 = iProgramVar.getGloballyUniqueId() + SmtUtils.removeSmtQuoteCharacters((String)string);
        Sort sort = iProgramVar.getTermVariable().getSort();
        TermVariable termVariable = this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(string2, sort);
        return termVariable;
    }

    public class GlobalVarTranslatorWithInOutVarManagement
    extends IdentifierTranslatorWithInOutVarManagement {
        private final String mInnerCurrentProcedure;
        private final boolean mAllNonOld;
        private final Set<String> mModifiableByCurrentProcedure;

        public GlobalVarTranslatorWithInOutVarManagement(String string, boolean bl) {
            this.mInnerCurrentProcedure = string;
            this.mAllNonOld = bl;
            this.mModifiableByCurrentProcedure = Statements2TransFormula.this.mBoogieDeclarations.getModifiedVars().get(this.mInnerCurrentProcedure);
        }

        @Override
        protected IProgramVar getBoogieVar(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
            DeclarationInformation.StorageClass storageClass = declarationInformation.getStorageClass();
            return switch (storageClass) {
                case DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, DeclarationInformation.StorageClass.LOCAL -> null;
                case DeclarationInformation.StorageClass.GLOBAL -> {
                    if (bl) {
                        if (this.mAllNonOld || !this.modifiableByCurrentProcedure(string)) {
                            yield Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(string, declarationInformation, false);
                        }
                        yield Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(string, declarationInformation, true);
                    }
                    yield Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(string, declarationInformation, false);
                }
                case DeclarationInformation.StorageClass.QUANTIFIED, DeclarationInformation.StorageClass.IMPLEMENTATION, DeclarationInformation.StorageClass.PROC_FUNC -> throw new AssertionError();
                default -> throw new MatchException(null, null);
            };
        }

        private boolean modifiableByCurrentProcedure(String string) {
            return this.mModifiableByCurrentProcedure.contains(string);
        }
    }

    public abstract class IdentifierTranslatorWithInOutVarManagement
    implements Expression2Term.IIdentifierTranslator {
        @Override
        public Term getSmtIdentifier(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
            IProgramVar iProgramVar = this.getBoogieVar(string, declarationInformation, bl, boogieASTNode);
            if (iProgramVar == null) {
                return null;
            }
            TermVariable termVariable = Statements2TransFormula.this.getOrConstuctCurrentRepresentative(iProgramVar);
            return termVariable;
        }

        protected abstract IProgramVar getBoogieVar(String var1, DeclarationInformation var2, boolean var3, BoogieASTNode var4);
    }

    public class LocalVarTranslatorWithInOutVarManagement
    extends IdentifierTranslatorWithInOutVarManagement {
        @Override
        protected IProgramVar getBoogieVar(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
            DeclarationInformation.StorageClass storageClass = declarationInformation.getStorageClass();
            return switch (storageClass) {
                case DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, DeclarationInformation.StorageClass.LOCAL -> Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(string, declarationInformation, bl);
                case DeclarationInformation.StorageClass.GLOBAL -> null;
                case DeclarationInformation.StorageClass.QUANTIFIED, DeclarationInformation.StorageClass.IMPLEMENTATION, DeclarationInformation.StorageClass.PROC_FUNC -> throw new AssertionError();
                default -> throw new MatchException(null, null);
            };
        }
    }

    public class SubstitutionTranslatorBoogieVar
    implements Expression2Term.IIdentifierTranslator {
        private final Map<IProgramVar, Term> mSubstitution;

        public SubstitutionTranslatorBoogieVar(Map<IProgramVar, Term> map) {
            this.mSubstitution = map;
        }

        @Override
        public Term getSmtIdentifier(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
            IProgramVar iProgramVar = Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(string, declarationInformation, bl);
            if (iProgramVar == null) {
                return null;
            }
            return this.mSubstitution.get(iProgramVar);
        }
    }

    private static class SubstitutionTranslatorId
    implements Expression2Term.IIdentifierTranslator {
        private final Map<String, Term> mSubstitution;

        public SubstitutionTranslatorId(Map<String, Term> map) {
            this.mSubstitution = map;
        }

        @Override
        public Term getSmtIdentifier(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
            return this.mSubstitution.get(string);
        }
    }

    public static final class TranslationResult {
        private final UnmodifiableTransFormula mTransFormula;
        private final Map<String, ILocation> mOverapproximations;

        public TranslationResult(UnmodifiableTransFormula unmodifiableTransFormula, Map<String, ILocation> map) {
            this.mTransFormula = unmodifiableTransFormula;
            this.mOverapproximations = map;
        }

        public UnmodifiableTransFormula getTransFormula() {
            return this.mTransFormula;
        }

        public Map<String, ILocation> getOverapproximations() {
            return this.mOverapproximations;
        }
    }
}

