/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;

public class SolvedBinaryRelation
implements ITermProvider {
    private final Term mLeftHandSide;
    private final Term mRightHandSide;
    private final RelationSymbol mRelationSymbol;
    private final EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> mIntricateOperations;

    public SolvedBinaryRelation(Term term, Term term2, RelationSymbol relationSymbol, MultiCaseSolvedBinaryRelation.IntricateOperation ... intricateOperationArray) {
        this.mLeftHandSide = term;
        this.mRightHandSide = term2;
        this.mRelationSymbol = relationSymbol;
        if (intricateOperationArray.length == 0) {
            this.mIntricateOperations = EnumSet.noneOf(MultiCaseSolvedBinaryRelation.IntricateOperation.class);
        } else {
            if (intricateOperationArray[0] == null) {
                throw new NullPointerException();
            }
            this.mIntricateOperations = EnumSet.copyOf(Arrays.asList(intricateOperationArray));
        }
    }

    public Term getLeftHandSide() {
        return this.mLeftHandSide;
    }

    public Term getRightHandSide() {
        return this.mRightHandSide;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> getIntricateOperation() {
        assert (this.mIntricateOperations != null);
        return this.mIntricateOperations;
    }

    @Override
    public Term toTerm(Script script) {
        return script.term(this.mRelationSymbol.toString(), new Term[]{this.mLeftHandSide, this.mRightHandSide});
    }

    public String toString() {
        return String.valueOf(this.mLeftHandSide) + " " + String.valueOf((Object)this.mRelationSymbol) + " " + String.valueOf(this.mRightHandSide);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mIntricateOperations, this.mLeftHandSide, this.mRelationSymbol, this.mRightHandSide});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SolvedBinaryRelation solvedBinaryRelation = (SolvedBinaryRelation)object;
        if (this.mIntricateOperations == null ? solvedBinaryRelation.mIntricateOperations != null : !this.mIntricateOperations.equals(solvedBinaryRelation.mIntricateOperations)) {
            return false;
        }
        if (this.mLeftHandSide == null ? solvedBinaryRelation.mLeftHandSide != null : !this.mLeftHandSide.equals(solvedBinaryRelation.mLeftHandSide)) {
            return false;
        }
        if (this.mRelationSymbol != solvedBinaryRelation.mRelationSymbol) {
            return false;
        }
        return !(this.mRightHandSide == null ? solvedBinaryRelation.mRightHandSide != null : !this.mRightHandSide.equals(solvedBinaryRelation.mRightHandSide));
    }

    public static enum AssumptionForSolvability {
        INTEGER_DIVISIBLE_BY_CONSTANT,
        REAL_DIVISOR_NOT_ZERO,
        INTEGER_DIVISOR_NOT_ZERO,
        INTEGER_DIVISIBLE_BY_VARIABLE;

    }
}

