/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IAbstractStateStorage;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class IcfgAbstractStateStorageProvider<STATE extends IAbstractState<STATE>, ACTION extends IAction, LOC, VARDECL>
implements IAbstractStateStorage<STATE, ACTION, LOC> {
    private final Map<LOC, DisjunctiveAbstractState<STATE>> mStorage;
    private final IUltimateServiceProvider mServices;
    private final Set<IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL>> mChildStores;
    private final ITransitionProvider<ACTION, LOC> mTransProvider;
    private final ACTION mScope;
    private final Set<ACTION> mScopeFixpoints;
    private final IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL> mParent;
    private final Set<String> mUsedSummary;

    public IcfgAbstractStateStorageProvider(IUltimateServiceProvider iUltimateServiceProvider, ITransitionProvider<ACTION, LOC> iTransitionProvider) {
        this(iUltimateServiceProvider, iTransitionProvider, null, null, new HashSet<String>());
    }

    private IcfgAbstractStateStorageProvider(IUltimateServiceProvider iUltimateServiceProvider, ITransitionProvider<ACTION, LOC> iTransitionProvider, ACTION ACTION, IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL> icfgAbstractStateStorageProvider, Set<String> set) {
        assert (iUltimateServiceProvider != null);
        assert (iTransitionProvider != null);
        this.mServices = iUltimateServiceProvider;
        this.mTransProvider = iTransitionProvider;
        this.mScope = ACTION;
        this.mParent = icfgAbstractStateStorageProvider;
        this.mChildStores = new HashSet<IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL>>();
        this.mScopeFixpoints = new HashSet<ACTION>();
        this.mStorage = new HashMap<LOC, DisjunctiveAbstractState<STATE>>();
        this.mUsedSummary = set;
    }

    @Override
    public DisjunctiveAbstractState<STATE> addAbstractState(LOC LOC, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        assert (LOC != null) : "Cannot add state to non-existing location";
        assert (disjunctiveAbstractState != null) : "Cannot add null state";
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState2 = this.mStorage.get(LOC);
        if (disjunctiveAbstractState2 == null) {
            this.mStorage.put(LOC, disjunctiveAbstractState);
            return disjunctiveAbstractState;
        }
        DisjunctiveAbstractState disjunctiveAbstractState3 = disjunctiveAbstractState2.saturatedUnion(disjunctiveAbstractState);
        this.mStorage.put(LOC, disjunctiveAbstractState3);
        return disjunctiveAbstractState3;
    }

    @Override
    public final IAbstractStateStorage<STATE, ACTION, LOC> createStorage(ACTION ACTION) {
        IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL> icfgAbstractStateStorageProvider = new IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL>(this.getServices(), this.getTransitionProvider(), ACTION, this, this.mUsedSummary);
        this.mChildStores.add(icfgAbstractStateStorageProvider);
        return icfgAbstractStateStorageProvider;
    }

    @Override
    public final Map<LOC, Set<DisjunctiveAbstractState<STATE>>> computeLoc2States() {
        Set<IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL>> set = this.getAllStores();
        HashMap hashMap = new HashMap();
        for (IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL> icfgAbstractStateStorageProvider : set) {
            for (Map.Entry<LOC, DisjunctiveAbstractState<STATE>> entry : icfgAbstractStateStorageProvider.mStorage.entrySet()) {
                Set set2 = (Set)hashMap.get(entry.getKey());
                if (set2 == null) {
                    HashSet<DisjunctiveAbstractState<STATE>> hashSet = new HashSet<DisjunctiveAbstractState<STATE>>();
                    hashSet.add(entry.getValue());
                    hashMap.put(entry.getKey(), hashSet);
                    continue;
                }
                set2.add(entry.getValue());
            }
        }
        return hashMap;
    }

    @Override
    public DisjunctiveAbstractState<STATE> getAbstractState(LOC LOC) {
        return this.mStorage.get(LOC);
    }

    @Override
    public Set<STATE> computeContextSensitiveAbstractPostStates(Deque<ACTION> deque, ACTION ACTION) {
        assert (ACTION != null);
        assert (this.mScope == null);
        Set<Pair<Deque<ACTION>, ACTION>> set = this.getSummaryCallStack(deque, ACTION);
        return this.getAbstractPostStatesWithSummary(set);
    }

    private Set<STATE> getAbstractPostStatesWithSummary(Set<Pair<Deque<ACTION>, ACTION>> set) {
        HashSet hashSet = new HashSet();
        set.forEach(pair -> {
            boolean bl = hashSet.addAll(this.getAbstractPostStatesWithSummary((Deque)pair.getFirst(), (IAction)pair.getSecond()));
        });
        return hashSet;
    }

    private Set<STATE> getAbstractPostStatesWithSummary(Deque<ACTION> deque, ACTION ACTION) {
        Collection collection;
        Object object;
        Iterator<ACTION> iterator = deque.descendingIterator();
        Collection<IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL>> collection2 = Collections.singletonList(this);
        while (iterator.hasNext()) {
            object = (IAction)iterator.next();
            collection = collection2.stream().flatMap(icfgAbstractStateStorageProvider -> icfgAbstractStateStorageProvider.mChildStores.stream()).filter(arg_0 -> IcfgAbstractStateStorageProvider.lambda$2((IAction)object, arg_0)).collect(Collectors.toList());
            collection2.stream().filter(arg_0 -> IcfgAbstractStateStorageProvider.lambda$3((IAction)object, arg_0)).forEach(arg_0 -> collection.add(arg_0));
            collection2 = collection;
        }
        object = this.mTransProvider.getTarget(ACTION);
        collection = collection2.stream().map(icfgAbstractStateStorageProvider -> Optional.ofNullable(icfgAbstractStateStorageProvider.getAbstractState(object)).map(disjunctiveAbstractState -> disjunctiveAbstractState.getStates()).orElse(Collections.emptySet())).flatMap(set -> set.stream()).collect(Collectors.toSet());
        return collection;
    }

    private Set<Pair<Deque<ACTION>, ACTION>> getSummaryCallStack(Deque<ACTION> deque, ACTION ACTION) {
        Object object;
        int n;
        Map map;
        Map map2 = Collections.emptyMap();
        Map map3 = Collections.emptyMap();
        Set set = deque.stream().filter(iAction -> this.mUsedSummary.contains(iAction.getSucceedingProcedure())).collect(Collectors.toSet());
        if (ACTION instanceof IIcfgCallTransition && this.mUsedSummary.contains(ACTION.getSucceedingProcedure())) {
            set.add(ACTION);
        }
        HashSet hashSet = new HashSet();
        if (ACTION instanceof IIcfgReturnTransition && this.mUsedSummary.contains(ACTION.getPrecedingProcedure())) {
            hashSet.addAll((Collection)map2.get(ACTION));
        }
        if (set.isEmpty() && hashSet.isEmpty()) {
            return Collections.singleton(new Pair(deque, ACTION));
        }
        Comparator<IAction> comparator = Comparator.comparing(Object::hashCode);
        Pair<Map<IAction, List<IAction>>, Integer> pair = this.getReplacementRules(set, comparator, map3);
        Map map4 = (Map)pair.getFirst();
        if (ACTION instanceof IIcfgCallTransition) {
            map = map4;
            n = (Integer)pair.getSecond();
        } else if (ACTION instanceof IIcfgReturnTransition) {
            object = this.getReplacementRules(hashSet, comparator, map2);
            map = (Map)object.getFirst();
            n = Math.max((Integer)pair.getSecond(), (Integer)object.getSecond());
        } else {
            map = Collections.emptyMap();
            n = (Integer)pair.getSecond();
        }
        object = new HashSet();
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            ArrayDeque<IAction> arrayDeque = new ArrayDeque<IAction>();
            Iterator<ACTION> iterator = deque.descendingIterator();
            while (iterator.hasNext()) {
                object2 = (IAction)iterator.next();
                arrayDeque.addFirst(this.getMatchingSymbol(n2, object2, (List)map4.get(object2)));
            }
            object2 = this.getMatchingSymbol(n2, ACTION, (List)map.get(ACTION));
            object.add(new Pair(arrayDeque, object2));
            ++n2;
        }
        return object;
    }

    private Pair<Map<ACTION, List<ACTION>>, Integer> getReplacementRules(Set<ACTION> set, Comparator<ACTION> comparator, Map<ACTION, Set<ACTION>> map) {
        int n = 0;
        HashMap hashMap = new HashMap();
        for (IAction iAction : set) {
            Set<ACTION> set2 = map.get(iAction);
            assert (!set2.isEmpty()) : "Should use summary, but dont know which";
            hashMap.put(iAction, set2.stream().sorted(comparator).collect(Collectors.toList()));
            int n2 = set2.size();
            n = Math.max(n2, n);
        }
        return new Pair(hashMap, (Object)n);
    }

    private ACTION getMatchingSymbol(int n, ACTION ACTION, List<ACTION> list) {
        if (list == null || list.isEmpty()) {
            return ACTION;
        }
        int n2 = list.size();
        if (n < n2) {
            return (ACTION)((IAction)list.get(n));
        }
        return (ACTION)((IAction)list.get(n2 - 1));
    }

    @Override
    public void scopeFixpointReached() {
        this.mParent.mScopeFixpoints.add(this.mScope);
    }

    @Override
    public void saveSummarySubstituion(ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, ACTION ACTION2) {
        assert (ACTION instanceof IIcfgCallTransition);
        this.mParent.mUsedSummary.add(ACTION.getSucceedingProcedure());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mScope).append(" ");
        if (this.mStorage == null) {
            return stringBuilder.append("NULL").toString();
        }
        if (this.mStorage.isEmpty()) {
            return stringBuilder.append("{}").toString();
        }
        stringBuilder.append('{');
        Set<Map.Entry<LOC, DisjunctiveAbstractState<STATE>>> set = this.mStorage.entrySet();
        for (Map.Entry<LOC, DisjunctiveAbstractState<STATE>> entry : set) {
            stringBuilder.append(entry.getKey().toString()).append("=[");
            DisjunctiveAbstractState<STATE> disjunctiveAbstractState = entry.getValue();
            if (!disjunctiveAbstractState.isEmpty()) {
                stringBuilder.append(disjunctiveAbstractState.toLogString());
            }
            stringBuilder.append("], ");
        }
        if (!set.isEmpty()) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String toTreeString() {
        return this.toTreeString(new StringBuilder(), "").toString();
    }

    public StringBuilder toTreeString(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(this.toString()).append(CoreUtil.getPlatformLineSeparator());
        this.mChildStores.forEach(icfgAbstractStateStorageProvider -> {
            StringBuilder stringBuilder2 = icfgAbstractStateStorageProvider.toTreeString(stringBuilder, string + "  ");
        });
        return stringBuilder;
    }

    private Set<IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL>> getAllStores() {
        HashSet<IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL>> hashSet = new HashSet<IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL>>();
        hashSet.add(this);
        for (IcfgAbstractStateStorageProvider<STATE, ACTION, LOC, VARDECL> icfgAbstractStateStorageProvider : this.mChildStores) {
            hashSet.addAll(icfgAbstractStateStorageProvider.getAllStores());
        }
        return hashSet;
    }

    private boolean containsScopeFixpoint(ACTION ACTION) {
        return this.mScopeFixpoints.contains(ACTION);
    }

    protected IUltimateServiceProvider getServices() {
        return this.mServices;
    }

    protected ITransitionProvider<ACTION, LOC> getTransitionProvider() {
        return this.mTransProvider;
    }

    private static /* synthetic */ boolean lambda$2(IAction iAction, IcfgAbstractStateStorageProvider icfgAbstractStateStorageProvider) {
        return icfgAbstractStateStorageProvider.mScope == iAction;
    }

    private static /* synthetic */ boolean lambda$3(IAction iAction, IcfgAbstractStateStorageProvider icfgAbstractStateStorageProvider) {
        return icfgAbstractStateStorageProvider.containsScopeFixpoint(iAction);
    }
}

