/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.FinitePrefix;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ICoRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.Set;

public final class CoenabledRelation<LETTER> {
    private final HashRelation<LETTER, LETTER> mRelation;

    private CoenabledRelation(HashRelation<LETTER, LETTER> hashRelation) {
        this.mRelation = hashRelation;
    }

    public static <PLACE, LETTER> CoenabledRelation<LETTER> fromPetriNet(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        Object object = new FinitePrefix<LETTER, PLACE>(automataLibraryServices, iPetriNet).getResult();
        return new CoenabledRelation<LETTER>(CoenabledRelation.computeFromBranchingProcess(object));
    }

    private static <PLACE, LETTER> HashRelation<LETTER, LETTER> computeFromBranchingProcess(BranchingProcess<LETTER, PLACE> branchingProcess) {
        HashRelation hashRelation = new HashRelation();
        ICoRelation<LETTER, PLACE> iCoRelation = branchingProcess.getCoRelation();
        Collection<Event<LETTER, PLACE>> collection = branchingProcess.getEvents();
        for (Event<LETTER, PLACE> event : collection) {
            if (branchingProcess.getDummyRoot() == event) continue;
            Set<Event<LETTER, PLACE>> set = iCoRelation.computeCoRelatatedEvents(event);
            for (Event<LETTER, PLACE> event2 : set) {
                hashRelation.addPair(event.getTransition().getSymbol(), event2.getTransition().getSymbol());
            }
        }
        return hashRelation;
    }

    public int size() {
        return this.mRelation.size();
    }

    public Set<LETTER> getImage(LETTER LETTER) {
        return this.mRelation.getImage(LETTER);
    }

    public void copyRelationships(LETTER LETTER, LETTER LETTER2) {
        for (Object e : this.mRelation.getImage(LETTER)) {
            this.mRelation.addPair(LETTER2, e);
        }
        for (Object e : this.mRelation.getDomain()) {
            if (!this.mRelation.containsPair(e, LETTER)) continue;
            this.mRelation.addPair(e, LETTER2);
        }
    }

    public void deleteElement(LETTER LETTER) {
        this.mRelation.removeDomainElement(LETTER);
        this.mRelation.removeRangeElement(LETTER);
    }
}

