/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class VariadicLibraryModel
implements ILibraryModel {
    private final FunctionModelHelper mHelper;
    private final MemoryHandler mMemoryHandler;
    private final ProcedureManager mProcedureManager;
    private final ITypeHandler mTypeHandler;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;

    public VariadicLibraryModel(FunctionModelHelper functionModelHelper, MemoryHandler memoryHandler, ProcedureManager procedureManager, ITypeHandler iTypeHandler, ExpressionResultTransformer expressionResultTransformer, ExpressionTranslation expressionTranslation, AuxVarInfoBuilder auxVarInfoBuilder) {
        this.mHelper = functionModelHelper;
        this.mMemoryHandler = memoryHandler;
        this.mProcedureManager = procedureManager;
        this.mTypeHandler = iTypeHandler;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        return List.of(new ILibraryModel.FunctionModel("va_start", this::handleVaStart), new ILibraryModel.FunctionModel("__builtin_va_start", this::handleVaStart), new ILibraryModel.FunctionModel("va_end", this::handleVaEnd), new ILibraryModel.FunctionModel("__builtin_va_end", this::handleVaEnd), new ILibraryModel.FunctionModel("va_copy", this::handleVaCopy), new ILibraryModel.FunctionModel("__builtin_va_copy", this::handleVaCopy));
    }

    private List<Statement> makeVarargAssignment(ILocation iLocation, LRValue lRValue, Expression expression) {
        if (lRValue instanceof LocalLValue) {
            return List.of(StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)((LocalLValue)lRValue).getLhs(), (Expression)expression));
        }
        if (lRValue instanceof HeapLValue) {
            return this.mMemoryHandler.getWriteCall(iLocation, (HeapLValue)lRValue, expression, lRValue.getCType(), false);
        }
        if (lRValue instanceof RValue) {
            RValue rValue = (RValue)lRValue;
            return this.makeVarargAssignment(iLocation, new HeapLValue(rValue.getValue(), rValue.getCType(), null), expression);
        }
        throw new UnsupportedOperationException("Unsupported type " + lRValue.getClass().getSimpleName());
    }

    private Result handleVaStart(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[0]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expressionResultBuilder.addAllExceptLrValue((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[1]));
        String string2 = this.mProcedureManager.getCurrentProcedureID();
        IdentifierExpression identifierExpression = new IdentifierExpression(iLocation, (IBoogieType)this.mTypeHandler.getBoogiePointerType(), "#varArgs", new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string2));
        return expressionResultBuilder.addStatements(this.makeVarargAssignment(iLocation, expressionResult.getLrValue(), (Expression)identifierExpression)).build();
    }

    private Result handleVaEnd(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(expressionResult.getLrValue());
        Expression expression = this.mMemoryHandler.initialPointerFromPointer(iLocation, expressionResult.getLrValue().getValue());
        RValue rValue = new RValue(expression, expressionResult.getCType());
        expressionResultBuilder.addStatements(this.mMemoryHandler.getChecksForFreeCall(iLocation, rValue));
        CallStatement callStatement = this.mMemoryHandler.getDeallocCall(rValue, iLocation);
        expressionResultBuilder.addStatement((Statement)callStatement);
        return expressionResultBuilder.build();
    }

    private Result handleVaCopy(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[0]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expressionResultBuilder.addAllExceptLrValue((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[1]));
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)), SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        List<Statement> list = this.makeVarargAssignment(iLocation, expressionResult.getLrValue(), (Expression)auxVarInfo.getExp());
        list.forEach(arg_0 -> ((Overapprox)new Overapprox(string, iLocation)).annotate(arg_0));
        return expressionResultBuilder.addStatements(list).build();
    }

    @Override
    public Collection<ILibraryModel.TypeModel> getTypeModels() {
        CPointer cPointer = new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR));
        return List.of(new ILibraryModel.TypeModel("__builtin_va_list", cPointer), new ILibraryModel.TypeModel("va_list", cPointer));
    }
}

