/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;

public class LoopEntryAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private static final String KEY = LoopEntryAnnotation.class.getName();
    @Visualizable
    private final LoopEntryType mType;

    public LoopEntryAnnotation(LoopEntryType loopEntryType) {
        this.mType = loopEntryType;
    }

    public LoopEntryType getLoopEntryType() {
        return this.mType;
    }

    public void annotate(IElement iElement) {
        iElement.getPayload().getAnnotations().put(KEY, this);
    }

    public static LoopEntryAnnotation getAnnotation(IElement iElement) {
        return (LoopEntryAnnotation)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, iAnnotations -> (LoopEntryAnnotation)iAnnotations);
    }

    public String toString() {
        return this.mType.toString();
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations instanceof LoopEntryAnnotation) {
            LoopEntryAnnotation loopEntryAnnotation = (LoopEntryAnnotation)iAnnotations;
            if (loopEntryAnnotation.mType.equals((Object)this.mType)) {
                return this;
            }
            return new LoopEntryAnnotation(LoopEntryType.UNKNOWN);
        }
        return super.merge(iAnnotations);
    }

    public static enum LoopEntryType {
        GOTO,
        WHILE,
        UNKNOWN;

    }
}

