/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.LassoShapedNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeometricNonTerminationArgumentResult<P extends IElement, E>
extends LassoShapedNonTerminationArgument<P, E> {
    private static final int SCHEMATIC_EXECUTION_LENGTH = 3;
    private static final boolean ALTERNATIVE_LONG_DESCRIPTION = true;
    private final Map<E, Rational> mStateInit;
    private final Map<E, Rational> mStateHonda;
    private final List<Map<E, Rational>> mRays;
    private final List<Rational> mLambdas;
    private final List<Rational> mNus;

    public GeometricNonTerminationArgumentResult(P p, String string, Map<E, Rational> map, Map<E, Rational> map2, List<Map<E, Rational>> list, List<Rational> list2, List<Rational> list3, IBacktranslationService iBacktranslationService, Class<E> clazz, IProgramExecution<P, E> iProgramExecution, IProgramExecution<P, E> iProgramExecution2) {
        super(p, string, iBacktranslationService, clazz, iProgramExecution, iProgramExecution2);
        this.mStateInit = map;
        this.mStateHonda = map2;
        this.mRays = list;
        this.mLambdas = list2;
        this.mNus = list3;
        assert (this.mRays.size() == this.mLambdas.size());
    }

    @Override
    public String getShortDescription() {
        return "Nontermination argument in form of an infinite program execution.";
    }

    @Override
    public String getLongDescription() {
        return this.alternativeLongDesciption();
    }

    public String defaultLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Nontermination argument in form of an infinite execution\n");
        stringBuilder.append(this.mStateInit);
        Rational[] rationalArray = new Rational[this.mLambdas.size()];
        int n = 0;
        while (n < this.mLambdas.size()) {
            rationalArray[n] = Rational.ZERO;
            ++n;
        }
        n = 0;
        while (n < 3) {
            HashMap<E, String> hashMap = new HashMap<E, String>();
            for (E e : this.mStateHonda.keySet()) {
                Rational rational = this.mStateHonda.get(e);
                int n2 = 0;
                while (n2 < this.mRays.size()) {
                    Rational rational2 = this.mRays.get(n2).get(e);
                    if (rational2 != null) {
                        rational = rational.add(rational2.mul(rationalArray[n2]));
                    }
                    ++n2;
                }
                hashMap.put(e, rational.toString());
            }
            int n3 = this.mRays.size() - 1;
            while (n3 >= 0) {
                rationalArray[n3] = rationalArray[n3].mul(this.mLambdas.get(n3)).add(Rational.ONE);
                if (n3 > 0) {
                    rationalArray[n3] = rationalArray[n3].add(rationalArray[n3 - 1].mul(this.mNus.get(n3 - 1)));
                }
                --n3;
            }
            stringBuilder.append("\n");
            stringBuilder.append(this.printState(hashMap));
            ++n;
        }
        return stringBuilder.toString();
    }

    private String alternativeLongDesciption() {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Nontermination argument in form of an infinite execution\n");
        stringBuilder.append("State at position 0 is\n");
        HashMap<E, String> hashMap2 = new HashMap<E, String>();
        for (Map.Entry<E, Rational> entry : this.mStateInit.entrySet()) {
            Object object3 = entry.getKey();
            object2 = this.mStateInit.get(object3);
            hashMap2.put(object3, object2.toString());
        }
        stringBuilder.append(this.printState(hashMap2));
        stringBuilder.append("\nState at position 1 is\n");
        HashMap<Rational, String> hashMap = new HashMap<Rational, String>();
        for (Map.Entry entry : this.mStateHonda.entrySet()) {
            object2 = entry.getKey();
            object = this.mStateHonda.get(object2);
            hashMap.put((Rational)object2, object.toString());
        }
        stringBuilder.append(this.printState(hashMap));
        stringBuilder.append("\nFor i>1, the state at position i is\n");
        HashMap<E, CallSite> hashMap3 = new HashMap<E, CallSite>();
        for (Object object3 : this.mStateHonda.keySet()) {
            object = new StringBuilder();
            Rational rational = this.mStateHonda.get(object3);
            int n = 0;
            while (n < this.mRays.size()) {
                Rational rational2 = this.mRays.get(n).get(object3);
                if (rational2 != null && !rational2.equals((Object)Rational.ZERO)) {
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append(" + ");
                    }
                    int n2 = 0;
                    while (n2 <= n && n2 < this.mRays.size()) {
                        boolean bl = true;
                        int n3 = n - n2;
                        while (n3 < n) {
                            if (this.mNus.get(n3).equals((Object)Rational.ZERO)) {
                                bl = false;
                            }
                            ++n3;
                        }
                        if (bl) {
                            if (n2 > 0) {
                                ((StringBuilder)object).append(" + ");
                            }
                            Rational rational3 = this.mLambdas.get(n - n2);
                            ((StringBuilder)object).append(rational2);
                            if (n2 == 1) {
                                ((StringBuilder)object).append("*k");
                            } else if (n2 > 1) {
                                ((StringBuilder)object).append("*binomial(k, " + n2 + ")");
                            }
                            if (!rational3.equals((Object)Rational.ONE)) {
                                if (n2 == 0) {
                                    ((StringBuilder)object).append("*" + String.valueOf(rational3) + "^k");
                                } else {
                                    ((StringBuilder)object).append("*" + String.valueOf(rational3) + "^(k-" + n2 + ")");
                                }
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            if (((StringBuilder)object).length() == 0) {
                ((StringBuilder)object).append("0");
            }
            hashMap3.put(object3, (CallSite)((Object)(rational.toString() + " + sum_{k=0}^i " + ((StringBuilder)object).toString())));
        }
        stringBuilder.append(this.printState(hashMap3));
        return stringBuilder.toString();
    }
}

