/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.math.BigInteger;

public class RewriteStrictInequalities
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Replace strict inequalities by non-strict inequalities";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2) {
        Term term = modifiableTransFormula.getFormula();
        Term term2 = modifiableTransFormula2.getFormula();
        return Script.LBool.SAT != Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, term2}));
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript managedScript) {
        return new RewriteStrictInequalitiesTransformer(managedScript.getScript());
    }

    private static final class RewriteStrictInequalitiesTransformer
    extends TermTransformer {
        private final Script mScript;

        RewriteStrictInequalitiesTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        protected void convert(Term term) {
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                String string = applicationTerm.getFunction().getName();
                Term term2 = null;
                if (string.equals("<")) {
                    term2 = this.computeCorrespondingInequality(applicationTerm);
                } else if (string.equals(">")) {
                    term2 = this.computeCorrespondingInequality(applicationTerm);
                }
                if (term2 != null) {
                    this.setResult(term2);
                    return;
                }
            }
            super.convert(term);
        }

        private Term computeCorrespondingInequality(ApplicationTerm applicationTerm) {
            Term term;
            String string = applicationTerm.getFunction().getName();
            if (applicationTerm.getParameters().length != 2) {
                throw new AssertionError((Object)"expected binary terms");
            }
            if (!SmtSortUtils.isIntSort((Sort)applicationTerm.getParameters()[0].getSort())) {
                return null;
            }
            Term term2 = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ONE);
            if (string.equals("<")) {
                term = this.mScript.term("<=", new Term[]{this.mScript.term("+", new Term[]{applicationTerm.getParameters()[0], term2}), applicationTerm.getParameters()[1]});
            } else if (string.equals(">")) {
                term = this.mScript.term(">=", new Term[]{applicationTerm.getParameters()[0], this.mScript.term("+", new Term[]{applicationTerm.getParameters()[1], term2})});
            } else {
                throw new AssertionError();
            }
            return term;
        }
    }
}

