/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUnification;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.abduction.Abducer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SemanticIndependenceConditionGenerator {
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final BasicPredicateFactory mFactory;
    private final boolean mSymmetric;
    private final boolean mStrongQuantifierElimination;

    public SemanticIndependenceConditionGenerator(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, boolean bl) {
        this(iUltimateServiceProvider, managedScript, basicPredicateFactory, bl, false);
    }

    public SemanticIndependenceConditionGenerator(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, boolean bl, boolean bl2) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(SemanticIndependenceConditionGenerator.class);
        this.mMgdScript = managedScript;
        this.mFactory = basicPredicateFactory;
        this.mSymmetric = bl;
        this.mStrongQuantifierElimination = bl2;
    }

    public IPredicate generateCondition(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
        return this.generateCondition(null, unmodifiableTransFormula, unmodifiableTransFormula2);
    }

    public IPredicate generateCondition(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
        UnmodifiableTransFormula unmodifiableTransFormula3 = this.withGuard(iPredicate, this.compose(unmodifiableTransFormula, unmodifiableTransFormula2));
        UnmodifiableTransFormula unmodifiableTransFormula4 = this.withGuard((IPredicate)(this.mSymmetric ? iPredicate : null), this.compose(unmodifiableTransFormula2, unmodifiableTransFormula));
        TransFormulaUnification transFormulaUnification = new TransFormulaUnification(this.mMgdScript, new UnmodifiableTransFormula[]{unmodifiableTransFormula3, unmodifiableTransFormula4});
        Term term2 = this.quantify(transFormulaUnification.getAuxVars(), transFormulaUnification.getUnifiedFormula(unmodifiableTransFormula3));
        Term term3 = this.quantify(transFormulaUnification.getAuxVars(), transFormulaUnification.getUnifiedFormula(unmodifiableTransFormula4));
        HashSet hashSet = new HashSet(transFormulaUnification.getOutVars().values());
        hashSet.removeAll(transFormulaUnification.getInVars().values());
        Term term4 = this.mSymmetric ? new Abducer(this.mServices, this.mMgdScript, hashSet, this.mStrongQuantifierElimination).abduceEquivalence(term2, term3) : new Abducer(this.mServices, this.mMgdScript, hashSet, this.mStrongQuantifierElimination).abduce(term2, term3);
        if (term4 == null) {
            return null;
        }
        HashMap<Term, TermVariable> hashMap = new HashMap<Term, TermVariable>();
        for (Map.Entry term5 : transFormulaUnification.getInVars().entrySet()) {
            assert (!hashMap.containsKey(term5.getValue()));
            hashMap.put((Term)term5.getValue(), ((IProgramVar)term5.getKey()).getTermVariable());
        }
        Term term = Substitution.apply((ManagedScript)this.mMgdScript, hashMap, (Term)term4);
        return this.mFactory.newPredicate(term);
    }

    private final UnmodifiableTransFormula compose(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
        return TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (boolean)false, (boolean)true, (boolean)false, (SmtUtils.SimplificationTechnique)SIMPLIFICATION_TECHNIQUE, Arrays.asList(unmodifiableTransFormula, unmodifiableTransFormula2));
    }

    private final UnmodifiableTransFormula withGuard(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula) {
        if (iPredicate == null) {
            return unmodifiableTransFormula;
        }
        return this.compose(TransFormulaBuilder.constructTransFormulaFromPredicate((IPredicate)iPredicate, (ManagedScript)this.mMgdScript), unmodifiableTransFormula);
    }

    private final Term quantify(Set<TermVariable> set, Term term) {
        Term term2 = SmtUtils.quantifier((Script)this.mMgdScript.getScript(), (int)0, set, (Term)term);
        if (this.mStrongQuantifierElimination) {
            return PartialQuantifierElimination.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)term2, (SmtUtils.SimplificationTechnique)SIMPLIFICATION_TECHNIQUE);
        }
        return PartialQuantifierElimination.eliminateLight((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)term2);
    }

    public boolean isSymmetric() {
        return this.mSymmetric;
    }
}

