/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie;

import de.uni_freiburg.informatik.ultimate.core.lib.models.ObjectContainer;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.Activator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.VerificationResultTransformer;
import de.uni_freiburg.informatik.ultimate.pea2boogie.preferences.Pea2BoogiePreferences;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.Req2CauseTrackingPeaTransformer;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.ReqTestResultUtil;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.RedundancyTransformer;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.Req2BoogieTranslator;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;

public class PEAtoBoogieObserver
extends BaseObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private IElement mBoogieAST;

    public PEAtoBoogieObserver(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (!(iElement instanceof ObjectContainer)) {
            return false;
        }
        List list = (List)((ObjectContainer)iElement).getValue();
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            return false;
        }
        this.mBoogieAST = this.generateBoogie(list);
        return false;
    }

    public IElement getResult() {
        return this.mBoogieAST;
    }

    private IElement generateBoogie(List<PatternType<?>> list) {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        Pea2BoogiePreferences.PEATransformerMode pEATransformerMode = (Pea2BoogiePreferences.PEATransformerMode)iPreferenceProvider.getEnum("PEA Transformation Mode", Pea2BoogiePreferences.PEATransformerMode.class);
        if (pEATransformerMode == Pea2BoogiePreferences.PEATransformerMode.REQ_CHECK) {
            return this.generateReqCheckBoogie(list);
        }
        if (pEATransformerMode == Pea2BoogiePreferences.PEATransformerMode.REQ_TEST) {
            return this.generateReqTestBoogie(list);
        }
        if (pEATransformerMode == Pea2BoogiePreferences.PEATransformerMode.REQ_RED) {
            return this.generateReqCheckRedundancyBoogie(list);
        }
        return null;
    }

    private IElement generateReqCheckBoogie(List<PatternType<?>> list) {
        Req2BoogieTranslator req2BoogieTranslator = new Req2BoogieTranslator(this.mServices, this.mLogger, list, Collections.emptyList());
        VerificationResultTransformer verificationResultTransformer = new VerificationResultTransformer(this.mLogger, this.mServices, req2BoogieTranslator.getReqSymbolTable());
        UnaryOperator unaryOperator = verificationResultTransformer::convertTraceAbstractionResult;
        this.mServices.getResultService().registerTransformer("CexReducer", unaryOperator);
        return req2BoogieTranslator.getUnit();
    }

    private IElement generateReqTestBoogie(List<PatternType<?>> list) {
        Req2CauseTrackingPeaTransformer req2CauseTrackingPeaTransformer = new Req2CauseTrackingPeaTransformer(this.mServices, this.mLogger);
        Req2BoogieTranslator req2BoogieTranslator = new Req2BoogieTranslator(this.mServices, this.mLogger, list, Collections.singletonList(req2CauseTrackingPeaTransformer));
        ReqTestResultUtil reqTestResultUtil = new ReqTestResultUtil(this.mLogger, this.mServices, req2BoogieTranslator.getReqSymbolTable(), req2CauseTrackingPeaTransformer.getEffectStore());
        UnaryOperator unaryOperator = reqTestResultUtil::convertTraceAbstractionResult;
        this.mServices.getResultService().registerTransformer("CexReducer", unaryOperator);
        return req2BoogieTranslator.getUnit();
    }

    private IElement generateReqCheckRedundancyBoogie(List<PatternType<?>> list) {
        RedundancyTransformer redundancyTransformer = new RedundancyTransformer(this.mServices, this.mLogger);
        Req2BoogieTranslator req2BoogieTranslator = new Req2BoogieTranslator(this.mServices, this.mLogger, list, Collections.singletonList(redundancyTransformer));
        VerificationResultTransformer verificationResultTransformer = new VerificationResultTransformer(this.mLogger, this.mServices, req2BoogieTranslator.getReqSymbolTable());
        UnaryOperator unaryOperator = verificationResultTransformer::convertTraceAbstractionResult;
        this.mServices.getResultService().registerTransformer("CexReducer", unaryOperator);
        return req2BoogieTranslator.getUnit();
    }
}

