/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.exceptions;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackReceiver;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ToolchainCanceledException
extends RuntimeException
implements IRunningTaskStackProvider,
IRunningTaskStackReceiver {
    private static final long serialVersionUID = 7090759880566576629L;
    private static final String MESSAGE = "Timeout or Toolchain cancelled by user";
    private final transient List<RunningTaskInfo> mRunningTaskInfos = new ArrayList<RunningTaskInfo>();

    public ToolchainCanceledException(Class<?> clazz) {
        this(MESSAGE, new RunningTaskInfo(clazz, null));
    }

    public ToolchainCanceledException(Class<?> clazz, String string) {
        this(MESSAGE, new RunningTaskInfo(clazz, string));
    }

    public ToolchainCanceledException(RunningTaskInfo runningTaskInfo) {
        this(MESSAGE, runningTaskInfo);
    }

    public ToolchainCanceledException(IRunningTaskStackProvider iRunningTaskStackProvider, RunningTaskInfo runningTaskInfo) {
        this(MESSAGE, iRunningTaskStackProvider, runningTaskInfo);
    }

    public ToolchainCanceledException(String string, Class<?> clazz, String string2) {
        this(string, new RunningTaskInfo(clazz, string2));
    }

    public ToolchainCanceledException(String string, RunningTaskInfo runningTaskInfo) {
        this(string, null, runningTaskInfo);
    }

    protected ToolchainCanceledException(String string, IRunningTaskStackProvider iRunningTaskStackProvider, RunningTaskInfo runningTaskInfo) {
        super(Objects.requireNonNull(string));
        if (iRunningTaskStackProvider != null) {
            this.mRunningTaskInfos.addAll(iRunningTaskStackProvider.getRunningTaskStack());
        }
        this.mRunningTaskInfos.add(Objects.requireNonNull(runningTaskInfo));
    }

    @Override
    public void addRunningTaskInfo(RunningTaskInfo runningTaskInfo) {
        this.mRunningTaskInfos.add(runningTaskInfo);
    }

    @Override
    public List<RunningTaskInfo> getRunningTaskStack() {
        return this.mRunningTaskInfos;
    }
}

