/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.fluid;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.IFluid;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;

public class SizeLimitFluid
implements IFluid {
    private final int mMaxDagSize;
    private final int mMaxDisjuncts;

    public SizeLimitFluid(int n, int n2) {
        this.mMaxDagSize = n;
        this.mMaxDisjuncts = n2;
    }

    @Override
    public boolean shallBeAbstracted(IPredicate iPredicate) {
        Term term = iPredicate.getFormula();
        return this.exceedsDagSizeLimit(term) || this.exceedsDisjunctLimit(term);
    }

    private boolean exceedsDagSizeLimit(Term term) {
        if (this.mMaxDagSize < 0) {
            return false;
        }
        return new DAGSize().size(term) > this.mMaxDagSize;
    }

    private boolean exceedsDisjunctLimit(Term term) {
        if (this.mMaxDisjuncts < 0) {
            return false;
        }
        return SizeLimitFluid.numberOfDisjuncts(term) > this.mMaxDisjuncts;
    }

    public static int numberOfDisjuncts(Term term) {
        return SmtUtils.extractApplicationTerms((String)"or", (Term)term, (boolean)true).stream().mapToInt(applicationTerm -> applicationTerm.getParameters().length).sum();
    }
}

