/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

public class IcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final IIcfg<OUTLOC> mResultIcfg;
    private final ILogger mLogger;

    public IcfgTransformer(ILogger iLogger, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string, ITransformulaTransformer iTransformulaTransformer) {
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mResultIcfg = this.transform(iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, string, iTransformulaTransformer);
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string, ITransformulaTransformer iTransformulaTransformer) {
        iTransformulaTransformer.preprocessIcfg(iIcfg);
        BasicIcfg basicIcfg = new BasicIcfg(string, iIcfg.getCfgSmtToolkit(), clazz);
        TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, iLocationFactory, icfgTransformationBacktranslator, iTransformulaTransformer, iIcfg, basicIcfg);
        this.processLocations(iIcfg.getInitialNodes(), transformedIcfgBuilder);
        transformedIcfgBuilder.finish();
        return basicIcfg;
    }

    private void processLocations(Set<INLOC> set, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder) {
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(set);
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        while (icfgLocationIterator.hasNext()) {
            IcfgLocation icfgLocation = icfgLocationIterator.next();
            OUTLOC OUTLOC = transformedIcfgBuilder.createNewLocation(icfgLocation);
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                OUTLOC OUTLOC2 = transformedIcfgBuilder.createNewLocation((IcfgLocation)icfgEdge.getTarget());
                if (icfgEdge instanceof IIcfgReturnTransition) {
                    arrayList.add(new Triple(OUTLOC, OUTLOC2, (Object)icfgEdge));
                    continue;
                }
                transformedIcfgBuilder.createNewTransition(OUTLOC, OUTLOC2, icfgEdge);
            }
        }
        arrayList.forEach(triple -> {
            IcfgEdge icfgEdge = transformedIcfgBuilder.createNewTransition((IcfgLocation)triple.getFirst(), (IcfgLocation)triple.getSecond(), (IcfgEdge)triple.getThird());
        });
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }
}

