/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IteRemover;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushTermWalker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class PartialQuantifierElimination {
    private static final boolean DEBUG_EXPECT_REMOVAL_OF_ALL_QUANTIFIERS = false;

    public static Term eliminate(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term, SmtUtils.SimplificationTechnique simplificationTechnique) {
        Term term2 = PartialQuantifierElimination.eliminateLight(iUltimateServiceProvider, managedScript, term);
        Term term3 = QuantifierPushTermWalker.eliminate(iUltimateServiceProvider, managedScript, true, QuantifierPusher.PqeTechniques.ALL, simplificationTechnique, term2);
        return term3;
    }

    public static Term eliminateLight(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term) {
        Term term2 = new IteRemover(managedScript).transform(term);
        Term term3 = new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.KEEP).transform(term2);
        Term term4 = new CommuhashNormalForm(iUltimateServiceProvider, managedScript.getScript()).transform(term3);
        Term term5 = QuantifierPushTermWalker.eliminate(iUltimateServiceProvider, managedScript, false, QuantifierPusher.PqeTechniques.LIGHT, SmtUtils.SimplificationTechnique.NONE, term4);
        assert (CommuhashUtils.isInCommuhashNormalForm(term5, CommuhashUtils.COMMUTATIVE_OPERATORS)) : "Output not in commuhash form";
        return term5;
    }

    public static Term eliminateCompat(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, QuantifierPusher.PqeTechniques pqeTechniques, SmtUtils.SimplificationTechnique simplificationTechnique, Term term) {
        Term term2 = PartialQuantifierElimination.eliminateLight(iUltimateServiceProvider, managedScript, term);
        return QuantifierPushTermWalker.eliminate(iUltimateServiceProvider, managedScript, bl, pqeTechniques, simplificationTechnique, term2);
    }

    public static Term eliminateCompat(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, SmtUtils.SimplificationTechnique simplificationTechnique, Term term) {
        return PartialQuantifierElimination.eliminateCompat(iUltimateServiceProvider, managedScript, true, QuantifierPusher.PqeTechniques.ALL, simplificationTechnique, term);
    }
}

