/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.PathInvariantsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.InvariantSynthesisStatisticsType;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LinearInequalityInvariantPatternProcessor;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.Collection;
import java.util.Map;

public class InvariantSynthesisStatisticsGenerator
implements IStatisticsDataProvider {
    private int mNumOfPathProgramLocations;
    private int mNumOfPathProgramLocationsAfterLbe;
    private int mMaxNumOfInequalitiesPerRound;
    private int mNumOfPathProgramVars;
    private int mMaxRound;
    private int mTreeSizeSumOfNormalConstraints;
    private int mTreeSizeSumOfApproxConstraints;
    private int mSumOfVarsPerLoc;
    private int mNumOfNonLiveVariables;
    private int mNumOfNonUnsatCoreVars;
    private int mNumOfNonUnsatCoreLocs;
    private int mProgramSizeConjuncts;
    private int mSizeOfLargestTemplate;
    private int mSizeOfSmallestTemplate;
    private int mMotzkinTransformationsForNormalConstr;
    private int mMotzkinTransformationsForApproxConstr;
    private int mMotzkinCoefficientsNormalConstr;
    private int mMotzkinCoefficientsApproxConstr;
    private String mSatStatus;
    private int mSumOfTemplateInequalities;
    private long mConstraintsConstructionTime;
    private long mConstraintsSolvingTime;
    private Integer mProgramSizeDisjuncts;

    public void initializeStatistics() {
        this.mNumOfPathProgramLocations = 0;
        this.mNumOfPathProgramLocationsAfterLbe = 0;
        this.mMaxNumOfInequalitiesPerRound = 0;
        this.mNumOfPathProgramVars = 0;
        this.mNumOfNonUnsatCoreLocs = 0;
        this.mMaxRound = 0;
        this.mSumOfVarsPerLoc = 0;
        this.mNumOfNonLiveVariables = 0;
        this.mNumOfNonUnsatCoreVars = 0;
        this.mProgramSizeConjuncts = 0;
        this.mProgramSizeDisjuncts = 0;
        this.mSizeOfLargestTemplate = 0;
        this.mSizeOfSmallestTemplate = 0;
        this.mSumOfTemplateInequalities = 0;
        this.mTreeSizeSumOfNormalConstraints = 0;
        this.mTreeSizeSumOfApproxConstraints = 0;
        this.mMotzkinTransformationsForNormalConstr = 0;
        this.mMotzkinTransformationsForApproxConstr = 0;
        this.mMotzkinCoefficientsNormalConstr = 0;
        this.mMotzkinCoefficientsApproxConstr = 0;
        this.mSatStatus = "";
        this.mConstraintsConstructionTime = 0L;
        this.mConstraintsSolvingTime = 0L;
    }

    public Collection<String> getKeys() {
        return InvariantSynthesisStatisticsType.getInstance().getKeys();
    }

    public Object getValue(String string) {
        PathInvariantsGenerator.InvariantSynthesisStatisticsDefinitions invariantSynthesisStatisticsDefinitions = PathInvariantsGenerator.InvariantSynthesisStatisticsDefinitions.valueOf(string);
        switch (invariantSynthesisStatisticsDefinitions) {
            case ProgramSizeConjuncts: {
                return this.mProgramSizeConjuncts;
            }
            case ProgramSizeDisjuncts: {
                return this.mProgramSizeDisjuncts;
            }
            case ProgramLocs: {
                return this.mNumOfPathProgramLocations;
            }
            case ProgramLocsLbe: {
                return this.mNumOfPathProgramLocationsAfterLbe;
            }
            case ProgramVars: {
                return this.mNumOfPathProgramVars;
            }
            case SumOfTemplateInequalities: {
                return this.mSumOfTemplateInequalities;
            }
            case SizeOfLargestTemplate: {
                return this.mSizeOfLargestTemplate;
            }
            case SizeOfSmallestTemplate: {
                return this.mSizeOfSmallestTemplate;
            }
            case MaxNumOfInequalities: {
                return this.mMaxNumOfInequalitiesPerRound;
            }
            case MaxRound: {
                return this.mMaxRound;
            }
            case TreeSizeNormalConstr: {
                return this.mTreeSizeSumOfNormalConstraints;
            }
            case TreeSizeApproxConstr: {
                return this.mTreeSizeSumOfApproxConstraints;
            }
            case SumVarsPerLoc: {
                return this.mSumOfVarsPerLoc;
            }
            case SumNonLiveVarsPerLoc: {
                return this.mNumOfNonLiveVariables;
            }
            case SumNonUnsatCoreLocs: {
                return this.mNumOfNonUnsatCoreLocs;
            }
            case SumNonUnsatCoreVars: {
                return this.mNumOfNonUnsatCoreVars;
            }
            case MotzkinTransformationsNormalConstr: {
                return this.mMotzkinTransformationsForNormalConstr;
            }
            case MotzkinTransformationsApproxConstr: {
                return this.mMotzkinTransformationsForApproxConstr;
            }
            case MotzkinCoefficientsNormalConstr: {
                return this.mMotzkinCoefficientsNormalConstr;
            }
            case MotzkinCoefficientsApproxConstr: {
                return this.mMotzkinCoefficientsApproxConstr;
            }
            case ConstraintsSolvingTime: {
                return this.mConstraintsSolvingTime;
            }
            case ConstraintsConstructionTime: {
                return this.mConstraintsConstructionTime;
            }
            case SatStatus: {
                return this.mSatStatus;
            }
        }
        throw new AssertionError((Object)"unknown key");
    }

    public IStatisticsType getBenchmarkType() {
        return InvariantSynthesisStatisticsType.getInstance();
    }

    public void setNumOfPathProgramLocations(int n, int n2) {
        this.mNumOfPathProgramLocations = n;
        this.mNumOfPathProgramLocationsAfterLbe = n2;
    }

    public void setNumOfVars(int n) {
        this.mNumOfPathProgramVars = n;
    }

    public void addStatisticsDataBeforeCheckSat(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n > this.mMaxNumOfInequalitiesPerRound) {
            this.mMaxNumOfInequalitiesPerRound = n;
        }
        this.mSumOfTemplateInequalities += n;
        this.mSumOfVarsPerLoc += n4;
        this.mNumOfNonLiveVariables += n5;
        if (n6 > this.mMaxRound) {
            this.mMaxRound = n6;
        }
        if (n2 > this.mSizeOfLargestTemplate) {
            this.mSizeOfLargestTemplate = n2;
        }
        this.mSizeOfSmallestTemplate = n3;
    }

    public void addStatisticsDataAfterCheckSat(int n, int n2, String string, Map<LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics, Object> map) {
        this.mProgramSizeConjuncts = (Integer)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.ProgramSizeConjuncts);
        this.mProgramSizeDisjuncts = (Integer)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.ProgramSizeDisjuncts);
        this.mTreeSizeSumOfNormalConstraints += ((Integer)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.TreesizeNormalConstraints)).intValue();
        this.mTreeSizeSumOfApproxConstraints += ((Integer)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.TreesizeApproxConstraints)).intValue();
        this.mMotzkinTransformationsForNormalConstr += ((Integer)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.MotzkinTransformationsNormalConstraints)).intValue();
        this.mMotzkinTransformationsForApproxConstr += ((Integer)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.MotzkinTransformationsApproxConstraints)).intValue();
        this.mMotzkinCoefficientsNormalConstr += ((Integer)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.MotzkinCoefficientsNormalConstraints)).intValue();
        this.mMotzkinCoefficientsApproxConstr += ((Integer)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.MotzkinCoefficientsApproxConstraints)).intValue();
        this.mConstraintsSolvingTime += ((Long)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.ConstraintsSolvingTime)).longValue();
        this.mConstraintsConstructionTime += ((Long)map.get((Object)LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics.ConstraintsConstructionTime)).longValue();
        this.mNumOfNonUnsatCoreLocs += n;
        this.mNumOfNonUnsatCoreVars += n2;
        this.mSatStatus = this.mSatStatus == "" ? string : this.mSatStatus + ", " + string;
    }

    public String toString() {
        return StatisticsType.prettyprintBenchmarkData(this.getKeys(), PathInvariantsGenerator.InvariantSynthesisStatisticsDefinitions.class, (IStatisticsDataProvider)this);
    }
}

