/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;

public class InsufficientAnnotationResult<ELEM extends IElement>
extends AbstractResultAtElement<ELEM> {
    private final ILocation mLocationBefore;
    private final ILocation mLocationAfter;
    private final String mStateBefore;
    private final String mStateAfter;

    public <E> InsufficientAnnotationResult(ELEM ELEM, String string, IBacktranslationService iBacktranslationService, ELEM ELEM2, IProgramExecution.ProgramState<E> programState, IProgramExecution.ProgramState<E> programState2) {
        super(ELEM, string);
        this.mLocationBefore = ILocation.getAnnotation(ELEM);
        this.mLocationAfter = ILocation.getAnnotation(ELEM2);
        if (this.mLocationBefore == null) {
            throw new UnsupportedOperationException("position does not have a location");
        }
        if (this.mLocationAfter == null) {
            throw new UnsupportedOperationException("position does not have a location");
        }
        this.mStateBefore = iBacktranslationService.translateProgramStateToString(programState);
        this.mStateAfter = iBacktranslationService.translateProgramStateToString(programState2);
    }

    public String getShortDescription() {
        return "Annotation between " + this.mLocationBefore.getStartLine() + " and " + this.mLocationAfter.getStartLine() + " is not inductive";
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getShortDescription());
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("Counterexample state before: ");
        stringBuilder.append(this.mStateBefore);
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("Counterexample state after: ");
        stringBuilder.append(this.mStateAfter);
        return stringBuilder.toString();
    }
}

