/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PositionAwareTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PositionAwareSubstitution
extends PositionAwareTermTransformer {
    private final ScopedHashMap<SubtreePosition, Term> mScopedPositionSubstitutionMapping = new ScopedHashMap();
    private final ScopedHashMap<Term, Term> mScopedTermSubstitutionMapping;

    public PositionAwareSubstitution(Script script, Map<? extends SubtreePosition, ? extends Term> map, Map<Term, Term> map2) {
        this.mScopedPositionSubstitutionMapping.putAll(map);
        this.mScopedTermSubstitutionMapping = new ScopedHashMap();
        this.mScopedTermSubstitutionMapping.putAll(map2);
    }

    public PositionAwareSubstitution(ManagedScript managedScript, Map<? extends SubtreePosition, ? extends Term> map, Map<Term, Term> map2) {
        this(managedScript.getScript(), map, map2);
    }

    public PositionAwareSubstitution(Script script, Map<? extends SubtreePosition, ? extends Term> map) {
        this(script, map, Collections.emptyMap());
    }

    public PositionAwareSubstitution(ManagedScript managedScript, Map<? extends SubtreePosition, ? extends Term> map) {
        this(managedScript, map, Collections.emptyMap());
    }

    @Override
    protected void convert(Term term, SubtreePosition subtreePosition) {
        if (this.mScopedPositionSubstitutionMapping.containsKey((Object)subtreePosition)) {
            this.setResult((Term)this.mScopedPositionSubstitutionMapping.get((Object)subtreePosition));
        } else if (this.mScopedTermSubstitutionMapping.containsKey((Object)term)) {
            this.setResult((Term)this.mScopedTermSubstitutionMapping.get((Object)term));
        } else {
            if (term instanceof QuantifiedFormula) {
                this.mScopedPositionSubstitutionMapping.beginScope();
                this.mScopedTermSubstitutionMapping.beginScope();
                throw new UnsupportedOperationException("quantified formulas are not yet supported by this class");
            }
            if (term instanceof LetTerm) {
                throw new UnsupportedOperationException("LetTerm not supported");
            }
            super.convert(term, subtreePosition);
        }
    }

    private Term renameQuantifiedVarsThatOccurInValues(QuantifiedFormula quantifiedFormula) {
        DataStructureUtils.union(PositionAwareSubstitution.varsOccuringInValues(quantifiedFormula.getVariables(), this.mScopedPositionSubstitutionMapping), PositionAwareSubstitution.varsOccuringInValues(quantifiedFormula.getVariables(), this.mScopedTermSubstitutionMapping));
        throw new UnsupportedOperationException("quantified formulas are not yet supported by this class");
    }

    private void removeQuantifiedVarContainingKeys(QuantifiedFormula quantifiedFormula) {
        throw new UnsupportedOperationException("quantified formulas are not yet supported by this class");
    }

    private static Set<TermVariable> varsOccuringInValues(TermVariable[] termVariableArray, Map<?, Term> map) {
        Set<TermVariable> set = null;
        for (Term term : map.values()) {
            TermVariable[] termVariableArray2 = term.getFreeVars();
            int n = termVariableArray2.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable termVariable = termVariableArray2[n2];
                if (Arrays.asList(termVariableArray).contains(termVariable)) {
                    set = PositionAwareSubstitution.addToSet(termVariable, set);
                }
                ++n2;
            }
        }
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    private static Set<TermVariable> addToSet(TermVariable termVariable, Set<TermVariable> set) {
        if (set == null) {
            set = new HashSet<TermVariable>();
        }
        set.add(termVariable);
        return set;
    }

    @Override
    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        throw new UnsupportedOperationException("quantified formulas are not yet supported by this class");
    }

    public String toString() {
        return "Substitution " + this.mScopedPositionSubstitutionMapping.toString();
    }

    public List<Term> transform(List<Term> list) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Term term : list) {
            arrayList.add(this.transform(term));
        }
        return arrayList;
    }
}

