/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.FunctionDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryPointer1D;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.IPointerIntegerConversion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;

public class OverapproximationUF1D
implements IPointerIntegerConversion {
    protected final ExpressionTranslation mExpressionTranslation;
    private final FunctionDeclarations mFunctionDeclarations;
    private final ITypeHandler mTypeHandler;
    private final MemoryPointer1D mMemoryPointer;

    public OverapproximationUF1D(ExpressionTranslation expressionTranslation, FunctionDeclarations functionDeclarations, ITypeHandler iTypeHandler, MemoryPointer1D memoryPointer1D) {
        this.mExpressionTranslation = expressionTranslation;
        this.mFunctionDeclarations = functionDeclarations;
        this.mTypeHandler = iTypeHandler;
        this.mMemoryPointer = memoryPointer1D;
    }

    @Override
    public ExpressionResult convertPointerToInt(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        if (cPrimitive.getType() == CPrimitive.CPrimitives.BOOL) {
            return this.mExpressionTranslation.convertToBool(iLocation, expressionResult);
        }
        String string = this.declareConvertPointerToIntFunction(iLocation, cPrimitive);
        Expression expression = expressionResult.getLrValue().getValue();
        Expression expression2 = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{expression}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        RValue rValue = new RValue(expression2, cPrimitive, false, false);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    @Override
    public ExpressionResult convertIntToPointer(ILocation iLocation, ExpressionResult expressionResult, CPointer cPointer) {
        ExpressionResult expressionResult2 = this.mExpressionTranslation.convertIntToInt(iLocation, expressionResult, this.mExpressionTranslation.getCTypeOfPointerComponents());
        RValue rValue = new RValue(this.mMemoryPointer.createPointerFromBase(expressionResult2.getLrValue().getValue(), iLocation), cPointer, false, false);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult2).setLrValue(rValue).build();
    }

    private String declareConvertIntToPointerFunction(ILocation iLocation, CPrimitive cPrimitive) {
        String string = "convert" + cPrimitive.toString() + "toPointer";
        String string2 = "~" + string;
        if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string2)) {
            NamedAttribute namedAttribute = new NamedAttribute(iLocation, "overapproximation", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
            Attribute[] attributeArray = new Attribute[]{namedAttribute};
            ASTType aSTType = this.mTypeHandler.constructPointerType(iLocation);
            ASTType aSTType2 = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
            this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, aSTType, aSTType2);
        }
        return string2;
    }

    private String declareConvertPointerToIntFunction(ILocation iLocation, CPrimitive cPrimitive) {
        String string = "convertPointerTo" + cPrimitive.toString();
        String string2 = "~" + string;
        if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string2)) {
            NamedAttribute namedAttribute = new NamedAttribute(iLocation, "overapproximation", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
            Attribute[] attributeArray = new Attribute[]{namedAttribute};
            ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
            ASTType aSTType2 = this.mTypeHandler.constructPointerType(iLocation);
            this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, aSTType, aSTType2);
        }
        return string2;
    }
}

