/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ModuloNeighborTransformation
extends TransitionPreprocessor {
    public static final String DESCRIPTION = "Replace modulo operation by disjunction if divisor is a literal";
    private static final boolean CHECK_RESULT = true;
    private static final String MODULO_REPLACEMENT = "mod2";
    private final IUltimateServiceProvider mServices;
    private static final boolean APPLY_ONLY_TO_TYPICAL_WRAPAROUD_CONSTANTS = true;
    private static final BigInteger BITLENGTH8_VALUE = BigInteger.valueOf(256L);
    private static final BigInteger BITLENGTH16_VALUE = BigInteger.valueOf(65536L);
    private static final BigInteger BITLENGTH32_VALUE = BigInteger.valueOf(0x100000000L);
    private static final BigInteger BITLENGTH64_VALUE = new BigInteger("9223372036854775808");
    private static final BigInteger BITLENGTH128_VALUE = new BigInteger("340282366920938463463374607431768211456");

    public ModuloNeighborTransformation(IUltimateServiceProvider iUltimateServiceProvider, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        if (!bl) {
            throw new UnsupportedOperationException("not yet implemented");
        }
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula) throws TermException {
        Term term = this.constructTerm(managedScript, modifiableTransFormula.getFormula());
        ModifiableTransFormula modifiableTransFormula2 = new ModifiableTransFormula(modifiableTransFormula);
        modifiableTransFormula2.setFormula(term);
        return modifiableTransFormula2;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2) {
        return !this.isIncorrect(script, modifiableTransFormula.getFormula(), modifiableTransFormula2.getFormula());
    }

    private boolean isIncorrect(Script script, Term term, Term term2) {
        return Script.LBool.SAT == Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, term2}));
    }

    private Term constructInRangeBounds(Script script, Term term, Term term2) {
        Term term3 = script.term("<=", new Term[]{SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO), term});
        Term term4 = script.term("<", new Term[]{term, term2});
        return script.term("and", new Term[]{term3, term4});
    }

    private Term constructInRangeResult(Term term) {
        return term;
    }

    private Term constructLeftIntervalBounds(Script script, Term term, Term term2) {
        Term term3 = script.term("<=", new Term[]{script.term("-", new Term[]{term2}), term});
        Term term4 = script.term("<", new Term[]{term, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
        return script.term("and", new Term[]{term3, term4});
    }

    private Term constructLeftIntervalResult(Script script, Term term, Term term2) {
        return script.term("+", new Term[]{term, term2});
    }

    private Term constructRightIntervalBounds(Script script, Term term, Term term2) {
        Term term3 = script.term("<=", new Term[]{term2, term});
        Term term4 = script.term("<", new Term[]{term, script.term("+", new Term[]{term2, term2})});
        return script.term("and", new Term[]{term3, term4});
    }

    private Term constructRightIntervalResult(Script script, Term term, Term term2) {
        return script.term("-", new Term[]{term, term2});
    }

    private Term constructNoNeighborIntervalBounds(Script script, Term term, Term term2) {
        Term term3 = script.term("<", new Term[]{term, script.term("-", new Term[]{term2})});
        Term term4 = script.term("<=", new Term[]{script.term("+", new Term[]{term2, term2}), term});
        return script.term("or", new Term[]{term3, term4});
    }

    private Term constructNoNeighborIntervalResult(Script script, Term term, Term term2) {
        return script.term(MODULO_REPLACEMENT, new Term[]{term, term2});
    }

    private Term constructTerm(ManagedScript managedScript, Term term) {
        Map<ApplicationTerm, ApplicationTerm> map;
        ApplicationTerm applicationTerm3;
        Term term2;
        Term term3;
        ApplicationTerm applicationTerm2;
        Set set;
        managedScript.lock((Object)this);
        managedScript.push((Object)this, 1);
        Sort sort = SmtSortUtils.getIntSort((ManagedScript)managedScript);
        managedScript.declareFun((Object)this, MODULO_REPLACEMENT, new Sort[]{sort, sort}, sort);
        while (!(set = SmtUtils.extractApplicationTerms((String)"mod", (Term)term, (boolean)false)).isEmpty()) {
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(this.getClass(), "removing " + set.size() + " modulo operations from term of size " + new DagSizePrinter(term).toString());
            }
            applicationTerm2 = null;
            term3 = null;
            term2 = null;
            for (ApplicationTerm applicationTerm3 : set) {
                assert (applicationTerm3.getParameters().length == 2);
                term3 = applicationTerm3.getParameters()[0];
                term2 = applicationTerm3.getParameters()[1];
                if (term2 instanceof ConstantTerm && this.isWraparoundConstant((ConstantTerm)term2)) {
                    applicationTerm2 = applicationTerm3;
                    break;
                }
                term3 = null;
                term2 = null;
            }
            if (applicationTerm2 == null) break;
            applicationTerm3 = managedScript.getScript();
            map = new ArrayList();
            Map<ApplicationTerm, Term> map2 = Collections.singletonMap(applicationTerm2, this.constructInRangeResult(term3));
            Term term4 = SmtUtils.and((Script)applicationTerm3, (Term[])new Term[]{this.constructInRangeBounds((Script)applicationTerm3, term3, term2), Substitution.apply((ManagedScript)managedScript, map2, (Term)term)});
            map.add(term4);
            map2 = Collections.singletonMap(applicationTerm2, this.constructLeftIntervalResult((Script)applicationTerm3, term3, term2));
            term4 = SmtUtils.and((Script)applicationTerm3, (Term[])new Term[]{this.constructLeftIntervalBounds((Script)applicationTerm3, term3, term2), Substitution.apply((ManagedScript)managedScript, map2, (Term)term)});
            map.add(term4);
            map2 = Collections.singletonMap(applicationTerm2, this.constructRightIntervalResult((Script)applicationTerm3, term3, term2));
            term4 = SmtUtils.and((Script)applicationTerm3, (Term[])new Term[]{this.constructRightIntervalBounds((Script)applicationTerm3, term3, term2), Substitution.apply((ManagedScript)managedScript, map2, (Term)term)});
            map.add(term4);
            map2 = Collections.singletonMap(applicationTerm2, this.constructNoNeighborIntervalResult((Script)applicationTerm3, term3, term2));
            term4 = SmtUtils.and((Script)applicationTerm3, (Term[])new Term[]{this.constructNoNeighborIntervalBounds((Script)applicationTerm3, term3, term2), Substitution.apply((ManagedScript)managedScript, map2, (Term)term)});
            map.add(term4);
            term = SmtUtils.or((Script)applicationTerm3, map);
        }
        term = SmtUtils.simplify((ManagedScript)managedScript, (Term)term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        while (!(set = SmtUtils.extractApplicationTerms((String)MODULO_REPLACEMENT, (Term)term, (boolean)false)).isEmpty()) {
            applicationTerm2 = (ApplicationTerm)set.iterator().next();
            assert (applicationTerm2.getFunction().getName().equals(MODULO_REPLACEMENT)) : "wrong function";
            assert (applicationTerm2.getParameters().length == 2);
            term3 = applicationTerm2.getParameters()[0];
            term2 = applicationTerm2.getParameters()[1];
            applicationTerm3 = managedScript.getScript().term("mod", new Term[]{term3, term2});
            map = Collections.singletonMap(applicationTerm2, applicationTerm3);
            term = Substitution.apply((ManagedScript)managedScript, map, (Term)term);
        }
        managedScript.pop((Object)this, 1);
        managedScript.unlock((Object)this);
        return term;
    }

    private boolean isWraparoundConstant(ConstantTerm constantTerm) {
        Object object = constantTerm.getValue();
        if (object instanceof Rational) {
            return this.isWraparoudBigInteger(((Rational)object).numerator());
        }
        if (object instanceof BigInteger) {
            return this.isWraparoudBigInteger((BigInteger)object);
        }
        throw new UnsupportedOperationException("value has type " + object.getClass().getSimpleName());
    }

    private boolean isWraparoudBigInteger(BigInteger bigInteger) {
        return bigInteger.equals(BITLENGTH8_VALUE) || bigInteger.equals(BITLENGTH16_VALUE) || bigInteger.equals(BITLENGTH32_VALUE) || bigInteger.equals(BITLENGTH64_VALUE) || bigInteger.equals(BITLENGTH128_VALUE);
    }
}

