/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class SkolemNormalForm {
    private Term mResult;
    private final ManagedScript mMgdScript;
    private final HashRelation3<String, Sort[], Sort> mSkolemFunctions;

    public SkolemNormalForm(ManagedScript managedScript, Term term) {
        this.mMgdScript = managedScript;
        this.mSkolemFunctions = new HashRelation3();
        assert (new PrenexNormalForm(managedScript).transform(term) == term) : "input formula must be in prenex normal form";
        if (!(term instanceof QuantifiedFormula)) {
            this.mResult = term;
        } else {
            this.skolemize((QuantifiedFormula)term);
        }
    }

    private void skolemize(QuantifiedFormula quantifiedFormula) {
        QuantifierSequence.QuantifiedVariables quantifiedVariables3;
        this.mMgdScript.lock(this);
        QuantifierSequence quantifierSequence = new QuantifierSequence(this.mMgdScript, (Term)quantifiedFormula);
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        QuantifierSequence.QuantifiedVariables quantifiedVariables2 = new QuantifierSequence.QuantifiedVariables(1, Collections.emptySet());
        for (QuantifierSequence.QuantifiedVariables quantifiedVariables3 : quantifierSequence.getQuantifierBlocks()) {
            if (quantifiedVariables3.getQuantifier() == 1) {
                quantifiedVariables2 = new QuantifierSequence.QuantifiedVariables(1, DataStructureUtils.union(quantifiedVariables3.getVariables(), quantifiedVariables2.getVariables()));
                continue;
            }
            ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>(quantifiedVariables2.getVariables());
            Term[] termArray = arrayList.toArray(new Term[arrayList.size()]);
            List<Sort> list = arrayList.stream().map(termVariable -> termVariable.getSort()).collect(Collectors.toList());
            Sort[] sortArray = list.toArray(new Sort[list.size()]);
            for (TermVariable termVariable2 : quantifiedVariables3.getVariables()) {
                Sort sort = termVariable2.getSort();
                String string = this.getFreshFunctionSymbol(sortArray, sort);
                this.mMgdScript.declareFun(this, string, sortArray, sort);
                Term term = this.mMgdScript.term((Object)this, string, termArray);
                hashMap.put(termVariable2, term);
            }
        }
        quantifiedVariables3 = Substitution.apply(this.mMgdScript, hashMap, quantifierSequence.getInnerTerm());
        if (quantifiedVariables2.getVariables().isEmpty()) {
            this.mResult = quantifiedVariables3;
        } else {
            try {
                this.mResult = QuantifierSequence.prependQuantifierSequence(this.mMgdScript.getScript(), Collections.singletonList(quantifiedVariables2), (Term)quantifiedVariables3);
            }
            catch (Exception exception) {
                throw new AssertionError();
            }
        }
        this.mMgdScript.unlock(this);
    }

    String getFreshFunctionSymbol(Sort[] sortArray, Sort sort) {
        String string = this.mMgdScript.constructFreshSkolemFunctionName(sortArray, sort);
        this.mSkolemFunctions.addTriple((Object)string, (Object)sortArray, (Object)sort);
        return string;
    }

    public Term getSkolemizedFormula() {
        return this.mResult;
    }

    public HashRelation3<String, Sort[], Sort> getSkolemFunctions() {
        return this.mSkolemFunctions;
    }
}

