/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.CachedIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultIndependenceCache<S, L>
implements CachedIndependenceRelation.IIndependenceCache<S, L> {
    private final Map<S, HashRelation<L, L>> mIndependentCache = new HashMap<S, HashRelation<L, L>>();
    private final Map<S, HashRelation<L, L>> mDependentCache = new HashMap<S, HashRelation<L, L>>();
    private final Map<S, HashRelation<L, L>> mUnknownCache = new HashMap<S, HashRelation<L, L>>();

    @Override
    public IIndependenceRelation.Dependence contains(S s, L l, L l2) {
        HashRelation<L, L> hashRelation;
        if (s != null && (hashRelation = this.mIndependentCache.get(null)) != null && hashRelation.containsPair(l, l2)) {
            return IIndependenceRelation.Dependence.INDEPENDENT;
        }
        hashRelation = this.mIndependentCache.get(s);
        if (hashRelation != null && hashRelation.containsPair(l, l2)) {
            return IIndependenceRelation.Dependence.INDEPENDENT;
        }
        HashRelation<L, L> hashRelation2 = this.mDependentCache.get(s);
        if (hashRelation2 != null && hashRelation2.containsPair(l, l2)) {
            return IIndependenceRelation.Dependence.DEPENDENT;
        }
        HashRelation<L, L> hashRelation3 = this.mUnknownCache.get(s);
        if (hashRelation3 != null && hashRelation3.containsPair(l, l2)) {
            return IIndependenceRelation.Dependence.UNKNOWN;
        }
        return null;
    }

    @Override
    public void remove(L l) {
        this.removeFromCache(this.mIndependentCache, l);
        this.removeFromCache(this.mDependentCache, l);
        this.removeFromCache(this.mUnknownCache, l);
    }

    private void removeFromCache(Map<?, HashRelation<L, L>> map, L l) {
        Iterator<HashRelation<L, L>> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            HashRelation<L, L> hashRelation = iterator.next();
            hashRelation.removeDomainElement(l);
            hashRelation.removeRangeElement(l);
            if (!hashRelation.isEmpty()) continue;
            iterator.remove();
        }
    }

    public void clearConditional() {
        this.clearConditional(this.mIndependentCache);
        this.clearConditional(this.mDependentCache);
        this.clearConditional(this.mUnknownCache);
    }

    private void clearConditional(Map<S, HashRelation<L, L>> map) {
        HashRelation<L, L> hashRelation = map.get(null);
        map.clear();
        if (hashRelation != null) {
            map.put(null, hashRelation);
        }
    }

    @Override
    public void cacheResult(S s, L l, L l2, IIndependenceRelation.Dependence dependence) {
        Map<S, HashRelation<L, L>> map = this.getCache(dependence);
        HashRelation hashRelation = map.computeIfAbsent(s, object -> new HashRelation());
        hashRelation.addPair(l, l2);
    }

    private Map<S, HashRelation<L, L>> getCache(IIndependenceRelation.Dependence dependence) {
        switch (dependence) {
            case DEPENDENT: {
                return this.mDependentCache;
            }
            case INDEPENDENT: {
                return this.mIndependentCache;
            }
            case UNKNOWN: {
                return this.mUnknownCache;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void mergeIndependencies(L l, L l2, L l3) {
        for (HashRelation<L, L> hashRelation : this.mIndependentCache.values()) {
            for (Object e : hashRelation.getImage(l)) {
                if (!hashRelation.containsPair(l2, e)) continue;
                hashRelation.addPair(l3, e);
            }
            for (Object e : hashRelation.getDomain()) {
                if (!hashRelation.containsPair(e, l) || !hashRelation.containsPair(e, l2)) continue;
                hashRelation.addPair(e, l3);
            }
        }
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return new CacheStatistics();
    }

    private final class CacheStatistics
    extends AbstractStatisticsDataProvider {
        public static final String TOTAL_CACHE_SIZE = "Total cache size (in pairs)";

        private CacheStatistics() {
            this.declareCounter(TOTAL_CACHE_SIZE, this::getTotalSize);
            this.declareCacheStatistics("Positive", DefaultIndependenceCache.this.mIndependentCache);
            this.declareCacheStatistics("Negative", DefaultIndependenceCache.this.mDependentCache);
            this.declareCacheStatistics("Unknown", DefaultIndependenceCache.this.mUnknownCache);
        }

        private void declareCacheStatistics(String string, Map<S, HashRelation<L, L>> map) {
            this.declareCounter(string + " cache size", () -> this.getCacheSize(map));
            this.declareCounter(string + " conditional cache size", () -> this.getConditionalCacheSize(map));
            this.declareCounter(string + " unconditional cache size", () -> this.getUnconditionalCacheSize(map));
        }

        private int getTotalSize() {
            return this.getCacheSize(DefaultIndependenceCache.this.mIndependentCache) + this.getCacheSize(DefaultIndependenceCache.this.mDependentCache) + this.getCacheSize(DefaultIndependenceCache.this.mUnknownCache);
        }

        private int getCacheSize(Map<S, HashRelation<L, L>> map) {
            return map.entrySet().stream().collect(Collectors.summingInt(entry -> ((HashRelation)entry.getValue()).size()));
        }

        private int getUnconditionalCacheSize(Map<S, HashRelation<L, L>> map) {
            HashRelation hashRelation = map.get(null);
            if (hashRelation == null) {
                return 0;
            }
            return hashRelation.size();
        }

        private int getConditionalCacheSize(Map<S, HashRelation<L, L>> map) {
            return this.getCacheSize(map) - this.getUnconditionalCacheSize(map);
        }
    }
}

