/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser.graph;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.witnessparser.Activator;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;

public class WitnessGraphAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private static final String KEY = Activator.PLUGIN_ID + "_Graph";
    @Visualizable
    private final String mSourceCodeLanguage;
    @Visualizable
    private final WitnessType mType;

    public WitnessGraphAnnotation(String string, WitnessType witnessType) {
        this.mSourceCodeLanguage = string;
        this.mType = witnessType;
    }

    public void annotate(IElement iElement) {
        if (iElement instanceof WitnessNode) {
            this.annotate((WitnessNode)iElement);
        }
    }

    public void annotate(WitnessNode witnessNode) {
        witnessNode.getPayload().getAnnotations().put(KEY, this);
    }

    public static WitnessGraphAnnotation getAnnotation(IElement iElement) {
        return (WitnessGraphAnnotation)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, iAnnotations -> (WitnessGraphAnnotation)((Object)iAnnotations));
    }

    public String getSourceCodeLanguage() {
        return this.mSourceCodeLanguage;
    }

    public WitnessType getWitnessType() {
        return this.mType;
    }

    public static enum WitnessType {
        CORRECTNESS_WITNESS,
        VIOLATION_WITNESS;

    }
}

