/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IBuchi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IStateWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntIterator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public interface IBuchiWa
extends IBuchi<IStateWa> {
    default public IntSet getSuccessors(IntSet intSet, int n) {
        IntSet intSet2 = UtilIntSet.newIntSet();
        for (int n2 : intSet.iterable()) {
            intSet2.or(this.getSuccessors(n2, n));
        }
        return intSet2;
    }

    public IntSet getSuccessors(int var1, int var2);

    @Override
    public void makeComplete();

    default public void toBA(PrintStream printStream, List<String> list) {
        IntSet intSet = this.getInitialStates();
        if (intSet.cardinality() > 1) {
            throw new RuntimeException("BA format does not allow multiple initial states...");
        }
        IntIterator intIterator = intSet.iterator();
        printStream.print("[" + intIterator.next() + "]\n");
        Collection collection = this.getStates();
        for (IStateWa iStateWa : collection) {
            iStateWa.toBA(printStream, list);
        }
        Iterator<Object> iterator = this.getFinalStates().iterable().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            printStream.print("[" + n + "]\n");
        }
    }

    default public String toBA() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < this.getAlphabetSize()) {
                arrayList.add("" + n);
                ++n;
            }
            this.toBA(new PrintStream(byteArrayOutputStream), arrayList);
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return "ERROR";
        }
    }

    @Override
    default public int getTransitionSize() {
        int n = 0;
        for (IStateWa iStateWa : this.getStates()) {
            for (Integer n2 : iStateWa.getEnabledLetters()) {
                n += iStateWa.getSuccessors(n2).cardinality();
            }
        }
        return n;
    }

    @Override
    default public void toATS(PrintStream printStream, List<String> list) {
        printStream.println("FiniteAutomaton result = (");
        printStream.print("   alphabet = {");
        int n = 0;
        while (n < this.getAlphabetSize()) {
            printStream.print(list.get(n) + " ");
            ++n;
        }
        printStream.println("},");
        Collection collection = this.getStates();
        printStream.print("   states = {");
        for (IStateWa object : collection) {
            printStream.print("s" + object.getId() + " ");
        }
        printStream.println("},");
        printStream.print("   initialStates = {");
        for (Integer n2 : this.getInitialStates().iterable()) {
            printStream.print("s" + String.valueOf(n2) + " ");
        }
        printStream.println("},");
        printStream.print("   finalStates = {");
        for (Integer n3 : this.getFinalStates().iterable()) {
            printStream.print("s" + String.valueOf(n3) + " ");
        }
        printStream.println("},");
        printStream.print("   transitions = {");
        for (IStateWa iStateWa : collection) {
            for (Integer n4 : iStateWa.getEnabledLetters()) {
                for (Integer n5 : iStateWa.getSuccessors(n4).iterable()) {
                    printStream.print("\n      (s" + iStateWa.getId() + " " + list.get(n4) + " s" + String.valueOf(n5) + ")");
                }
            }
        }
        printStream.println("\n   }");
        printStream.println(");");
    }

    @Override
    default public boolean isSemiDeterministic() {
        IntSet intSet = this.getFinalStates();
        LinkedList<IStateWa> linkedList = new LinkedList<IStateWa>();
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            linkedList.addFirst((IStateWa)this.getState(intIterator.next()));
        }
        IntSet intSet2 = UtilIntSet.newIntSet();
        while (!linkedList.isEmpty()) {
            IStateWa iStateWa = (IStateWa)linkedList.remove();
            if (intSet2.get(iStateWa.getId())) continue;
            intSet2.set(iStateWa.getId());
            int n = 0;
            while (n < this.getAlphabetSize()) {
                IntSet intSet3 = iStateWa.getSuccessors(n);
                if (!intSet3.isEmpty()) {
                    if (intSet3.cardinality() > 1) {
                        return false;
                    }
                    intIterator = intSet3.iterator();
                    int n2 = intIterator.next();
                    if (!intSet2.get(n2)) {
                        linkedList.addFirst((IStateWa)this.getState(n2));
                    }
                }
                ++n;
            }
        }
        return true;
    }

    @Override
    default public boolean isDeterministic(int n) {
        LinkedList<IStateWa> linkedList = new LinkedList<IStateWa>();
        linkedList.addFirst((IStateWa)this.getState(n));
        IntSet intSet = UtilIntSet.newIntSet();
        while (!linkedList.isEmpty()) {
            IStateWa iStateWa = (IStateWa)linkedList.remove();
            if (intSet.get(iStateWa.getId())) continue;
            intSet.set(iStateWa.getId());
            int n2 = 0;
            while (n2 < this.getAlphabetSize()) {
                IntIterator intIterator;
                int n3;
                IntSet intSet2 = iStateWa.getSuccessors(n2);
                if (intSet2.cardinality() > 1) {
                    return false;
                }
                if (!intSet2.isEmpty() && !intSet.get(n3 = (intIterator = intSet2.iterator()).next())) {
                    linkedList.addFirst((IStateWa)this.getState(n3));
                }
                ++n2;
            }
        }
        return true;
    }
}

