/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class UnaryExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(UnaryExpression.class);
    Operator operator;
    Expression expr;

    public UnaryExpression(Operator operator, Expression expression) {
        this.operator = operator;
        this.expr = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid UnaryExpression: " + String.valueOf(this);
    }

    public UnaryExpression(ACSLType aCSLType, Operator operator, Expression expression) {
        super(aCSLType);
        this.operator = operator;
        this.expr = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid UnaryExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UnaryExpression").append('[');
        stringBuffer.append((Object)this.operator);
        stringBuffer.append(',').append(this.expr);
        return stringBuffer.append(']').toString();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getExpr() {
        return this.expr;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.expr);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.expr != null) {
                this.expr.accept(aCSLVisitor);
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.expr != null) {
            expression2 = this.expr.accept(aCSLTransformer);
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.expr != expression2 || this.type != aCSLType) {
            return new UnaryExpression(aCSLType, this.operator, expression2);
        }
        return this;
    }

    public static enum Operator {
        LOGICNEG,
        PLUS,
        MINUS,
        LOGICCOMPLEMENT,
        POINTER,
        ADDROF,
        LTLGLOBALLY,
        LTLFINALLY,
        LTLNEXT;

    }
}

