/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationSettings;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import java.util.function.Consumer;

public interface ILassoRankerPreferences {
    public boolean isComputeIntegralHull();

    public boolean isEnablePartitioneer();

    public boolean isAnnotateTerms();

    public boolean isExternalSolver();

    public String getExternalSolverCommand();

    public boolean isDumpSmtSolverScript();

    public String getPathOfDumpedScript();

    public String getBaseNameOfDumpedScript();

    public boolean isOverapproximateArrayIndexConnection();

    public InequalityConverter.NlaHandling getNlaHandling();

    public boolean isUseOldMapElimination();

    public boolean isMapElimAddInequalities();

    public boolean isMapElimOnlyTrivialImplicationsIndexAssignment();

    public boolean isMapElimOnlyTrivialImplicationsArrayWrite();

    public boolean isMapElimOnlyIndicesInFormula();

    public boolean isFakeNonIncrementalScript();

    default public void feedSettingsString(Consumer<String> consumer) {
        consumer.accept("Compute integeral hull: " + this.isComputeIntegralHull());
        consumer.accept("Enable LassoPartitioneer: " + this.isEnablePartitioneer());
        consumer.accept("Term annotations enabled: " + this.isAnnotateTerms());
        consumer.accept("Use exernal solver: " + this.isExternalSolver());
        consumer.accept("SMT solver command: " + this.getExternalSolverCommand());
        consumer.accept("Dump SMT script to file: " + this.isDumpSmtSolverScript());
        consumer.accept("Path of dumped script: " + this.getPathOfDumpedScript());
        consumer.accept("Filename of dumped script: " + this.getBaseNameOfDumpedScript());
        consumer.accept("MapElimAlgo: " + (this.isUseOldMapElimination() ? "Matthias" : "Frank"));
    }

    default public SolverBuilder.SolverSettings getSolverConstructionSettings(SolverBuilder.SolverMode solverMode, String string) {
        return SolverBuilder.constructSolverSettings().setUseFakeIncrementalScript(this.isFakeNonIncrementalScript()).setUseExternalSolver(true, this.getExternalSolverCommand(), null).setSolverMode(solverMode).setDumpSmtScriptToFile(this.isDumpSmtSolverScript(), this.getPathOfDumpedScript(), this.getBaseNameOfDumpedScript(), false).setSmtInterpolTimeout(31536000000L);
    }

    default public MapEliminationSettings getMapEliminationSettings(SmtUtils.SimplificationTechnique simplificationTechnique) {
        return new MapEliminationSettings(this.isMapElimAddInequalities(), this.isMapElimOnlyTrivialImplicationsIndexAssignment(), this.isMapElimOnlyTrivialImplicationsArrayWrite(), this.isMapElimOnlyIndicesInFormula(), simplificationTechnique);
    }
}

