/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class BooleanLiteral
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(BooleanLiteral.class);
    boolean value;

    public BooleanLiteral(boolean bl) {
        this.value = bl;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BooleanLiteral: " + String.valueOf(this);
    }

    public BooleanLiteral(ACSLType aCSLType, boolean bl) {
        super(aCSLType);
        this.value = bl;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BooleanLiteral: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BooleanLiteral").append('[');
        stringBuffer.append(this.value);
        return stringBuffer.append(']').toString();
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.type != null) {
            this.type.accept(aCSLVisitor);
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.type != aCSLType) {
            return new BooleanLiteral(aCSLType, this.value);
        }
        return this;
    }
}

