/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.predicates.IterativePredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.DefaultTransFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.IErrorAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.InclusionInPreChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.NondeterministicErrorAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.PredicateUnificationMechanism;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.StraightLineInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.NondeterministicInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ErrorAutomatonBuilder<L extends IIcfgTransition<?>>
implements IErrorAutomatonBuilder<L> {
    private static final boolean USE_TRUE_AS_CALL_PREDECESSOR_FOR_WP = true;
    private static final boolean UNIFY_PREDICATES = true;
    private static final boolean APPLY_FORMULA_POSTPROCESSOR = true;
    private static final boolean INTERSECT_WITH_SP_PREDICATES = false;
    private static final boolean USE_ENHANCEMENT = false;
    private final NestedWordAutomaton<L, IPredicate> mResultBeforeEnhancement;
    private final NondeterministicInterpolantAutomaton<L> mResultAfterEnhancement;
    private IPredicate mErrorPrecondition;

    public ErrorAutomatonBuilder(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, NestedWord<L> nestedWord) {
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        PredicateUnificationMechanism predicateUnificationMechanism = new PredicateUnificationMechanism(iPredicateUnifier, true);
        this.mResultBeforeEnhancement = this.constructStraightLineAutomaton(iUltimateServiceProvider, iLogger, cfgSmtToolkit, predicateFactory, predicateUnificationMechanism, simplificationTechnique, iIcfgSymbolTable, predicateFactoryForInterpolantAutomata, NestedWordAutomataUtils.getVpAlphabet(iNestedWordAutomaton), nestedWord);
        this.mResultAfterEnhancement = null;
    }

    @Override
    public IErrorAutomatonBuilder.ErrorAutomatonType getType() {
        return IErrorAutomatonBuilder.ErrorAutomatonType.ERROR_AUTOMATON;
    }

    @Override
    public NestedWordAutomaton<L, IPredicate> getResultBeforeEnhancement() {
        return this.mResultBeforeEnhancement;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<L, IPredicate> getResultAfterEnhancement() {
        return this.mResultAfterEnhancement == null ? this.mResultBeforeEnhancement : this.mResultAfterEnhancement;
    }

    @Override
    public IPredicate getErrorPrecondition() {
        assert (this.mErrorPrecondition != null) : "Precondition was not computed yet.";
        return this.mErrorPrecondition;
    }

    @Override
    public TAPreferences.InterpolantAutomatonEnhancement getEnhancementMode() {
        return TAPreferences.InterpolantAutomatonEnhancement.NONE;
    }

    private NestedWordAutomaton<L, IPredicate> constructStraightLineAutomaton(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, PredicateUnificationMechanism predicateUnificationMechanism, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, VpAlphabet<L> vpAlphabet, NestedWord<L> nestedWord) throws AssertionError {
        IPredicate iPredicate5;
        IPredicate iPredicate22;
        IPredicate iPredicate3 = predicateUnificationMechanism.getFalsePredicate();
        IPredicate iPredicate4 = predicateUnificationMechanism.getTruePredicate();
        IterativePredicateTransformer.QuantifierEliminationPostprocessor quantifierEliminationPostprocessor = new IterativePredicateTransformer.QuantifierEliminationPostprocessor(iUltimateServiceProvider, cfgSmtToolkit.getManagedScript(), (BasicPredicateFactory)predicateFactory, simplificationTechnique);
        List<IterativePredicateTransformer.QuantifierEliminationPostprocessor> list = Collections.singletonList(quantifierEliminationPostprocessor);
        quantifierEliminationPostprocessor = this.getPredicates(iUltimateServiceProvider, cfgSmtToolkit, predicateFactory, simplificationTechnique, iIcfgSymbolTable, iPredicate4, nestedWord, null, iPredicate3, list, PredicateTransformerType.WP);
        List list2 = quantifierEliminationPostprocessor.getPredicates();
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>(list2.size());
        for (IPredicate iPredicate22 : list2) {
            arrayList.add(predicateFactory.not(iPredicate22));
        }
        iPredicate22 = predicateFactory.not(quantifierEliminationPostprocessor.getPrecondition());
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (IPredicate iPredicate5 : arrayList) {
            arrayList2.add(predicateUnificationMechanism.getOrConstructPredicate(iPredicate5));
        }
        IPredicate iPredicate6 = iPredicate4;
        this.mErrorPrecondition = predicateUnificationMechanism.getOrConstructPredicate(iPredicate22);
        iPredicate5 = new TracePredicates(this.mErrorPrecondition, predicateUnificationMechanism.getOrConstructPredicate(iPredicate6), (List)arrayList2);
        return new StraightLineInterpolantAutomatonBuilder<L>(iUltimateServiceProvider, nestedWord, vpAlphabet, (List<TracePredicates>)Collections.singletonList(iPredicate5), (IEmptyStackStateFactory<IPredicate>)predicateFactoryForInterpolantAutomata, StraightLineInterpolantAutomatonBuilder.InitialAndAcceptingStateMode.ALL_INITIAL_ALL_ACCEPTING).getResult();
    }

    private TracePredicates getPredicates(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, IPredicate iPredicate, NestedWord<L> nestedWord, IPredicate iPredicate2, IPredicate iPredicate3, List<IterativePredicateTransformer.IPredicatePostprocessor> list, PredicateTransformerType predicateTransformerType) throws AssertionError {
        TracePredicates tracePredicates;
        DefaultTransFormulas defaultTransFormulas = new DefaultTransFormulas(nestedWord, iPredicate2, iPredicate3, Collections.emptySortedMap(), cfgSmtToolkit.getOldVarsAssignmentCache(), false);
        IterativePredicateTransformer iterativePredicateTransformer = new IterativePredicateTransformer((BasicPredicateFactory)predicateFactory, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getModifiableGlobalsTable(), iUltimateServiceProvider, nestedWord, iPredicate2, iPredicate3, null, iPredicate, simplificationTechnique, iIcfgSymbolTable);
        try {
            switch (predicateTransformerType) {
                case WP: {
                    tracePredicates = iterativePredicateTransformer.computeWeakestPreconditionSequence((NestedFormulas)defaultTransFormulas, list, true, false);
                    break;
                }
                case SP: {
                    tracePredicates = iterativePredicateTransformer.computeStrongestPostconditionSequence((NestedFormulas)defaultTransFormulas, list);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown predicate transformer: " + String.valueOf((Object)predicateTransformerType));
                }
            }
        }
        catch (IterativePredicateTransformer.TraceInterpolationException traceInterpolationException) {
            throw new AssertionError();
        }
        return tracePredicates;
    }

    private NondeterministicInterpolantAutomaton<L> constructNondeterministicAutomaton(IUltimateServiceProvider iUltimateServiceProvider, NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, CfgSmtToolkit cfgSmtToolkit, PredicateUnificationMechanism predicateUnificationMechanism, PredicateFactory predicateFactory) {
        assert (!this.containsPredicateState(nestedWordAutomaton, predicateUnificationMechanism.getFalsePredicate())) : "The error trace is feasible; hence the predicate 'False' should not exist.";
        if (!this.containsPredicateState(nestedWordAutomaton, predicateUnificationMechanism.getTruePredicate())) {
            nestedWordAutomaton.addState(true, true, (Object)predicateUnificationMechanism.getTruePredicate());
        }
        ManagedScript managedScript = cfgSmtToolkit.getManagedScript();
        MonolithicImplicationChecker monolithicImplicationChecker = new MonolithicImplicationChecker(iUltimateServiceProvider, managedScript);
        PredicateTransformer predicateTransformer = new PredicateTransformer(managedScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(iUltimateServiceProvider, managedScript));
        InclusionInPreChecker inclusionInPreChecker = new InclusionInPreChecker(iUltimateServiceProvider, null, monolithicImplicationChecker, (PredicateTransformer<Term, IPredicate, TransFormula>)predicateTransformer, predicateFactory, cfgSmtToolkit);
        return new NondeterministicErrorAutomaton<L>(iUltimateServiceProvider, cfgSmtToolkit, inclusionInPreChecker, nestedWordAutomaton, predicateUnificationMechanism.getPredicateUnifier());
    }

    private boolean containsPredicateState(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, IPredicate iPredicate) {
        for (IPredicate iPredicate2 : nestedWordAutomaton.getStates()) {
            if (iPredicate2 != iPredicate) continue;
            return true;
        }
        return false;
    }

    private static enum PredicateTransformerType {
        WP,
        SP;

    }
}

