/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.math.BigInteger;

public class LongOption
extends Option {
    private long mValue;
    private long mDefaultValue;

    public LongOption(long l, boolean bl, String string) {
        super(bl, string);
        this.mValue = this.mDefaultValue = l;
    }

    LongOption(LongOption longOption) {
        super(longOption.isOnlineModifiable(), longOption.getDescription());
        this.mValue = longOption.mValue;
        this.mDefaultValue = longOption.mDefaultValue;
    }

    @Override
    public Option copy() {
        return new LongOption(this);
    }

    @Override
    public void set(Object object) {
        if (object instanceof Number) {
            this.mValue = ((Number)object).longValue();
        } else if (object instanceof String) {
            try {
                this.mValue = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SMTLIBException(numberFormatException.getMessage());
            }
        } else {
            throw new SMTLIBException("Not a number: " + String.valueOf(object));
        }
    }

    public final long getValue() {
        return this.mValue;
    }

    @Override
    public Object get() {
        return BigInteger.valueOf(this.mValue);
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return BigInteger.valueOf(this.mDefaultValue);
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

