/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IcfgEdgeBuilder {
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final ManagedScript mManagedScript;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final IcfgEdgeFactory mEdgeFactory;

    public IcfgEdgeBuilder(CfgSmtToolkit cfgSmtToolkit, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
        this.mManagedScript = cfgSmtToolkit.getManagedScript();
        this.mCfgSmtToolkit = cfgSmtToolkit;
        this.mEdgeFactory = cfgSmtToolkit.getIcfgEdgeFactory();
    }

    public IcfgEdge constructSequentialComposition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, List<IcfgEdge> list) {
        return this.constructSequentialComposition(icfgLocation, icfgLocation2, list, false, false, true);
    }

    public IcfgEdge constructSequentialComposition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        List<IcfgEdge> list = Arrays.asList(icfgEdge, icfgEdge2);
        return this.constructSequentialComposition(icfgLocation, icfgLocation2, list, false, false, true);
    }

    public IcfgEdge constructSimplifiedSequentialComposition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IcfgEdge icfgEdge) {
        return this.constructSequentialComposition(icfgLocation, icfgLocation2, Collections.singletonList(icfgEdge), true, true, true);
    }

    public IcfgEdge constructSequentialComposition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, List<IcfgEdge> list, boolean bl, boolean bl2, boolean bl3) {
        assert (IcfgEdgeBuilder.onlyInternal(list)) : "You cannot have calls or returns in normal sequential compositions";
        List<UnmodifiableTransFormula> list2 = list.stream().map(IAction::getTransformula).collect(Collectors.toList());
        UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaUtils.sequentialComposition(this.mLogger, this.mServices, this.mManagedScript, bl, bl2, false, this.mSimplificationTechnique, list2);
        List<UnmodifiableTransFormula> list3 = list.stream().map(IcfgEdgeBuilder::getTransformulaWithBE).collect(Collectors.toList());
        UnmodifiableTransFormula unmodifiableTransFormula2 = TransFormulaUtils.sequentialComposition(this.mLogger, this.mServices, this.mManagedScript, bl, bl2, false, this.mSimplificationTechnique, list3);
        IcfgInternalTransition icfgInternalTransition = this.mEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, null, unmodifiableTransFormula, unmodifiableTransFormula2);
        ModelUtils.mergeAnnotations(list, (IElement)icfgInternalTransition);
        if (bl3) {
            icfgLocation.addOutgoing((IModifiableMultigraphEdge)icfgInternalTransition);
            icfgLocation2.addIncoming((IModifiableMultigraphEdge)icfgInternalTransition);
        }
        return icfgInternalTransition;
    }

    private static UnmodifiableTransFormula getTransformulaWithBE(IcfgEdge icfgEdge) {
        if (icfgEdge instanceof IActionWithBranchEncoders) {
            return ((IActionWithBranchEncoders)((Object)icfgEdge)).getTransitionFormulaWithBranchEncoders();
        }
        return icfgEdge.getTransformula();
    }

    public IcfgEdge constructInterproceduralSequentialComposition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IIcfgCallTransition<?> iIcfgCallTransition, IIcfgTransition<?> iIcfgTransition, IIcfgReturnTransition<?, ?> iIcfgReturnTransition) {
        return this.constructInterproceduralSequentialComposition(icfgLocation, icfgLocation2, iIcfgCallTransition, iIcfgTransition, iIcfgReturnTransition, false, false);
    }

    private IcfgEdge constructInterproceduralSequentialComposition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IIcfgCallTransition<?> iIcfgCallTransition, IIcfgTransition<?> iIcfgTransition, IIcfgReturnTransition<?, ?> iIcfgReturnTransition, boolean bl, boolean bl2) {
        UnmodifiableTransFormula unmodifiableTransFormula;
        Object object;
        String string = iIcfgCallTransition.getSucceedingProcedure();
        UnmodifiableTransFormula unmodifiableTransFormula2 = iIcfgCallTransition.getLocalVarsAssignment();
        UnmodifiableTransFormula unmodifiableTransFormula3 = this.mCfgSmtToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(string);
        UnmodifiableTransFormula unmodifiableTransFormula4 = this.mCfgSmtToolkit.getOldVarsAssignmentCache().getGlobalVarsAssignment(string);
        UnmodifiableTransFormula unmodifiableTransFormula5 = iIcfgTransition.getTransformula();
        UnmodifiableTransFormula unmodifiableTransFormula6 = iIcfgReturnTransition.getAssignmentOfReturn();
        IIcfgSymbolTable iIcfgSymbolTable = this.mCfgSmtToolkit.getSymbolTable();
        Set<IProgramNonOldVar> set = this.mCfgSmtToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(string);
        UnmodifiableTransFormula unmodifiableTransFormula7 = TransFormulaUtils.sequentialCompositionWithCallAndReturn(this.mManagedScript, bl, bl2, false, unmodifiableTransFormula2, unmodifiableTransFormula3, unmodifiableTransFormula4, unmodifiableTransFormula5, unmodifiableTransFormula6, this.mLogger, this.mServices, this.mSimplificationTechnique, iIcfgSymbolTable, set);
        if (iIcfgTransition instanceof IActionWithBranchEncoders) {
            object = ((IActionWithBranchEncoders)((Object)iIcfgTransition)).getTransitionFormulaWithBranchEncoders();
            unmodifiableTransFormula = TransFormulaUtils.sequentialCompositionWithCallAndReturn(this.mManagedScript, bl, bl2, false, unmodifiableTransFormula2, unmodifiableTransFormula3, unmodifiableTransFormula4, (UnmodifiableTransFormula)object, unmodifiableTransFormula6, this.mLogger, this.mServices, this.mSimplificationTechnique, iIcfgSymbolTable, set);
        } else {
            unmodifiableTransFormula = unmodifiableTransFormula7;
        }
        object = this.mEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, null, unmodifiableTransFormula7, unmodifiableTransFormula);
        icfgLocation.addOutgoing((IModifiableMultigraphEdge)object);
        icfgLocation2.addIncoming((IModifiableMultigraphEdge)object);
        ModelUtils.mergeAnnotations((IElement)object, (IElement[])new IElement[]{iIcfgCallTransition, iIcfgTransition, iIcfgReturnTransition});
        return object;
    }

    public IcfgInternalTransition constructParallelComposition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, Map<TermVariable, IcfgEdge> map) {
        assert (!map.isEmpty()) : "Cannot compose 0 transitions";
        Collection<IcfgEdge> collection = map.values();
        assert (IcfgEdgeBuilder.onlyInternal(collection)) : "You cannot have calls or returns in parallel compositions";
        List<UnmodifiableTransFormula> list = collection.stream().map(IAction::getTransformula).collect(Collectors.toList());
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = list.toArray(new UnmodifiableTransFormula[list.size()]);
        UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaUtils.parallelComposition(this.mLogger, this.mServices, this.mManagedScript, null, false, true, unmodifiableTransFormulaArray);
        List<UnmodifiableTransFormula> list2 = collection.stream().map(IcfgEdgeBuilder::getTransformulaWithBE).collect(Collectors.toList());
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray2 = list2.toArray(new UnmodifiableTransFormula[list2.size()]);
        TermVariable[] termVariableArray = map.keySet().toArray(new TermVariable[map.size()]);
        UnmodifiableTransFormula unmodifiableTransFormula2 = TransFormulaUtils.parallelComposition(this.mLogger, this.mServices, this.mManagedScript, termVariableArray, false, true, unmodifiableTransFormulaArray2);
        IcfgInternalTransition icfgInternalTransition = this.mEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, null, unmodifiableTransFormula, unmodifiableTransFormula2);
        ModelUtils.mergeAnnotations(collection, (IElement)icfgInternalTransition);
        return icfgInternalTransition;
    }

    public Map<TermVariable, IcfgEdge> constructBranchIndicatorToEdgeMapping(List<IcfgEdge> list) {
        LinkedHashMap<TermVariable, IcfgEdge> linkedHashMap = new LinkedHashMap<TermVariable, IcfgEdge>();
        this.mManagedScript.lock(linkedHashMap);
        int n = 0;
        while (n < list.size()) {
            String string = "BraInd" + n + "of" + list.size();
            Sort sort = SmtSortUtils.getBoolSort((Script)this.mManagedScript.getScript());
            TermVariable termVariable = this.mManagedScript.constructFreshTermVariable(string, sort);
            linkedHashMap.put(termVariable, list.get(n));
            ++n;
        }
        this.mManagedScript.unlock(linkedHashMap);
        return linkedHashMap;
    }

    private static boolean onlyInternal(Collection<IcfgEdge> collection) {
        return collection.stream().allMatch(IcfgEdgeBuilder::onlyInternal);
    }

    private static boolean onlyInternal(IcfgEdge icfgEdge) {
        return icfgEdge instanceof IIcfgInternalTransition && !(icfgEdge instanceof IIcfgSummaryTransition);
    }

    public IcfgEdge constructAndConnectInternalTransition(IcfgEdge icfgEdge, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, Term term) {
        assert (IcfgEdgeBuilder.onlyInternal(icfgEdge)) : "You cannot have calls or returns in normal sequential compositions";
        UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge.getTransformula();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>(Arrays.asList(unmodifiableTransFormula.getFormula().getFreeVars()));
        Map<IProgramVar, TermVariable> map = IcfgEdgeBuilder.filterValues(unmodifiableTransFormula.getInVars(), hashSet::contains);
        Map<IProgramVar, TermVariable> map2 = IcfgEdgeBuilder.filterValues(unmodifiableTransFormula.getOutVars(), hashSet::contains);
        HashSet<TermVariable> hashSet3 = new HashSet<TermVariable>(unmodifiableTransFormula.getAuxVars());
        hashSet3.retainAll(hashSet);
        map.putAll(IcfgEdgeBuilder.filterValues(unmodifiableTransFormula.getInVars(), termVariable -> !hashSet2.contains(termVariable)));
        map2.putAll(IcfgEdgeBuilder.filterValues(unmodifiableTransFormula.getOutVars(), termVariable -> !hashSet2.contains(termVariable)));
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map, map2, unmodifiableTransFormula.getNonTheoryConsts().isEmpty(), unmodifiableTransFormula.getNonTheoryConsts(), true, null, hashSet3.isEmpty());
        transFormulaBuilder.setFormula(term);
        if (!hashSet3.isEmpty()) {
            transFormulaBuilder.addAuxVarsButRenameToFreshCopies(hashSet3, this.mManagedScript);
        }
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        UnmodifiableTransFormula unmodifiableTransFormula2 = transFormulaBuilder.finishConstruction(this.mManagedScript);
        return this.constructAndConnectInternalTransition(icfgEdge, icfgLocation, icfgLocation2, unmodifiableTransFormula2);
    }

    public IcfgEdge constructAndConnectInternalTransition(IcfgEdge icfgEdge, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, UnmodifiableTransFormula unmodifiableTransFormula) {
        IcfgEdge icfgEdge2 = this.constructInternalTransition(icfgEdge, icfgLocation, icfgLocation2, unmodifiableTransFormula);
        icfgLocation.addOutgoing((IModifiableMultigraphEdge)icfgEdge2);
        icfgLocation2.addIncoming((IModifiableMultigraphEdge)icfgEdge2);
        return icfgEdge2;
    }

    public IcfgEdge constructInternalTransition(IcfgEdge icfgEdge, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, UnmodifiableTransFormula unmodifiableTransFormula) {
        assert (IcfgEdgeBuilder.onlyInternal(icfgEdge)) : "You cannot have calls or returns in normal sequential compositions";
        IcfgInternalTransition icfgInternalTransition = this.mEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, null, unmodifiableTransFormula);
        ModelUtils.copyAnnotations((IElement)icfgEdge, (IElement)icfgInternalTransition);
        return icfgInternalTransition;
    }

    public IcfgForkThreadCurrentTransition constructForkCurrentTransition(IcfgForkThreadCurrentTransition icfgForkThreadCurrentTransition, UnmodifiableTransFormula unmodifiableTransFormula, boolean bl) {
        IcfgForkThreadCurrentTransition icfgForkThreadCurrentTransition2 = this.mEdgeFactory.createForkThreadCurrentTransition((IcfgLocation)icfgForkThreadCurrentTransition.getSource(), (IcfgLocation)icfgForkThreadCurrentTransition.getTarget(), null, unmodifiableTransFormula, icfgForkThreadCurrentTransition.getForkSmtArguments(), icfgForkThreadCurrentTransition.getNameOfForkedProcedure());
        ModelUtils.copyAnnotations((IElement)icfgForkThreadCurrentTransition, (IElement)icfgForkThreadCurrentTransition2);
        if (bl) {
            ((IcfgLocation)icfgForkThreadCurrentTransition.getSource()).addOutgoing((IModifiableMultigraphEdge)icfgForkThreadCurrentTransition2);
            ((IcfgLocation)icfgForkThreadCurrentTransition.getTarget()).addIncoming((IModifiableMultigraphEdge)icfgForkThreadCurrentTransition2);
        }
        return icfgForkThreadCurrentTransition2;
    }

    public IcfgForkThreadOtherTransition constructForkOtherTransition(IcfgForkThreadOtherTransition icfgForkThreadOtherTransition, UnmodifiableTransFormula unmodifiableTransFormula, boolean bl) {
        IcfgForkThreadOtherTransition icfgForkThreadOtherTransition2 = this.mEdgeFactory.createForkThreadOtherTransition((IcfgLocation)icfgForkThreadOtherTransition.getSource(), (IcfgLocation)icfgForkThreadOtherTransition.getTarget(), null, unmodifiableTransFormula, icfgForkThreadOtherTransition.getCorrespondingIIcfgForkTransitionCurrentThread());
        ModelUtils.copyAnnotations((IElement)icfgForkThreadOtherTransition, (IElement)icfgForkThreadOtherTransition2);
        if (bl) {
            ((IcfgLocation)icfgForkThreadOtherTransition.getSource()).addOutgoing((IModifiableMultigraphEdge)icfgForkThreadOtherTransition2);
            ((IcfgLocation)icfgForkThreadOtherTransition.getTarget()).addIncoming((IModifiableMultigraphEdge)icfgForkThreadOtherTransition2);
        }
        return icfgForkThreadOtherTransition2;
    }

    public IcfgJoinThreadCurrentTransition constructJoinCurrentTransition(IcfgJoinThreadCurrentTransition icfgJoinThreadCurrentTransition, UnmodifiableTransFormula unmodifiableTransFormula, boolean bl) {
        IcfgJoinThreadCurrentTransition icfgJoinThreadCurrentTransition2 = this.mEdgeFactory.createJoinThreadCurrentTransition((IcfgLocation)icfgJoinThreadCurrentTransition.getSource(), (IcfgLocation)icfgJoinThreadCurrentTransition.getTarget(), null, unmodifiableTransFormula, icfgJoinThreadCurrentTransition.getJoinSmtArguments());
        ModelUtils.copyAnnotations((IElement)icfgJoinThreadCurrentTransition, (IElement)icfgJoinThreadCurrentTransition2);
        if (bl) {
            ((IcfgLocation)icfgJoinThreadCurrentTransition.getSource()).addOutgoing((IModifiableMultigraphEdge)icfgJoinThreadCurrentTransition2);
            ((IcfgLocation)icfgJoinThreadCurrentTransition.getTarget()).addIncoming((IModifiableMultigraphEdge)icfgJoinThreadCurrentTransition2);
        }
        return icfgJoinThreadCurrentTransition2;
    }

    public IcfgJoinThreadOtherTransition constructJoinOtherTransition(IcfgJoinThreadOtherTransition icfgJoinThreadOtherTransition, UnmodifiableTransFormula unmodifiableTransFormula, boolean bl) {
        IcfgJoinThreadOtherTransition icfgJoinThreadOtherTransition2 = this.mEdgeFactory.createJoinThreadOtherTransition((IcfgLocation)icfgJoinThreadOtherTransition.getSource(), (IcfgLocation)icfgJoinThreadOtherTransition.getTarget(), null, unmodifiableTransFormula, icfgJoinThreadOtherTransition.getCorrespondingIIcfgJoinTransitionCurrentThread());
        ModelUtils.copyAnnotations((IElement)icfgJoinThreadOtherTransition, (IElement)icfgJoinThreadOtherTransition2);
        if (bl) {
            ((IcfgLocation)icfgJoinThreadOtherTransition.getSource()).addOutgoing((IModifiableMultigraphEdge)icfgJoinThreadOtherTransition2);
            ((IcfgLocation)icfgJoinThreadOtherTransition.getTarget()).addIncoming((IModifiableMultigraphEdge)icfgJoinThreadOtherTransition2);
        }
        return icfgJoinThreadOtherTransition2;
    }

    public IcfgEdge constructInternalTransition(IcfgEdge icfgEdge, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, boolean bl) {
        assert (IcfgEdgeBuilder.onlyInternal(icfgEdge)) : "You cannot have calls or returns in normal sequential compositions";
        IcfgInternalTransition icfgInternalTransition = this.mEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, null, unmodifiableTransFormula, unmodifiableTransFormula2);
        ModelUtils.copyAnnotations((IElement)icfgEdge, (IElement)icfgInternalTransition);
        if (bl) {
            icfgLocation.addOutgoing((IModifiableMultigraphEdge)icfgInternalTransition);
            icfgLocation2.addIncoming((IModifiableMultigraphEdge)icfgInternalTransition);
        }
        return icfgInternalTransition;
    }

    private static <K, V> Map<K, V> filterValues(Map<K, V> map, Predicate<V> predicate) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return map.entrySet().stream().filter(entry -> predicate.test(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

