/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker;

import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors.SimpleRCFGVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.IRCFGWalker;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.ObserverDispatcher;
import java.util.Collection;

public abstract class RCFGWalker
implements IRCFGWalker {
    protected ObserverDispatcher mDispatcher;
    protected final ILogger mLogger;

    public RCFGWalker(ObserverDispatcher observerDispatcher, ILogger iLogger) {
        this.mDispatcher = observerDispatcher;
        this.mLogger = iLogger;
    }

    @Override
    public boolean addObserver(IObserver iObserver) {
        return this.mDispatcher.addObserver(iObserver);
    }

    @Override
    public boolean removeObserver(IObserver iObserver) {
        return this.mDispatcher.removeObserver(iObserver);
    }

    @Override
    public void removeAllObservers() {
        this.mDispatcher.removeAllObservers();
    }

    @Override
    public boolean containsObserver(IObserver iObserver) {
        return this.mDispatcher.containsObserver(iObserver);
    }

    @Override
    public void run(Collection<IcfgEdge> collection) {
        this.mDispatcher.run(collection);
    }

    protected void programExitReached() {
        this.mDispatcher.callObservers(SimpleRCFGVisitor::endOfTrace);
    }

    protected void pre(IcfgLocation icfgLocation) {
        this.mDispatcher.callObservers(simpleRCFGVisitor -> simpleRCFGVisitor.pre(icfgLocation));
    }

    protected void pre(IcfgEdge icfgEdge) {
        this.mDispatcher.callObservers(simpleRCFGVisitor -> simpleRCFGVisitor.pre(icfgEdge));
    }

    protected void post(IcfgLocation icfgLocation) {
        this.mDispatcher.callObservers(simpleRCFGVisitor -> simpleRCFGVisitor.post(icfgLocation));
    }

    protected void post(IcfgEdge icfgEdge) {
        this.mDispatcher.callObservers(simpleRCFGVisitor -> simpleRCFGVisitor.post(icfgEdge));
    }

    protected void level(IcfgLocation icfgLocation) {
        this.mDispatcher.callObservers(simpleRCFGVisitor -> simpleRCFGVisitor.level(icfgLocation));
    }

    protected void level(IcfgEdge icfgEdge) {
        this.mDispatcher.callObservers(simpleRCFGVisitor -> simpleRCFGVisitor.level(icfgEdge));
    }
}

