/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.dawg;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Dawg<LETTER, VALUE> {
    final VALUE mFinal;
    final Map<LETTER, Dawg<LETTER, VALUE>> mTransitions;
    final Dawg<LETTER, VALUE> mElseTransition;
    static final UnifyHash<Dawg<?, ?>> sUnifier = new UnifyHash();
    Dawg<LETTER, VALUE> mCachedParent = null;

    private Dawg(VALUE VALUE) {
        this.mFinal = VALUE;
        this.mTransitions = null;
        this.mElseTransition = null;
    }

    private Dawg(Map<LETTER, Dawg<LETTER, VALUE>> map, Dawg<LETTER, VALUE> dawg) {
        this.mFinal = null;
        this.mTransitions = map;
        this.mElseTransition = dawg;
    }

    public static <LETTER, VALUE> Dawg<LETTER, VALUE> createConst(int n, VALUE VALUE) {
        int n2 = VALUE.hashCode();
        Dawg dawg = null;
        for (Dawg dawg2 : sUnifier.iterateHashCode(n2)) {
            if (!dawg2.isFinal() || !dawg2.mFinal.equals(VALUE)) continue;
            dawg = dawg2;
            break;
        }
        if (dawg == null) {
            dawg = new Dawg(VALUE);
            sUnifier.put(n2, dawg);
        }
        int n3 = 0;
        while (n3 < n) {
            dawg = dawg.createParent();
            ++n3;
        }
        return dawg;
    }

    private Dawg<LETTER, VALUE> createParent() {
        if (this.mCachedParent == null) {
            this.mCachedParent = new Dawg(Collections.emptyMap(), this);
        }
        return this.mCachedParent;
    }

    public static <LETTER, VALUE> Dawg<LETTER, VALUE> createDawg(Map<LETTER, Dawg<LETTER, VALUE>> map, Dawg<LETTER, VALUE> dawg) {
        if (map.isEmpty()) {
            return dawg.createParent();
        }
        Dawg<LETTER, VALUE> dawg2 = new Dawg<LETTER, VALUE>(map, dawg);
        return dawg2;
    }

    public Dawg<LETTER, VALUE> insert(List<LETTER> list, VALUE VALUE) {
        if (this.getValue(list) == VALUE) {
            return this;
        }
        return this.insert(list, VALUE, 0);
    }

    private Dawg<LETTER, VALUE> insert(List<LETTER> list, VALUE VALUE, int n) {
        if (n == list.size()) {
            return Dawg.createConst(0, VALUE);
        }
        LETTER LETTER = list.get(n);
        LinkedHashMap<LETTER, Dawg<LETTER, VALUE>> linkedHashMap = new LinkedHashMap<LETTER, Dawg<LETTER, VALUE>>();
        if (LETTER == null) {
            Dawg<LETTER, VALUE> dawg = this.mElseTransition.insert(list, VALUE, n + 1);
            for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : this.mTransitions.entrySet()) {
                Dawg<LETTER, VALUE> dawg2 = entry.getValue().insert(list, VALUE, n + 1);
                if (dawg2 == dawg) continue;
                linkedHashMap.put(entry.getKey(), dawg2);
            }
            return Dawg.createDawg(linkedHashMap, dawg);
        }
        Dawg<LETTER, VALUE> dawg = this.getNextDawg(LETTER);
        Dawg<LETTER, VALUE> dawg3 = dawg.insert(list, VALUE, n + 1);
        linkedHashMap.putAll(this.mTransitions);
        if (dawg3 == this.mElseTransition) {
            linkedHashMap.remove(LETTER);
        } else {
            linkedHashMap.put(LETTER, dawg3);
        }
        return Dawg.createDawg(linkedHashMap, this.mElseTransition);
    }

    private <V2, V3> Dawg<LETTER, V3> combineInternal(Dawg<LETTER, V2> dawg, BiFunction<VALUE, V2, V3> biFunction, Map<Pair<Dawg<LETTER, VALUE>, Dawg<LETTER, V2>>, Dawg<LETTER, V3>> map) {
        Pair<Dawg, Dawg<LETTER, V2>> pair = new Pair<Dawg, Dawg<LETTER, V2>>(this, dawg);
        Dawg<Object, V3> dawg2 = map.get(pair);
        if (dawg2 != null) {
            return dawg2;
        }
        if (this.mElseTransition == null) {
            assert (dawg.mElseTransition == null);
            dawg2 = Dawg.createConst(0, biFunction.apply(this.mFinal, dawg.mFinal));
        } else {
            Dawg<LETTER, V3> dawg3 = this.mElseTransition.combineInternal(dawg.mElseTransition, biFunction, map);
            if (this.mTransitions.isEmpty() && dawg.mTransitions.isEmpty()) {
                dawg2 = dawg3.createParent();
            } else {
                Dawg<LETTER, V3> dawg4;
                LETTER LETTER;
                LinkedHashMap<LETTER, Dawg<LETTER, V3>> linkedHashMap = new LinkedHashMap<LETTER, Dawg<LETTER, V3>>();
                for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : this.mTransitions.entrySet()) {
                    LETTER = entry.getKey();
                    dawg4 = entry.getValue().combineInternal(dawg.getNextDawg(LETTER), biFunction, map);
                    if (dawg4 == dawg3) continue;
                    linkedHashMap.put(LETTER, dawg4);
                }
                for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : dawg.mTransitions.entrySet()) {
                    LETTER = entry.getKey();
                    if (this.mTransitions.containsKey(LETTER) || (dawg4 = this.mElseTransition.combineInternal(entry.getValue(), biFunction, map)) == dawg3) continue;
                    linkedHashMap.put(LETTER, dawg4);
                }
                dawg2 = Dawg.createDawg(linkedHashMap, dawg3);
            }
        }
        map.put(pair, dawg2);
        return dawg2;
    }

    public <V2, V3> Dawg<LETTER, V3> combine(Dawg<LETTER, V2> dawg, BiFunction<VALUE, V2, V3> biFunction) {
        return this.combineInternal(dawg, biFunction, new HashMap<Pair<Dawg<LETTER, VALUE>, Dawg<LETTER, V2>>, Dawg<LETTER, V3>>());
    }

    private <V2> Dawg<LETTER, V2> mapInternal(Function<VALUE, V2> function, Map<Dawg<LETTER, VALUE>, Dawg<LETTER, V2>> map) {
        Dawg<Object, V2> dawg = map.get(this);
        if (dawg != null) {
            return dawg;
        }
        if (this.mElseTransition == null) {
            dawg = Dawg.createConst(0, function.apply(this.mFinal));
        } else {
            Dawg<LETTER, V2> dawg2 = this.mElseTransition.mapInternal(function, map);
            if (this.mTransitions.isEmpty()) {
                dawg = dawg2.createParent();
            } else {
                LinkedHashMap<LETTER, Dawg<LETTER, V2>> linkedHashMap = new LinkedHashMap<LETTER, Dawg<LETTER, V2>>();
                for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : this.mTransitions.entrySet()) {
                    LETTER LETTER = entry.getKey();
                    Dawg<LETTER, V2> dawg3 = entry.getValue().mapInternal(function, map);
                    if (dawg3 == dawg2) continue;
                    linkedHashMap.put(LETTER, dawg3);
                }
                dawg = Dawg.createDawg(linkedHashMap, dawg2);
            }
        }
        map.put(this, dawg);
        return dawg;
    }

    public <V2> Dawg<LETTER, V2> map(Function<VALUE, V2> function) {
        return this.mapInternal(function, new HashMap<Dawg<LETTER, VALUE>, Dawg<LETTER, V2>>());
    }

    private <V2> Dawg<LETTER, V2> mapWithKeyInternal(BiFunction<List<LETTER>, VALUE, V2> biFunction, ArrayList<LETTER> arrayList) {
        if (this.mElseTransition == null) {
            return Dawg.createConst(0, biFunction.apply(arrayList, this.mFinal));
        }
        arrayList.add(null);
        Dawg<LETTER, V2> dawg = this.mElseTransition.mapWithKeyInternal(biFunction, arrayList);
        arrayList.remove(arrayList.size() - 1);
        if (this.mTransitions.isEmpty()) {
            return dawg.createParent();
        }
        LinkedHashMap<LETTER, Dawg<LETTER, V2>> linkedHashMap = new LinkedHashMap<LETTER, Dawg<LETTER, V2>>();
        for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : this.mTransitions.entrySet()) {
            LETTER LETTER = entry.getKey();
            arrayList.add(LETTER);
            Dawg<LETTER, V2> dawg2 = entry.getValue().mapWithKeyInternal(biFunction, arrayList);
            arrayList.remove(arrayList.size() - 1);
            if (dawg2 == dawg) continue;
            linkedHashMap.put(LETTER, dawg2);
        }
        return Dawg.createDawg(linkedHashMap, dawg);
    }

    public <V2> Dawg<LETTER, V2> mapWithKey(BiFunction<List<LETTER>, VALUE, V2> biFunction) {
        return this.mapWithKeyInternal(biFunction, new ArrayList());
    }

    private static <LETTER, VALUE, LETTER2> Dawg<LETTER2, VALUE> mapKeysInternal(Set<Dawg<LETTER, VALUE>> set, Function<LETTER, LETTER2> function, BiFunction<VALUE, VALUE, VALUE> biFunction) {
        boolean bl = false;
        Object object2 = null;
        LinkedHashMap<LETTER2, LinkedHashSet<Dawg>> linkedHashMap = new LinkedHashMap<LETTER2, LinkedHashSet<Dawg>>();
        LinkedHashSet<Dawg<LETTER, VALUE>> linkedHashSet = new LinkedHashSet<Dawg<LETTER, VALUE>>();
        for (Dawg<LETTER, VALUE> dawg : set) {
            if (dawg.mElseTransition == null) {
                assert (linkedHashSet.isEmpty()) : "input set must not contain both final and non-final dawgs";
                bl = true;
                if (object2 == null) {
                    object2 = dawg.getFinalValue();
                    continue;
                }
                if (object2.equals(dawg.getFinalValue())) continue;
                object2 = biFunction.apply(object2, dawg.getFinalValue());
                continue;
            }
            assert (!bl) : "input set must not contain both final and non-final dawgs";
            for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : dawg.mTransitions.entrySet()) {
                LETTER2 LETTER2 = function.apply(entry.getKey());
                LinkedHashSet<Dawg> linkedHashSet2 = (LinkedHashSet<Dawg>)((HashMap)linkedHashMap).get(LETTER2);
                if (linkedHashSet2 == null) {
                    linkedHashSet2 = new LinkedHashSet<Dawg>();
                    linkedHashMap.put(LETTER2, linkedHashSet2);
                }
                linkedHashSet2.add((Dawg)entry.getValue());
            }
            linkedHashSet.add(dawg.mElseTransition);
        }
        if (bl) {
            return Dawg.createConst(0, object2);
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        for (Map.Entry entry : ((HashMap)linkedHashMap).entrySet()) {
            linkedHashMap2.put(entry.getKey(), Dawg.mapKeysInternal((Set)entry.getValue(), function, biFunction));
        }
        return Dawg.createDawg(linkedHashMap2, Dawg.mapKeysInternal(linkedHashSet, function, biFunction));
    }

    public <LETTER2> Dawg<LETTER2, VALUE> mapKeys(Function<LETTER, LETTER2> function, BiFunction<VALUE, VALUE, VALUE> biFunction) {
        return Dawg.mapKeysInternal(Collections.singleton(this), function, biFunction);
    }

    public boolean isFinal() {
        return this.mTransitions == null;
    }

    public VALUE getFinalValue() {
        return this.mFinal;
    }

    public String toString() {
        if (this.isFinal()) {
            return "RET(" + String.valueOf(this.mFinal) + ")";
        }
        StringBuilder stringBuilder = new StringBuilder();
        LinkedHashSet<Dawg<LETTER, VALUE>> linkedHashSet = new LinkedHashSet<Dawg<LETTER, VALUE>>();
        HashSet<Dawg> hashSet = new HashSet<Dawg>();
        linkedHashSet.add(this);
        while (!linkedHashSet.isEmpty()) {
            Dawg dawg = (Dawg)linkedHashSet.iterator().next();
            linkedHashSet.remove(dawg);
            if (!hashSet.add(dawg)) continue;
            stringBuilder.append(String.format("Dawg#%04d", dawg.hashCode() % 10000));
            String string = "";
            for (Map.Entry<LETTER, Dawg<LETTER, VALUE>> entry : dawg.getTransitions().entrySet()) {
                stringBuilder.append(string).append("->");
                if (entry.getValue().isFinal()) {
                    stringBuilder.append("(").append(entry.getValue().getFinalValue()).append(") ");
                } else {
                    stringBuilder.append(String.format("#%04d ", entry.getValue().hashCode() % 10000));
                    linkedHashSet.add(entry.getValue());
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("\n");
                string = "         ";
            }
            stringBuilder.append(string).append("->");
            if (dawg.mElseTransition.isFinal()) {
                stringBuilder.append("(").append(dawg.mElseTransition.getFinalValue()).append(") ");
            } else {
                stringBuilder.append(String.format("#%04d ", dawg.mElseTransition.hashCode() % 10000));
                linkedHashSet.add(dawg.mElseTransition);
            }
            stringBuilder.append("OTHERWISE\n");
        }
        return stringBuilder.toString();
    }

    public Dawg<LETTER, VALUE> getNextDawg(LETTER LETTER) {
        Dawg<LETTER, VALUE> dawg = this.mTransitions.get(LETTER);
        if (dawg == null) {
            dawg = this.mElseTransition;
        }
        return dawg;
    }

    public Map<LETTER, Dawg<LETTER, VALUE>> getTransitions() {
        return this.mTransitions;
    }

    public VALUE getValue(List<LETTER> list) {
        Dawg<LETTER, VALUE> dawg = this;
        for (LETTER LETTER : list) {
            assert (!dawg.isFinal());
            dawg = dawg.getNextDawg(LETTER);
        }
        assert (dawg.isFinal());
        return dawg.getFinalValue();
    }

    public Iterable<Entry<LETTER, VALUE>> entrySet() {
        if (this.isFinal()) {
            return Collections.singleton(new Entry(Collections.emptyList(), this.mFinal));
        }
        return new Iterable<Entry<LETTER, VALUE>>(){

            @Override
            public Iterator<Entry<LETTER, VALUE>> iterator() {
                return new Iterator<Entry<LETTER, VALUE>>(){
                    Iterator<Map.Entry<LETTER, Dawg<LETTER, VALUE>>> mTransIterator;
                    Map.Entry<LETTER, Dawg<LETTER, VALUE>> mCurrentEntry;
                    Iterator<Entry<LETTER, VALUE>> mSubIterator;
                    {
                        this.mTransIterator = (this).Dawg.this.mTransitions.entrySet().iterator();
                        this.mCurrentEntry = null;
                        this.mSubIterator = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.mSubIterator == null || !this.mSubIterator.hasNext()) {
                            if (this.mTransIterator == null) {
                                return false;
                            }
                            if (this.mTransIterator.hasNext()) {
                                this.mCurrentEntry = this.mTransIterator.next();
                            } else {
                                this.mTransIterator = null;
                                this.mCurrentEntry = new Map.Entry<LETTER, Dawg<LETTER, VALUE>>(){

                                    @Override
                                    public LETTER getKey() {
                                        return null;
                                    }

                                    @Override
                                    public Dawg<LETTER, VALUE> getValue() {
                                        return ((this).this).Dawg.this.mElseTransition;
                                    }

                                    @Override
                                    public Dawg<LETTER, VALUE> setValue(Dawg<LETTER, VALUE> dawg) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }
                            this.mSubIterator = this.mCurrentEntry.getValue().entrySet().iterator();
                        }
                        return true;
                    }

                    @Override
                    public Entry<LETTER, VALUE> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (!($assertionsDisabled || this.mSubIterator != null && this.mSubIterator.hasNext())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && this.mCurrentEntry == null) {
                            throw new AssertionError();
                        }
                        Entry entry = this.mSubIterator.next();
                        ConsList consList = new ConsList(this.mCurrentEntry.getKey(), entry.getKey());
                        return new Entry(consList, entry.getValue());
                    }
                };
            }
        };
    }

    public Iterable<VALUE> values() {
        if (this.isFinal()) {
            return Collections.singleton(this.mFinal);
        }
        return new Iterable<VALUE>(){
            private Set<Dawg<LETTER, VALUE>> mVisited = new HashSet();

            @Override
            public Iterator<VALUE> iterator() {
                return new Iterator<VALUE>(){
                    Iterator<Dawg<LETTER, VALUE>> mTransIterator;
                    Dawg<LETTER, VALUE> mCurrentEntry;
                    Iterator<VALUE> mSubIterator;
                    {
                        this.mTransIterator = (this).Dawg.this.mTransitions.values().iterator();
                        this.mCurrentEntry = null;
                        this.mSubIterator = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.mSubIterator == null || !this.mSubIterator.hasNext()) {
                            if (this.mTransIterator == null) {
                                return false;
                            }
                            if (this.mTransIterator.hasNext()) {
                                this.mCurrentEntry = this.mTransIterator.next();
                            } else {
                                this.mTransIterator = null;
                                this.mCurrentEntry = (this).Dawg.this.mElseTransition;
                            }
                            this.mSubIterator = mVisited.add(this.mCurrentEntry) ? this.mCurrentEntry.values().iterator() : null;
                        }
                        return true;
                    }

                    @Override
                    public VALUE next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (!($assertionsDisabled || this.mSubIterator != null && this.mSubIterator.hasNext())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && this.mCurrentEntry == null) {
                            throw new AssertionError();
                        }
                        return this.mSubIterator.next();
                    }
                };
            }
        };
    }

    private static class ConsList<T>
    extends AbstractList<T> {
        private T mHead;
        private List<T> mTail;
        private int mSize;

        public ConsList(T t, List<T> list) {
            this.mHead = t;
            this.mTail = list;
            this.mSize = list.size() + 1;
        }

        @Override
        public T get(int n) {
            return n == 0 ? this.mHead : this.mTail.get(n - 1);
        }

        @Override
        public int size() {
            return this.mSize;
        }
    }

    public static class Entry<LETTER, VALUE> {
        private List<LETTER> mKey;
        private VALUE mValue;

        public Entry(List<LETTER> list, VALUE VALUE) {
            this.mKey = list;
            this.mValue = VALUE;
        }

        public List<LETTER> getKey() {
            return this.mKey;
        }

        public VALUE getValue() {
            return this.mValue;
        }
    }
}

