/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.aiger;

import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.IParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class AIGERFrontEnd
implements IParser {
    private static final int BUFFER_SIZE = 4096;
    private static final boolean USE_DEFINITIONS = true;
    private static final int TT_MAGIC = 0;
    private static final int TT_SPACE = 1;
    private static final int TT_NUMBER = 2;
    private static final int TT_NEWLINE = 3;
    private static final int TT_EOF = 4;
    private static final int TT_STS = 5;
    private static final int TT_STRING = 6;
    private static final int TT_COMMENT = 7;
    private static final int TT_BNUMBER = 8;
    private int mLine = 1;
    private int mCol = 0;
    private String mFilename;
    private InputStream mInputStream;
    private Script mSolver;
    private BigInteger mNumAnds;
    private String[] mInputs;
    private byte[] mBuffer = new byte[4096];
    private int mBufpos = 0;
    private int mBufsize = -1;

    private void reportError(String string) {
        System.err.print(this.mFilename);
        System.err.print(':');
        System.err.print(this.mLine);
        System.err.print(':');
        System.err.print(this.mCol);
        System.err.print(':');
        System.err.println(string);
        System.exit(2);
    }

    private final int nextChar() throws IOException {
        if (this.mBufpos >= this.mBufsize) {
            this.mBufsize = this.mInputStream.read(this.mBuffer);
            if (this.mBufsize == -1) {
                return -1;
            }
            this.mBufpos = 0;
        }
        ++this.mCol;
        return this.mBuffer[this.mBufpos++] & 0xFF;
    }

    private final void ungetLastChar() {
        assert (this.mBufpos > 0);
        --this.mCol;
        --this.mBufpos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object nextToken(int n) {
        try {
            int n2 = this.nextChar();
            switch (n) {
                case 0: {
                    if (n2 != 97) {
                        return null;
                    }
                    n2 = this.nextChar();
                    if (n2 != 105) {
                        return null;
                    }
                    n2 = this.nextChar();
                    if (n2 == 103) return "aig";
                    return null;
                }
                case 1: {
                    if (n2 == 32) {
                        return " ";
                    }
                    this.ungetLastChar();
                    return null;
                }
                case 2: {
                    StringBuilder stringBuilder = new StringBuilder();
                    while (true) {
                        if (n2 == -1 || !Character.isDigit((char)n2)) {
                            this.ungetLastChar();
                            if (stringBuilder.length() != 0) return stringBuilder.toString();
                            return null;
                        }
                        stringBuilder.append((char)n2);
                        n2 = this.nextChar();
                    }
                }
                case 4: {
                    if (n2 == -1) {
                        return "";
                    }
                    this.ungetLastChar();
                    return null;
                }
                case 3: {
                    if (n2 == 10) {
                        ++this.mLine;
                        this.mCol = 0;
                        return "\n";
                    }
                    this.ungetLastChar();
                    return null;
                }
                case 5: {
                    if (n2 == 105) return Character.toString((char)n2);
                    if (n2 == 108) return Character.toString((char)n2);
                    if (n2 == 111) return Character.toString((char)n2);
                    this.ungetLastChar();
                    return null;
                }
                case 6: {
                    StringBuilder stringBuilder = new StringBuilder();
                    while (true) {
                        if (n2 == -1 || n2 == 10) {
                            this.ungetLastChar();
                            return stringBuilder.toString();
                        }
                        stringBuilder.append((char)n2);
                        n2 = this.nextChar();
                    }
                }
                case 7: {
                    if (n2 == 99) {
                        return "c";
                    }
                    this.ungetLastChar();
                    return null;
                }
                case 8: {
                    BigInteger bigInteger;
                    BigInteger bigInteger2 = BigInteger.ZERO;
                    int n3 = 0;
                    while (true) {
                        if ((n2 & 0x80) == 0) {
                            bigInteger = BigInteger.valueOf(n2 & 0x7F);
                            assert (7 * n3 >= 0);
                            break;
                        }
                        bigInteger = BigInteger.valueOf(n2 & 0x7F);
                        assert (7 * n3 >= 0);
                        bigInteger = bigInteger.shiftLeft(7 * n3++);
                        bigInteger2 = bigInteger2.or(bigInteger);
                        n2 = this.nextChar();
                        if (n2 != -1) continue;
                        System.err.println("File corrupted");
                        System.exit(5);
                    }
                    bigInteger = bigInteger.shiftLeft(7 * n3);
                    return bigInteger2.or(bigInteger);
                }
            }
            this.ungetLastChar();
            return null;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
            return null;
        }
    }

    private final void getOneSpace() {
        if (this.nextToken(1) == null) {
            this.reportError("Expected one space");
        }
    }

    private final void getNewline() {
        if (this.nextToken(3) == null) {
            this.reportError("Expected newline");
        }
    }

    private final String getNumber() {
        String string = (String)this.nextToken(2);
        if (string == null) {
            this.reportError("Expected a number");
        }
        return string;
    }

    private void parseHeader() {
        if (this.nextToken(0) == null) {
            this.reportError("Expected magic (\"aig\")");
        }
        this.getOneSpace();
        BigInteger bigInteger = new BigInteger(this.getNumber());
        this.getOneSpace();
        this.mInputs = new String[Integer.parseInt(this.getNumber())];
        this.getOneSpace();
        if (!this.getNumber().equals("0")) {
            System.err.println("No latches allowed for SAT checking");
            System.exit(3);
        }
        this.getOneSpace();
        if (!this.getNumber().equals("1")) {
            System.err.println("Only one output allowed for SAT checking");
            System.exit(3);
        }
        this.getOneSpace();
        this.mNumAnds = new BigInteger(this.getNumber());
        this.getNewline();
        if (!bigInteger.equals(this.mNumAnds.add(BigInteger.valueOf(this.mInputs.length)))) {
            System.err.println("File header corrupted!");
            System.exit(5);
        }
    }

    private void parseSymbolTable() {
        String string;
        while ((string = (String)this.nextToken(5)) != null) {
            String string2 = this.getNumber();
            this.getOneSpace();
            String string3 = (String)this.nextToken(6);
            if (string3 == null) {
                this.reportError("Expected a string");
                System.exit(2);
            }
            this.getNewline();
            if (!string.equals("i")) continue;
            int n = Integer.parseInt(string2);
            this.mInputs[n] = string3;
        }
    }

    private void parseCommentSection() {
        if (this.nextToken(7) != null) {
            do {
                this.getNewline();
            } while (this.nextToken(6) != null);
        }
    }

    private Term toTerm(BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ZERO)) {
            return this.mSolver.term("false", new Term[0]);
        }
        if (bigInteger.equals(BigInteger.ONE)) {
            return this.mSolver.term("true", new Term[0]);
        }
        Term term = this.mSolver.term(bigInteger.shiftRight(1).toString(), new Term[0]);
        if (bigInteger.testBit(0)) {
            term = this.mSolver.term("not", new Term[]{term});
        }
        return term;
    }

    private void parse() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        this.parseHeader();
        Sort sort = this.mSolver.sort("Bool", new Sort[0]);
        Sort[] sortArray = new Sort[]{};
        int n = 0;
        while (n < this.mInputs.length) {
            this.mSolver.declareFun(Integer.toString(n + 1), sortArray, sort);
            ++n;
        }
        BigInteger bigInteger3 = new BigInteger(this.getNumber());
        this.getNewline();
        TermVariable[] termVariableArray = new TermVariable[]{};
        BigInteger bigInteger4 = BigInteger.valueOf(this.mInputs.length);
        BigInteger bigInteger5 = bigInteger4.add(this.mNumAnds);
        bigInteger4 = bigInteger4.add(BigInteger.ONE);
        while (bigInteger4.compareTo(bigInteger5) <= 0) {
            bigInteger2 = (BigInteger)this.nextToken(8);
            bigInteger = (BigInteger)this.nextToken(8);
            BigInteger bigInteger6 = bigInteger4.shiftLeft(1).subtract(bigInteger2);
            assert (bigInteger4.shiftLeft(1).compareTo(bigInteger6) > 0);
            Term[] termArray = new Term[2];
            termArray[0] = this.toTerm(bigInteger6);
            BigInteger bigInteger7 = bigInteger6.subtract(bigInteger);
            assert (bigInteger6.compareTo(bigInteger7) >= 0);
            termArray[1] = this.toTerm(bigInteger7);
            this.mSolver.defineFun(bigInteger4.toString(), termVariableArray, sort, this.mSolver.term("and", termArray));
            bigInteger4 = bigInteger4.add(BigInteger.ONE);
        }
        this.parseSymbolTable();
        this.parseCommentSection();
        this.mBuffer = null;
        System.err.println("Finished parsing");
        bigInteger2 = this.toTerm(bigInteger3);
        bigInteger = new FormulaUnLet(FormulaUnLet.UnletType.EXPAND_DEFINITIONS);
        this.mSolver.assertTerm(bigInteger.unlet((Term)bigInteger2));
        System.err.println("Asserted formula");
    }

    @Override
    public int run(Script script, String string, OptionMap optionMap) {
        this.mSolver = script;
        if (string == null) {
            string = "<stdin>";
            this.mInputStream = System.in;
        } else {
            try {
                this.mInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getMessage());
                return 4;
            }
        }
        this.mFilename = string;
        this.mSolver.setOption(":produce-models", (Object)Boolean.TRUE);
        this.mSolver.setLogic(Logics.CORE);
        this.parse();
        Script.LBool lBool = this.mSolver.checkSat();
        System.out.println(lBool);
        if (lBool == Script.LBool.SAT) {
            System.out.println("Stimuli:");
            Model model = this.mSolver.getModel();
            Term term = this.mSolver.term("true", new Term[0]);
            int n = 0;
            while (n < this.mInputs.length) {
                Term term2 = this.mSolver.term(Integer.toString(n), new Term[0]);
                if (model.evaluate(term2) != term) {
                    System.out.print("not ");
                }
                System.out.println(this.mInputs[n] == null ? Integer.valueOf(n + 1) : this.mInputs[n]);
                ++n;
            }
        }
        return 0;
    }
}

