/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreLocationBlock;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IntraproceduralReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.LocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SubArrayManager {
    private final NestedMap2<IProgramVarOrConst, List<StoreLocationBlock>, IProgramVarOrConst> mArrayToLocationBlockListToSubArray;
    Set<IProgramVarOrConst> mAllSubArrays;
    private final ManagedScript mManagedScript;
    private final HeapSeparatorBenchmark mStatistics;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;

    public SubArrayManager(CfgSmtToolkit cfgSmtToolkit, HeapSeparatorBenchmark heapSeparatorBenchmark, ComputeStoreInfosAndArrayGroups<?> computeStoreInfosAndArrayGroups) {
        this.mManagedScript = cfgSmtToolkit.getManagedScript();
        this.mStatistics = heapSeparatorBenchmark;
        this.mCsiag = computeStoreInfosAndArrayGroups;
        this.mArrayToLocationBlockListToSubArray = new NestedMap2();
        this.mAllSubArrays = new HashSet<IProgramVarOrConst>();
    }

    public String toString() {
        return "NewArrayIdProvider";
    }

    public IProgramVarOrConst getSubArray(IProgramVarOrConst iProgramVarOrConst, List<StoreLocationBlock> list) {
        ArrayGroup arrayGroup = this.mCsiag.getArrayGroupForArrayPvoc(iProgramVarOrConst);
        assert (Objects.nonNull(arrayGroup));
        if (list.size() != arrayGroup.getDimensionality()) {
            throw new AssertionError((Object)"list of location blocks does not have the right length for the given array!");
        }
        IProgramVarOrConst iProgramVarOrConst2 = (IProgramVarOrConst)this.mArrayToLocationBlockListToSubArray.get((Object)iProgramVarOrConst, list);
        if (iProgramVarOrConst2 == null) {
            iProgramVarOrConst2 = this.constructFreshProgramVarsForIndexPartition(iProgramVarOrConst, list);
            this.mArrayToLocationBlockListToSubArray.put((Object)iProgramVarOrConst, list, (Object)iProgramVarOrConst2);
            this.mAllSubArrays.add(iProgramVarOrConst2);
            this.mStatistics.incrementNewArrayVarCounter(arrayGroup);
        }
        return iProgramVarOrConst2;
    }

    private IProgramVarOrConst constructFreshProgramVarsForIndexPartition(IProgramVarOrConst iProgramVarOrConst, List<StoreLocationBlock> list) {
        ProgramNonOldVar programNonOldVar = null;
        if (iProgramVarOrConst instanceof LocalProgramVar) {
            LocalProgramVar localProgramVar = (LocalProgramVar)iProgramVarOrConst;
            String string = localProgramVar.getIdentifier() + "_part_" + this.constructIndexName(list);
            TermVariable termVariable = this.mManagedScript.constructFreshCopy(localProgramVar.getTermVariable());
            this.mManagedScript.lock((Object)this);
            String string2 = string + "_const";
            this.mManagedScript.getScript().declareFun(string2, new Sort[0], termVariable.getSort());
            ApplicationTerm applicationTerm = (ApplicationTerm)this.mManagedScript.term((Object)this, string2, new Term[0]);
            String string3 = string + "_const_primed";
            this.mManagedScript.getScript().declareFun(string3, new Sort[0], termVariable.getSort());
            ApplicationTerm applicationTerm2 = (ApplicationTerm)this.mManagedScript.term((Object)this, string3, new Term[0]);
            programNonOldVar = new LocalProgramVar(string, localProgramVar.getProcedure(), termVariable, applicationTerm, applicationTerm2);
            this.mManagedScript.unlock((Object)this);
            return programNonOldVar;
        }
        if (iProgramVarOrConst instanceof ProgramNonOldVar) {
            ProgramNonOldVar programNonOldVar2;
            ProgramNonOldVar programNonOldVar3 = (ProgramNonOldVar)iProgramVarOrConst;
            String string = programNonOldVar3.getIdentifier() + "_part_" + this.constructIndexName(list);
            this.mManagedScript.lock((Object)this);
            programNonOldVar = programNonOldVar2 = ProgramVarUtils.constructGlobalProgramVarPair((String)string, (Sort)programNonOldVar3.getSort(), (ManagedScript)this.mManagedScript, (Object)this);
            this.mManagedScript.unlock((Object)this);
            return programNonOldVar;
        }
        if (iProgramVarOrConst instanceof ProgramOldVar) {
            ProgramOldVar programOldVar = (ProgramOldVar)iProgramVarOrConst;
            String string = programOldVar.getGloballyUniqueId() + "_part_" + this.constructIndexName(list);
            this.mManagedScript.lock((Object)this);
            ProgramNonOldVar programNonOldVar4 = ProgramVarUtils.constructGlobalProgramVarPair((String)string, (Sort)programOldVar.getSort(), (ManagedScript)this.mManagedScript, (Object)this);
            programNonOldVar = programNonOldVar4.getOldVar();
            assert (programNonOldVar != null);
            this.mManagedScript.unlock((Object)this);
            return programNonOldVar;
        }
        if (iProgramVarOrConst instanceof IntraproceduralReplacementVar) {
            throw new AssertionError((Object)"TODO: implement");
        }
        if (iProgramVarOrConst instanceof ProgramConst) {
            throw new AssertionError((Object)"TODO: implement");
        }
        throw new AssertionError((Object)"case missing --> add it?");
    }

    private String constructIndexName(List<StoreLocationBlock> list) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (StoreLocationBlock storeLocationBlock : list) {
            stringBuilder.append(string);
            stringBuilder.append(storeLocationBlock.toString());
            string = "_";
        }
        return stringBuilder.toString();
    }

    public boolean isSubArray(IProgramVar iProgramVar) {
        return this.mAllSubArrays.contains(iProgramVar);
    }
}

