/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.Evaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import java.util.Collection;
import java.util.Collections;

public class FunctionEvaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends IAbstractState<STATE>>
extends Evaluator<VALUE, STATE> {
    private final String mName;
    private final int mInParamCount;
    private final INonrelationalValueFactory<VALUE> mNonrelationalValueFactory;
    private final EvaluatorUtils.EvaluatorType mType;

    public FunctionEvaluator(String string, int n, int n2, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory, EvaluatorUtils.EvaluatorType evaluatorType, EvaluatorLogger evaluatorLogger) {
        super(n2, iNonrelationalValueFactory, evaluatorLogger);
        this.mName = string;
        this.mInParamCount = n;
        this.mNonrelationalValueFactory = iNonrelationalValueFactory;
        this.mType = evaluatorType;
    }

    @Override
    public Collection<IEvaluationResult<VALUE>> evaluate(STATE STATE) {
        assert (STATE != null);
        return Collections.singletonList(new NonrelationalEvaluationResult<VALUE>(this.mNonrelationalValueFactory.createTopValue(), BooleanValue.TOP));
    }

    @Override
    public Collection<STATE> inverseEvaluate(IEvaluationResult<VALUE> iEvaluationResult, STATE STATE) {
        assert (STATE != null);
        return Collections.singletonList(STATE);
    }

    @Override
    public boolean hasFreeOperands() {
        return this.getNumberOfSubEvaluators() < this.mInParamCount;
    }

    @Override
    public boolean containsBool() {
        return false;
    }

    public int getNumberOfInParams() {
        return this.mInParamCount;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mName).append('(');
        int n = 0;
        while (n < this.getNumberOfSubEvaluators()) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getSubEvaluator(n));
            ++n;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public EvaluatorUtils.EvaluatorType getType() {
        return this.mType;
    }
}

