/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public final class MinimizeDfaHopcroftLists<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private static final int INITIAL_BLOCK_AMOUNT = 2;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private int mBlockId;
    private final LinkedList<LinkedHashSet<Integer>> mBlocks = new LinkedList();
    private final HashMap<LinkedHashSet<Integer>, Integer> mBlockToId;
    private final HashMap<Integer, LinkedHashSet<Integer>> mIdToBlock;
    private final HashMap<Integer, STATE> mIdToState;
    private final HashMap<LETTER, Integer> mLetterToId;
    private final HashMap<Integer, Integer> mStateToBlockId;
    private final HashMap<STATE, Integer> mStateToId;
    private final HashMap<Integer, Iterable<IncomingInternalTransition<LETTER, STATE>>> mStateToIncomingEdges;

    public MinimizeDfaHopcroftLists(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl) {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        if (!this.isFiniteAutomaton()) {
            throw new UnsupportedOperationException("This class only supports minimization of finite automata.");
        }
        this.mBlockToId = new HashMap(2);
        this.mIdToBlock = new HashMap(2);
        int n = iNestedWordAutomaton.getStates().size();
        this.mIdToState = new HashMap(n);
        this.mStateToId = new HashMap(n);
        this.mStateToBlockId = new HashMap(n);
        this.mStateToIncomingEdges = new HashMap(n);
        int n2 = iNestedWordAutomaton.getVpAlphabet().getInternalAlphabet().size();
        this.mLetterToId = new HashMap(n2);
        this.init(n, n2);
        this.minimizeIcdfa(partitionBackedSetOfPairs, bl);
        this.printExitMessage();
    }

    public MinimizeDfaHopcroftLists(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, null, false);
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    private void buildMinimizedAutomaton(boolean bl) {
        Object object;
        Object object2;
        int n;
        int n2;
        LinkedList<STATE> linkedList = new LinkedList<STATE>();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = bl ? new HashMap() : null;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Object object4 : this.mOperand.getInitialStates()) {
            hashSet.add(this.mStateToBlockId.get(this.mStateToId.get(object4)));
        }
        this.startResultConstruction();
        for (LinkedHashSet linkedHashSet : this.mBlocks) {
            if (linkedHashSet == null || linkedHashSet.isEmpty()) continue;
            ArrayList<STATE> arrayList = new ArrayList<STATE>(linkedHashSet.size());
            Iterator iterator = linkedHashSet.iterator();
            n2 = (Integer)((Object)iterator.next());
            n = this.mBlockToId.get(linkedHashSet);
            object2 = this.mIdToState.get(n2);
            linkedList.add(object2);
            arrayList.add(object2);
            while (iterator.hasNext()) {
                arrayList.add(this.mIdToState.get(iterator.next()));
            }
            object = this.mStateFactory.merge(arrayList);
            hashMap.put(n, object);
            this.addState(hashSet.contains(n), this.mOperand.isFinal(object2), object);
            if (!bl) continue;
            for (Object object3 : arrayList) {
                hashMap2.put(object3, object);
            }
        }
        for (Object e : linkedList) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(e)) {
                Object object3;
                n2 = this.mStateToId.get(e);
                n = this.mStateToId.get(outgoingInternalTransition.getSucc());
                object2 = hashMap.get(this.mStateToBlockId.get(n2));
                object = outgoingInternalTransition.getLetter();
                object3 = hashMap.get(this.mStateToBlockId.get(n));
                this.addInternalTransition(object2, object, object3);
            }
        }
        this.finishResultConstruction(hashMap2, true);
    }

    private int getUniqueBlocKId() {
        int n = this.mBlockId++;
        return n;
    }

    private void init(int n, int n2) {
        int n3 = n;
        if (n < n2) {
            n3 = n2;
        }
        Iterator<STATE> iterator = this.mOperand.getStates().iterator();
        Iterator iterator2 = this.mOperand.getVpAlphabet().getInternalAlphabet().iterator();
        int n4 = 0;
        while (n4 < n3) {
            Object object;
            if (iterator.hasNext()) {
                object = iterator.next();
                this.mIdToState.put(n4, object);
                this.mStateToId.put(object, n4);
                this.mStateToIncomingEdges.put(n4, this.mOperand.internalPredecessors(object));
            }
            if (iterator2.hasNext()) {
                object = iterator2.next();
                this.mLetterToId.put(object, n4);
            }
            ++n4;
        }
    }

    private void minimizeIcdfa(PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        Set<STATE> set = this.mStateToId.keySet();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (partitionBackedSetOfPairs == null) {
            for (STATE STATE : set) {
                if (this.mOperand.isFinal(STATE)) {
                    linkedList.add(this.mStateToId.get(STATE));
                    continue;
                }
                linkedList2.add(this.mStateToId.get(STATE));
            }
            int n = -1;
            boolean bl2 = linkedList != null && !linkedList.isEmpty();
            LinkedHashSet linkedHashSet2 = null;
            if (bl2) {
                n = this.getUniqueBlocKId();
                linkedHashSet2 = new LinkedHashSet(linkedList);
                this.mBlockToId.put(linkedHashSet2, n);
                this.mIdToBlock.put(n, linkedHashSet2);
            }
            int n2 = -1;
            boolean bl3 = linkedList2 != null && !linkedList2.isEmpty();
            Object object = null;
            if (bl3) {
                n2 = this.getUniqueBlocKId();
                object = new LinkedHashSet(linkedList2);
                this.mBlockToId.put((LinkedHashSet<Integer>)object, n2);
                this.mIdToBlock.put(n2, (LinkedHashSet<Integer>)object);
            }
            for (STATE STATE : set) {
                if (this.mOperand.isFinal(STATE)) {
                    this.mStateToBlockId.put(this.mStateToId.get(STATE), n);
                    continue;
                }
                this.mStateToBlockId.put(this.mStateToId.get(STATE), n2);
            }
            if (bl2) {
                this.mBlocks.add(linkedHashSet2);
            }
            if (bl3) {
                this.mBlocks.add((LinkedHashSet<Integer>)object);
            }
            if (bl2) {
                linkedHashSet.add(linkedHashSet2);
            }
            if (bl3) {
                linkedHashSet.add(object);
            }
        } else {
            Iterator iterator = partitionBackedSetOfPairs.getRelation().iterator();
            while (iterator.hasNext()) {
                Object object2;
                Set set2 = (Set)iterator.next();
                LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
                int n = this.getUniqueBlocKId();
                for (Object object2 : set2) {
                    int n3 = this.mStateToId.get(object2);
                    linkedList3.add(n3);
                    this.mStateToBlockId.put(n3, n);
                }
                object2 = new LinkedHashSet(linkedList3);
                this.mBlockToId.put((LinkedHashSet<Integer>)object2, n);
                this.mIdToBlock.put(n, (LinkedHashSet<Integer>)object2);
                linkedHashSet.add(object2);
            }
        }
        while (!linkedHashSet.isEmpty()) {
            Iterator iterator = linkedHashSet.iterator();
            LinkedHashSet linkedHashSet3 = (LinkedHashSet)iterator.next();
            boolean bl4 = false;
            while (linkedHashSet3 == null || this.mBlockToId.get(linkedHashSet3) == null) {
                if (iterator.hasNext()) {
                    linkedHashSet.remove(linkedHashSet3);
                    iterator = linkedHashSet.iterator();
                    linkedHashSet3 = (LinkedHashSet)iterator.next();
                    continue;
                }
                bl4 = true;
                break;
            }
            if (bl4) break;
            linkedHashSet.remove(linkedHashSet3);
            LinkedList<LinkedHashSet<Integer>> linkedList4 = this.split(linkedHashSet3, this.mOperand.getVpAlphabet().getInternalAlphabet().size());
            linkedHashSet.addAll(linkedList4);
        }
        this.buildMinimizedAutomaton(bl);
    }

    /*
     * WARNING - void declaration
     */
    private LinkedList<LinkedHashSet<Integer>> split(LinkedHashSet<Integer> linkedHashSet, int n) {
        void var14_33;
        AbstractCollection abstractCollection2;
        Serializable serializable;
        void var13_24;
        Object object;
        int n2;
        int n3;
        int n4;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        HashMap<Integer, LinkedList> hashMap = new HashMap<Integer, LinkedList>();
        HashMap<Integer, LinkedList> hashMap2 = new HashMap<Integer, LinkedList>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
        HashMap<Integer, LinkedList> hashMap3 = new HashMap<Integer, LinkedList>();
        LinkedList<LinkedList<LinkedHashSet<Integer>>> linkedList4 = new LinkedList<LinkedList<LinkedHashSet<Integer>>>();
        HashMap<LinkedList<LinkedHashSet<Integer>>, LinkedList> hashMap4 = new HashMap<LinkedList<LinkedHashSet<Integer>>, LinkedList>();
        Iterator object22 = linkedHashSet.iterator();
        while (object22.hasNext()) {
            n4 = (Integer)object22.next();
            for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : this.mStateToIncomingEdges.get(n4)) {
                n3 = this.mStateToId.get(incomingInternalTransition.getPred());
                n2 = this.mLetterToId.get(incomingInternalTransition.getLetter());
                if (!hashMap.containsKey(n2)) {
                    hashMap.put(n2, new LinkedList());
                    linkedList.add(n2);
                }
                object = (LinkedList)hashMap.get(n2);
                ((LinkedList)object).add(n3);
                hashMap.put(n2, (LinkedList)object);
            }
        }
        n4 = 0;
        for (Integer hashMap5 : linkedList) {
            for (Integer n5 : (LinkedList)hashMap.get(hashMap5)) {
                if (!hashMap2.containsKey(n5)) {
                    hashMap2.put(n5, new LinkedList());
                    linkedList2.add(n5);
                }
                LinkedList linkedList5 = (LinkedList)hashMap2.get(n5);
                linkedList5.add(hashMap5);
                hashMap2.put(n5, linkedList5);
                if (linkedList5.size() <= n4) continue;
                n4 = linkedList5.size();
            }
        }
        hashMap.clear();
        linkedList.clear();
        for (Integer n6 : linkedList2) {
            int n7 = this.mStateToBlockId.get(n6);
            if (!hashMap3.containsKey(n7)) {
                hashMap3.put(n7, new LinkedList());
                linkedList3.add(n7);
            }
            LinkedList linkedList6 = (LinkedList)hashMap3.get(n7);
            linkedList6.add(n6);
            hashMap3.put(n7, linkedList6);
        }
        linkedList2.clear();
        Iterator iterator = linkedList3.iterator();
        while (iterator.hasNext()) {
            int n8 = (Integer)iterator.next();
            linkedList2.addAll((Collection)hashMap3.get(n8));
        }
        hashMap3.clear();
        HashMap<Integer, Object> hashMap5 = new HashMap<Integer, Object>();
        boolean bl = false;
        while (var13_24 < n4) {
            for (Integer n9 : linkedList2) {
                LinkedList linkedList7 = (LinkedList)hashMap2.get(n9);
                object = null;
                if (!hashMap5.containsKey(n9)) {
                    object = linkedList7.iterator();
                    hashMap5.put(n9, object);
                } else {
                    object = (Iterator)hashMap5.get(n9);
                }
                if (!object.hasNext()) continue;
                serializable = (Integer)object.next();
                if (!hashMap4.containsKey(serializable)) {
                    hashMap4.put((LinkedList<LinkedHashSet<Integer>>)serializable, new LinkedList());
                    linkedList4.add((LinkedList<LinkedHashSet<Integer>>)serializable);
                }
                abstractCollection2 = (LinkedList)hashMap4.get(serializable);
                ((LinkedList)abstractCollection2).add(n9);
                hashMap4.put((LinkedList<LinkedHashSet<Integer>>)serializable, (LinkedList)abstractCollection2);
            }
            linkedList2.clear();
            for (Integer n10 : linkedList4) {
                linkedList2.addAll((Collection)hashMap4.get(n10));
            }
            ++var13_24;
        }
        linkedList4.clear();
        LinkedHashMap<Integer, Object> linkedHashMap = new LinkedHashMap<Integer, Object>(this.mBlocks.size());
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        n3 = -1;
        n2 = -1;
        serializable = linkedList2.iterator();
        while (serializable.hasNext()) {
            int n11 = (Integer)serializable.next();
            n2 = this.mStateToBlockId.get(n11);
            if (n2 != n3) {
                if (!var14_33.isEmpty()) {
                    if (linkedHashMap.get(n3) == null) {
                        linkedHashMap.put(n3, var14_33);
                    } else {
                        abstractCollection2 = (LinkedHashSet)linkedHashMap.get(n3);
                        abstractCollection2.addAll(var14_33);
                        linkedHashMap.put(n3, abstractCollection2);
                    }
                }
                LinkedHashSet linkedHashSet3 = new LinkedHashSet();
            }
            var14_33.add(n11);
            n3 = n2;
        }
        if (!var14_33.isEmpty()) {
            if (linkedHashMap.get(n2) == null) {
                linkedHashMap.put(n2, var14_33);
            } else {
                LinkedHashSet linkedHashSet4 = (LinkedHashSet)linkedHashMap.get(n2);
                linkedHashSet4.addAll(var14_33);
                linkedHashMap.put(n2, linkedHashSet4);
            }
        }
        Object var14_35 = null;
        int n12 = this.mBlockToId.get(linkedHashSet);
        serializable = new LinkedList<LinkedHashSet<Integer>>();
        for (AbstractCollection abstractCollection2 : linkedHashMap.values()) {
            AbstractCollection abstractCollection3;
            LinkedList linkedList8 = new LinkedList();
            LinkedHashSet<Integer> linkedHashSet5 = new LinkedHashSet<Integer>();
            LinkedList linkedList9 = null;
            Object object2 = ((HashSet)abstractCollection2).iterator();
            while (object2.hasNext()) {
                int n13 = (Integer)object2.next();
                abstractCollection3 = (LinkedList)hashMap2.get(n13);
                if (!abstractCollection3.equals(linkedList9)) {
                    if (!linkedHashSet5.isEmpty()) {
                        linkedList8.add(linkedHashSet5);
                    }
                    linkedHashSet5 = new LinkedHashSet();
                }
                linkedHashSet5.add(n13);
                linkedList9 = abstractCollection3;
            }
            linkedList8.add(linkedHashSet5);
            linkedHashSet5 = null;
            LinkedHashSet<Integer> linkedHashSet6 = this.mIdToBlock.get(this.mStateToBlockId.get(((HashSet)abstractCollection2).iterator().next()));
            if (!((AbstractSet)abstractCollection2).equals(linkedHashSet6)) {
                object2 = new HashSet();
                Iterator iterator2 = linkedHashSet6.iterator();
                while (iterator2.hasNext()) {
                    int n14 = (Integer)iterator2.next();
                    if (((HashSet)abstractCollection2).contains(n14)) continue;
                    ((HashSet)object2).add(n14);
                }
                if (!((HashSet)object2).isEmpty()) {
                    linkedList8.add(new LinkedHashSet(object2));
                }
            }
            if (linkedList8.size() <= 1) continue;
            int n15 = this.mBlockToId.get(linkedHashSet6);
            this.mIdToBlock.remove(n15);
            this.mBlockToId.remove(linkedHashSet6);
            this.mBlocks.remove(linkedHashSet6);
            linkedHashSet6 = null;
            abstractCollection3 = null;
            for (LinkedHashSet linkedHashSet7 : linkedList8) {
                int n16 = this.getUniqueBlocKId();
                this.mIdToBlock.put(n16, linkedHashSet7);
                this.mBlockToId.put(linkedHashSet7, n16);
                this.mBlocks.add(linkedHashSet7);
                Iterator iterator3 = linkedHashSet7.iterator();
                while (iterator3.hasNext()) {
                    int n17 = (Integer)iterator3.next();
                    this.mStateToBlockId.put(n17, n16);
                }
                serializable.add(linkedHashSet7);
                if (linkedHashSet7.size() <= -1) continue;
                abstractCollection3 = linkedHashSet7;
            }
            if (n15 != n12) continue;
            serializable.remove(abstractCollection3);
        }
        return serializable;
    }
}

